/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Formats;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.quic.StunConnector;
import com.intellij.platform.split.connection.network.quic.StunTurnUrl;
import com.intellij.platform.split.connection.network.turn.attribute.TurnAttributeCollector;
import com.intellij.platform.split.connection.network.turn.message.request.TurnRequestCreator;
import com.jetbrains.rd.platform.codeWithMe.util.ThreadUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.coroutines.time.TimeKt;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J8\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0018J4\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/split/connection/network/quic/StunConnector;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "stunStack", "Lorg/ice4j/stack/StunStack;", "maintainStunServerConnection", "Ljava/util/concurrent/CompletableFuture;", "Ljava/net/InetSocketAddress;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "socket", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "stunTurnUrl", "Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl;", "pingDelay", "Ljava/time/Duration;", "getStunnedAddress", "servers", "", "timeout", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/util/List;Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addStunPacketsHandler", "", "socketWrapper", "handler", "Lkotlin/Function1;", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nStunConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunConnector.kt\ncom/intellij/platform/split/connection/network/quic/StunConnector\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,180:1\n155#2,3:181\n159#2,2:195\n1586#3:184\n1661#3,2:185\n1663#3:192\n60#4,5:187\n67#4,4:197\n67#4,4:201\n67#4,4:205\n67#4,4:209\n37#5,2:193\n*S KotlinDebug\n*F\n+ 1 StunConnector.kt\ncom/intellij/platform/split/connection/network/quic/StunConnector\n*L\n107#1:181,3\n107#1:195,2\n109#1:184\n109#1:185,2\n109#1:192\n110#1:187,5\n71#1:197,4\n83#1:201,4\n114#1:205,4\n170#1:209,4\n126#1:193,2\n*E\n"})
public final class StunConnector {
    @NotNull
    public static final StunConnector INSTANCE = new StunConnector();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final StunStack stunStack;

    private StunConnector() {
    }

    @NotNull
    public final CompletableFuture<InetSocketAddress> maintainStunServerConnection(@NotNull Lifetime lifetime, @NotNull IDatagramSocketWrapper socket, @NotNull StunTurnUrl stunTurnUrl, @NotNull Duration pingDelay) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)stunTurnUrl, (String)"stunTurnUrl");
        Intrinsics.checkNotNullParameter((Object)pingDelay, (String)"pingDelay");
        CompletableFuture<InetSocketAddress> result = new CompletableFuture<InetSocketAddress>();
        String threadName = "Ping STUN server from " + socket.getLocalAddress();
        Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)threadName, (int)0, () -> StunConnector.maintainStunServerConnection$lambda$0(stunTurnUrl, lifetime, threadName, socket, pingDelay, result), (int)21, null);
        lifetime.onTermination(() -> StunConnector.maintainStunServerConnection$lambda$1(thread));
        return result;
    }

    public static /* synthetic */ CompletableFuture maintainStunServerConnection$default(StunConnector stunConnector, Lifetime lifetime, IDatagramSocketWrapper iDatagramSocketWrapper, StunTurnUrl stunTurnUrl, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        return stunConnector.maintainStunServerConnection(lifetime, iDatagramSocketWrapper, stunTurnUrl, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getStunnedAddress(@NotNull Lifetime lifetime, @NotNull List<StunTurnUrl> servers, @NotNull IDatagramSocketWrapper socket, @NotNull Duration timeout, @NotNull Continuation<? super InetSocketAddress> $completion) {
        if (!($completion instanceof getStunnedAddress.1)) ** GOTO lbl-1000
        var33_6 = $completion;
        if ((var33_6.label & -2147483648) != 0) {
            var33_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                long J$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ StunConnector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getStunnedAddress(null, null, null, null, (Continuation<? super InetSocketAddress>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var34_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                firstRespondedServerFuture = new CompletableFuture<InetSocketAddress>();
                getStunnedAddressStartTime = System.currentTimeMillis();
                this_$iv = lifetime;
                $i$f$usingNested = 0;
                nested$iv = this_$iv.createNested();
                pingLifetime = nested$iv.getLifetime();
                $i$a$-usingNested-StunConnector$getStunnedAddress$2 = 0;
                $this$map$iv = (CompletableFuture[])servers;
                $i$f$map = false;
                var16_25 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_32 = (StunTurnUrl)item$iv$iv;
                    var22_33 = destination$iv$iv;
                    $i$a$-map-StunConnector$getStunnedAddress$2$getStunnedAddressFutures$1 = false;
                    $this$debug_u24default$iv = StunConnector.logger;
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var27_38 = $this$debug_u24default$iv;
                        $i$a$-debug$default-StunConnector$getStunnedAddress$2$getStunnedAddressFutures$1$1 = false;
                        var27_38.debug("Getting stunned address from server: " + (StunTurnUrl)stunServer, t$iv);
                    }
                    getStunnedAddressFuture = StunConnector.maintainStunServerConnection$default(StunConnector.INSTANCE, pingLifetime, socket, (StunTurnUrl)stunServer, null, 8, null);
                    var22_33.add(getStunnedAddressFuture.whenComplete((BiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, getStunnedAddress$lambda$0$0$2(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getStunnedAddress$lambda$0$0$1(com.intellij.platform.split.connection.network.quic.StunTurnUrl long java.util.concurrent.CompletableFuture java.net.InetSocketAddress java.lang.Throwable ), (Ljava/net/InetSocketAddress;Ljava/lang/Throwable;)Lkotlin/Unit;)((StunTurnUrl)stunServer, (long)getStunnedAddressStartTime, firstRespondedServerFuture))));
                }
                getStunnedAddressFutures = (List)destination$iv$iv;
                $this$toTypedArray$iv = getStunnedAddressFutures;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                $this$map$iv = thisCollection$iv.toArray(new CompletableFuture[0]);
                CompletableFuture.allOf(Arrays.copyOf($this$map$iv, $this$map$iv.length)).whenComplete((BiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, getStunnedAddress$lambda$0$2(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getStunnedAddress$lambda$0$1(java.util.concurrent.CompletableFuture java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)Lkotlin/Unit;)(firstRespondedServerFuture)));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)lifetime);
                $continuation.L$1 = servers;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)socket);
                $continuation.L$3 = timeout;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(firstRespondedServerFuture);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$6 = nested$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)pingLifetime);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)getStunnedAddressFutures);
                $continuation.J$0 = getStunnedAddressStartTime;
                $continuation.I$0 = $i$f$usingNested;
                $continuation.I$1 = $i$a$-usingNested-StunConnector$getStunnedAddress$2;
                $continuation.label = 1;
                v0 = TimeKt.withTimeout((Duration)timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InetSocketAddress>, Object>(firstRespondedServerFuture, null){
                    int label;
                    final /* synthetic */ CompletableFuture<InetSocketAddress> $firstRespondedServerFuture;
                    {
                        this.$firstRespondedServerFuture = $firstRespondedServerFuture;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = FutureKt.await((CompletionStage)this.$firstRespondedServerFuture, (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super InetSocketAddress> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var34_8) goto lbl68
lbl67:
                // 1 sources

                return var34_8;
lbl68:
                // 1 sources

                ** GOTO lbl87
            }
            case 1: {
                $i$a$-usingNested-StunConnector$getStunnedAddress$2 = $continuation.I$1;
                $i$f$usingNested = $continuation.I$0;
                getStunnedAddressStartTime = $continuation.J$0;
                getStunnedAddressFutures = (List)$continuation.L$8;
                pingLifetime = (Lifetime)$continuation.L$7;
                nested$iv = (LifetimeDefinition)$continuation.L$6;
                this_$iv = (Lifetime)$continuation.L$5;
                firstRespondedServerFuture = (CompletableFuture)$continuation.L$4;
                timeout = (Duration)$continuation.L$3;
                socket = (IDatagramSocketWrapper)$continuation.L$2;
                servers = (List)$continuation.L$1;
                lifetime = (Lifetime)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl87:
                    // 2 sources

                    var15_24 = (InetSocketAddress)v0;
                    {
                        catch (TimeoutCancellationException t) {
                            StunConnector.logger.info("Timeout getting stunned for local address after: " + Formats.formatDuration((Duration)timeout));
                            var15_24 = null;
                        }
                    }
                    stunnedAddress = var15_24;
                    if (stunnedAddress == null) {
                        StunConnector.logger.info("Unable to get stunned address using STUN servers: " + servers);
                    }
                    var30_42 = stunnedAddress;
                }
                catch (Throwable var31_43) {
                    throw var31_43;
                }
                finally {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)nested$iv, (boolean)false, (int)1, null);
                }
                return var30_42;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getStunnedAddress$default(StunConnector stunConnector, Lifetime lifetime, List list, IDatagramSocketWrapper iDatagramSocketWrapper, Duration duration, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofSeconds(4L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        return stunConnector.getStunnedAddress(lifetime, list, iDatagramSocketWrapper, duration, (Continuation<? super InetSocketAddress>)continuation);
    }

    private final void addStunPacketsHandler(Lifetime lifetime, IDatagramSocketWrapper socketWrapper, StunTurnUrl stunTurnUrl, Function1<? super InetSocketAddress, Unit> handler) {
        Ref.BooleanRef loggedMappedAddress = new Ref.BooleanRef();
        InetSocketAddress stunServerAddress = new InetSocketAddress(InetAddress.getByName(stunTurnUrl.getHost()), stunTurnUrl.getPortNotNull());
        socketWrapper.adviseOnSpecificAddressPackets(lifetime, stunServerAddress, (Function1<? super byte[], Unit>)((Function1)arg_0 -> StunConnector.addStunPacketsHandler$lambda$0(loggedMappedAddress, stunTurnUrl, handler, arg_0)));
    }

    private static final Unit maintainStunServerConnection$lambda$0$0(CompletableFuture $result, InetSocketAddress inetAddress) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        $result.complete(inetAddress);
        return Unit.INSTANCE;
    }

    private static final Request maintainStunServerConnection$lambda$0$1(TransactionID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Request request2 = MessageFactory.createBindingRequest();
        request2.putAttribute((Attribute)AttributeFactory.createChangeRequestAttribute());
        Intrinsics.checkNotNull((Object)request2);
        return request2;
    }

    private static final Unit maintainStunServerConnection$lambda$0(StunTurnUrl $stunTurnUrl, Lifetime $lifetime, String $threadName, IDatagramSocketWrapper $socket, Duration $pingDelay, CompletableFuture $result) {
        try {
            logger.info("Pinging STUN server: " + $stunTurnUrl);
            InetSocketAddress stunServerAddress = new InetSocketAddress(InetAddress.getByName($stunTurnUrl.getHost()), $stunTurnUrl.getPortNotNull());
            if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
                logger.debug($threadName + ": lifetime was already terminated. Exiting STUN ping thread");
                return Unit.INSTANCE;
            }
            INSTANCE.addStunPacketsHandler($lifetime, $socket, $stunTurnUrl, (Function1<? super InetSocketAddress, Unit>)((Function1)arg_0 -> StunConnector.maintainStunServerConnection$lambda$0$0($result, arg_0)));
            Request request2 = (Request)TurnRequestCreator.INSTANCE.create("Binding Request", StunConnector::maintainStunServerConnection$lambda$0$1);
            byte[] bindingRequestBytes = request2.encode(stunStack);
            while (RLifetimeKt.isAlive((Lifetime)$lifetime) && !Thread.interrupted()) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Sending " + $stunTurnUrl.getProtocol().name() + " packet from " + $socket.getLocalAddress() + " to " + stunServerAddress);
                }
                try {
                    Intrinsics.checkNotNull((Object)bindingRequestBytes);
                    $socket.send(bindingRequestBytes, stunServerAddress);
                }
                catch (Throwable t) {
                    logger.debug("Unable to send " + $stunTurnUrl.getProtocol().name() + " packet: " + $socket.getLocalAddress() + " -> " + stunServerAddress + ": " + t.getMessage(), t);
                }
                Thread.sleep($pingDelay.toMillis());
            }
        }
        catch (InterruptedException interruptedException) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace($threadName + ": Interrupt request");
            }
        }
        catch (Throwable t) {
            logger.error($threadName + ": " + t.getMessage(), t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit maintainStunServerConnection$lambda$1(Thread $thread) {
        ThreadUtil.INSTANCE.gracefullyJoinThread($thread);
        return Unit.INSTANCE;
    }

    private static final Unit getStunnedAddress$lambda$0$0$1(StunTurnUrl $stunServer, long $getStunnedAddressStartTime, CompletableFuture $firstRespondedServerFuture, InetSocketAddress stunnedAddress2, Throwable throwable) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got peer stunned address: " + stunnedAddress2);
        }
        if (throwable != null) {
            logger.error("Error on getting stunned address via STUN server '" + $stunServer + "'", throwable);
            return Unit.INSTANCE;
        }
        logger.info("Got external address '" + stunnedAddress2 + "' via STUN server '" + $stunServer + "' in " + (System.currentTimeMillis() - $getStunnedAddressStartTime) + " ms");
        $firstRespondedServerFuture.complete(stunnedAddress2);
        return Unit.INSTANCE;
    }

    private static final void getStunnedAddress$lambda$0$0$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit getStunnedAddress$lambda$0$1(CompletableFuture $firstRespondedServerFuture, Void void_, Throwable throwable) {
        if (throwable != null) {
            $firstRespondedServerFuture.complete(null);
        }
        return Unit.INSTANCE;
    }

    private static final void getStunnedAddress$lambda$0$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addStunPacketsHandler$lambda$0(Ref.BooleanRef $loggedMappedAddress, StunTurnUrl $stunTurnUrl, Function1 $handler, byte[] packetBytes) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)packetBytes, (String)"packetBytes");
        try {
            message = Message.decode((byte[])packetBytes, (int)0, (int)packetBytes.length);
            Intrinsics.checkNotNull((Object)message);
        }
        catch (StunException e) {
            logger.warn("Can't parse STUN message, probably channel data message, but channel bind response not received", (Throwable)e);
            return Unit.INSTANCE;
        }
        Message receivedMH = message;
        Attribute attribute = receivedMH.getAttribute('\u0001');
        MappedAddressAttribute mappedAddressAttribute = attribute instanceof MappedAddressAttribute ? (MappedAddressAttribute)attribute : null;
        if (mappedAddressAttribute == null || (mappedAddressAttribute = mappedAddressAttribute.getAddress()) == null) {
            mappedAddressAttribute = TurnAttributeCollector.INSTANCE.getMappedAddress(receivedMH);
        }
        MappedAddressAttribute receiveMA = mappedAddressAttribute;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(receiveMA.getAddress(), receiveMA.getPort());
        if ($loggedMappedAddress.element) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Mapped address from " + $stunTurnUrl.getProtocol().name() + " server is received already: " + inetSocketAddress);
            }
        } else {
            logger.info("Received mapped address from " + $stunTurnUrl.getProtocol().name() + " server: " + inetSocketAddress);
            $loggedMappedAddress.element = true;
        }
        $handler.invoke((Object)inetSocketAddress);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        StunConnector.logger = logger;
        stunStack = new StunStack();
    }
}

