/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0003 !\"B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0014\u001a\u00020\u0005H\u0096\u0080\u0004J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0014\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001f\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl;", "", "protocol", "Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Protocol;", "host", "", "port", "", "transport", "Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Transport;", "<init>", "(Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Protocol;Ljava/lang/String;ILcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Transport;)V", "getProtocol", "()Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Protocol;", "getHost", "()Ljava/lang/String;", "getPort", "()I", "getTransport", "()Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Transport;", "toString", "portNotNull", "getPortNotNull", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "Transport", "Protocol", "Companion", "intellij.platform.split.connection"})
public final class StunTurnUrl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final Transport transport;
    public static final int DEFAULT_PORT = 3478;
    public static final int DEFAULT_TLS_PORT = 5349;
    @NotNull
    private static final Regex STUN_TURN_REGEX = new Regex("(?<scheme>stun|stuns|turn|turns)\\:(?<host>[^?:]+)(\\:(?<port>[0-9]+?))?(\\?transport=(?<transport>udp|tcp))?");

    public StunTurnUrl(@NotNull Protocol protocol, @NotNull String host, int port, @Nullable Transport transport) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.transport = transport;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final Transport getTransport() {
        return this.transport;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(switch (WhenMappings.$EnumSwitchMapping$0[this.protocol.ordinal()]) {
            case 1 -> "stun";
            case 2 -> "stuns";
            case 3 -> "turn";
            case 4 -> "turns";
            default -> throw new NoWhenBranchMatchedException();
        });
        sb.append(":");
        sb.append(this.host);
        if (this.port > 0) {
            sb.append(':');
            sb.append(this.port);
        }
        if (this.transport != null) {
            sb.append("?transport=");
            sb.append(switch (WhenMappings.$EnumSwitchMapping$1[this.transport.ordinal()]) {
                case 1 -> "tcp";
                case 2 -> "udp";
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int getPortNotNull() {
        if (this.port > 0) {
            return this.port;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.protocol.ordinal()]) {
            case 1 -> 3478;
            case 3 -> 3478;
            case 2 -> 5349;
            case 4 -> 5349;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Protocol component1() {
        return this.protocol;
    }

    @NotNull
    public final String component2() {
        return this.host;
    }

    public final int component3() {
        return this.port;
    }

    @Nullable
    public final Transport component4() {
        return this.transport;
    }

    @NotNull
    public final StunTurnUrl copy(@NotNull Protocol protocol, @NotNull String host, int port, @Nullable Transport transport) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new StunTurnUrl(protocol, host, port, transport);
    }

    public static /* synthetic */ StunTurnUrl copy$default(StunTurnUrl stunTurnUrl, Protocol protocol, String string, int n, Transport transport, int n2, Object object) {
        if ((n2 & 1) != 0) {
            protocol = stunTurnUrl.protocol;
        }
        if ((n2 & 2) != 0) {
            string = stunTurnUrl.host;
        }
        if ((n2 & 4) != 0) {
            n = stunTurnUrl.port;
        }
        if ((n2 & 8) != 0) {
            transport = stunTurnUrl.transport;
        }
        return stunTurnUrl.copy(protocol, string, n, transport);
    }

    public int hashCode() {
        int result = this.protocol.hashCode();
        result = result * 31 + this.host.hashCode();
        result = result * 31 + Integer.hashCode(this.port);
        result = result * 31 + (this.transport == null ? 0 : this.transport.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StunTurnUrl)) {
            return false;
        }
        StunTurnUrl stunTurnUrl = (StunTurnUrl)other;
        if (this.protocol != stunTurnUrl.protocol) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)stunTurnUrl.host)) {
            return false;
        }
        if (this.port != stunTurnUrl.port) {
            return false;
        }
        return this.transport == stunTurnUrl.transport;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Companion;", "", "<init>", "()V", "DEFAULT_PORT", "", "DEFAULT_TLS_PORT", "tryParse", "Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl;", "string", "", "STUN_TURN_REGEX", "Lkotlin/text/Regex;", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final StunTurnUrl tryParse(@NotNull String string) {
            Transport transport;
            String string2;
            Protocol protocol;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            MatchResult matchResult = STUN_TURN_REGEX.matchEntire((CharSequence)string);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"scheme");
            if (matchGroup == null) return null;
            String string3 = matchGroup.getValue();
            String string4 = string3;
            if (string4 == null) return null;
            int n = -1;
            switch (string4.hashCode()) {
                case 109776633: {
                    if (string4.equals("stuns")) {
                        n = 1;
                    }
                    break;
                }
                case 3571837: {
                    if (string4.equals("turn")) {
                        n = 2;
                    }
                    break;
                }
                case 3541178: {
                    if (string4.equals("stun")) {
                        n = 3;
                    }
                    break;
                }
                case 110727062: {
                    if (string4.equals("turns")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    protocol = Protocol.STUN;
                    break;
                }
                case 1: {
                    protocol = Protocol.STUNS;
                    break;
                }
                case 2: {
                    protocol = Protocol.TURN;
                    break;
                }
                case 4: {
                    protocol = Protocol.TURNS;
                    break;
                }
                default: {
                    return null;
                }
            }
            Protocol protocol2 = protocol;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"host");
            Object object = matchGroup2;
            if (matchGroup2 == null) return null;
            if ((object = object.getValue()) == null) {
                return null;
            }
            Object object2 = object;
            Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"port");
            int port = object3 != null && (object3 = object3.getValue()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"transport");
            String string5 = string2 = matchGroup3 != null ? matchGroup3.getValue() : null;
            if (string2 == null) {
                transport = null;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"udp")) {
                transport = Transport.UDP;
            } else {
                if (!Intrinsics.areEqual((Object)string2, (Object)"tcp")) return null;
                transport = Transport.TCP;
            }
            Transport transport2 = transport;
            return new StunTurnUrl(protocol2, (String)object2, port, transport2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Protocol;", "", "<init>", "(Ljava/lang/String;I)V", "STUN", "STUNS", "TURN", "TURNS", "intellij.platform.split.connection"})
    public static final class Protocol
    extends Enum<Protocol> {
        public static final /* enum */ Protocol STUN = new Protocol();
        public static final /* enum */ Protocol STUNS = new Protocol();
        public static final /* enum */ Protocol TURN = new Protocol();
        public static final /* enum */ Protocol TURNS = new Protocol();
        private static final /* synthetic */ Protocol[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Protocol[] values() {
            return (Protocol[])$VALUES.clone();
        }

        public static Protocol valueOf(String value) {
            return Enum.valueOf(Protocol.class, value);
        }

        @NotNull
        public static EnumEntries<Protocol> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = protocolArray = new Protocol[]{Protocol.STUN, Protocol.STUNS, Protocol.TURN, Protocol.TURNS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/network/quic/StunTurnUrl$Transport;", "", "<init>", "(Ljava/lang/String;I)V", "TCP", "UDP", "intellij.platform.split.connection"})
    public static final class Transport
    extends Enum<Transport> {
        public static final /* enum */ Transport TCP = new Transport();
        public static final /* enum */ Transport UDP = new Transport();
        private static final /* synthetic */ Transport[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Transport[] values() {
            return (Transport[])$VALUES.clone();
        }

        public static Transport valueOf(String value) {
            return Enum.valueOf(Transport.class, value);
        }

        @NotNull
        public static EnumEntries<Transport> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = transportArray = new Transport[]{Transport.TCP, Transport.UDP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Protocol.values().length];
            try {
                nArray[Protocol.STUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.STUNS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.TURN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.TURNS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Transport.values().length];
            try {
                nArray[Transport.TCP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transport.UDP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

