/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.DatagramSocketWrapper;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.TurnPacketEvent;
import com.intellij.platform.split.connection.network.turn.TurnDatagramSocketWrapperKt;
import com.intellij.platform.split.connection.network.turn.channel.TurnChannelPacketUtils;
import com.intellij.platform.split.connection.network.turn.data.ChannelInfo;
import com.intellij.platform.split.connection.network.turn.data.PermissionInfo;
import com.intellij.platform.split.connection.network.turn.message.indication.SendIndication;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.Indication;
import org.ice4j.message.Message;
import org.ice4j.stack.StunStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u001aJ5\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\u00102J*\u00103\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00032\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b04H\u0016J,\u00105\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00052\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0016J\u0018\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001aH\u0002J,\u0010;\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u001d2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\f\u0010=\u001a\u00020>*\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\"\u001a;\u0012\f\u0012\n $*\u0004\u0018\u00010\u001d0\u001d\u0012$\u0012\"\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001b $*\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00190\u00190#\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006?"}, d2={"Lcom/intellij/platform/split/connection/network/turn/TurnDatagramSocketWrapper;", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "turnServerAddress", "Ljava/net/InetSocketAddress;", "stunStack", "Lorg/ice4j/stack/StunStack;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/net/InetSocketAddress;Lorg/ice4j/stack/StunStack;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "socket", "Lcom/intellij/platform/split/connection/network/DatagramSocketWrapper;", "getSocket", "()Lcom/intellij/platform/split/connection/network/DatagramSocketWrapper;", "channelsByPeer", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/split/connection/network/turn/data/ChannelInfo;", "getChannelsByPeer", "()Ljava/util/concurrent/ConcurrentHashMap;", "permissionsByPeer", "Lcom/intellij/platform/split/connection/network/turn/data/PermissionInfo;", "getPermissionsByPeer", "advisesByPeer", "Lkotlin/Function1;", "", "", "peersByChannel", "", "getPeersByChannel", "remainingPacketsAdvise", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lcom/intellij/platform/split/connection/network/TurnPacketEvent;", "messageEvents", "Lcom/intellij/util/containers/MultiMap;", "kotlin.jvm.PlatformType", "Lorg/ice4j/message/Message;", "Lorg/jetbrains/annotations/NotNull;", "dispatchDataFromPeer", "peerAddress", "data", "localAddress", "getLocalAddress", "()Ljava/net/InetSocketAddress;", "adviseOnSpecificMessages", "adviseLifetime", "messageTypes", "", "handler", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;[Ljava/lang/Character;Lkotlin/jvm/functions/Function1;)V", "adviseOnRemainingPackets", "Lkotlin/Function2;", "adviseOnSpecificAddressPackets", "address", "send", "buffer", "turnServerPacketHandler", "packet", "adviseOnSpecificMessage", "messageType", "toHex", "", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTurnDatagramSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurnDatagramSocketWrapper.kt\ncom/intellij/platform/split/connection/network/turn/TurnDatagramSocketWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n67#2,4:145\n67#2,4:149\n67#2,4:153\n67#2,4:157\n60#2,5:161\n1915#3,2:166\n*S KotlinDebug\n*F\n+ 1 TurnDatagramSocketWrapper.kt\ncom/intellij/platform/split/connection/network/turn/TurnDatagramSocketWrapper\n*L\n85#1:145,4\n89#1:149,4\n92#1:153,4\n106#1:157,4\n123#1:161,5\n130#1:166,2\n*E\n"})
public final class TurnDatagramSocketWrapper
implements IDatagramSocketWrapper {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final InetSocketAddress turnServerAddress;
    @NotNull
    private final StunStack stunStack;
    @NotNull
    private final DatagramSocketWrapper socket;
    @NotNull
    private final ConcurrentHashMap<InetSocketAddress, ChannelInfo> channelsByPeer;
    @NotNull
    private final ConcurrentHashMap<InetSocketAddress, PermissionInfo> permissionsByPeer;
    @NotNull
    private final ConcurrentHashMap<InetSocketAddress, Function1<byte[], Unit>> advisesByPeer;
    @NotNull
    private final ConcurrentHashMap<Character, ChannelInfo> peersByChannel;
    @NotNull
    private final Signal<TurnPacketEvent> remainingPacketsAdvise;
    @NotNull
    private final MultiMap<Character, Function1<Message, Unit>> messageEvents;

    public TurnDatagramSocketWrapper(@NotNull Lifetime lifetime, @NotNull InetSocketAddress turnServerAddress, @NotNull StunStack stunStack) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)turnServerAddress, (String)"turnServerAddress");
        Intrinsics.checkNotNullParameter((Object)stunStack, (String)"stunStack");
        this.lifetime = lifetime;
        this.turnServerAddress = turnServerAddress;
        this.stunStack = stunStack;
        this.socket = new DatagramSocketWrapper(this.lifetime);
        this.channelsByPeer = new ConcurrentHashMap();
        this.permissionsByPeer = new ConcurrentHashMap();
        this.advisesByPeer = new ConcurrentHashMap();
        this.peersByChannel = new ConcurrentHashMap();
        this.remainingPacketsAdvise = new Signal();
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.messageEvents = multiMap;
        TurnDatagramSocketWrapperKt.access$getLogger$p().info("Create socket to TURN server: " + this.turnServerAddress);
        this.socket.adviseOnSpecificAddressPackets(this.lifetime, this.turnServerAddress, (Function1<? super byte[], Unit>)((Function1)arg_0 -> TurnDatagramSocketWrapper._init_$lambda$0(this, arg_0)));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final DatagramSocketWrapper getSocket() {
        return this.socket;
    }

    @NotNull
    public final ConcurrentHashMap<InetSocketAddress, ChannelInfo> getChannelsByPeer() {
        return this.channelsByPeer;
    }

    @NotNull
    public final ConcurrentHashMap<InetSocketAddress, PermissionInfo> getPermissionsByPeer() {
        return this.permissionsByPeer;
    }

    @NotNull
    public final ConcurrentHashMap<Character, ChannelInfo> getPeersByChannel() {
        return this.peersByChannel;
    }

    public final void dispatchDataFromPeer(@NotNull InetSocketAddress peerAddress, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Function1<byte[], Unit> specificAdvise = this.advisesByPeer.get(peerAddress);
        if (specificAdvise != null) {
            specificAdvise.invoke((Object)data);
            return;
        }
        this.remainingPacketsAdvise.fire((Object)new TurnPacketEvent(peerAddress, data));
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public final void adviseOnSpecificMessages(@NotNull Lifetime adviseLifetime, @NotNull Character[] messageTypes, @NotNull Function1<? super Message, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)adviseLifetime, (String)"adviseLifetime");
        Intrinsics.checkNotNullParameter((Object)messageTypes, (String)"messageTypes");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        int n = messageTypes.length;
        for (int i = 0; i < n; ++i) {
            char messageType = messageTypes[i].charValue();
            this.adviseOnSpecificMessage(adviseLifetime, messageType, handler);
        }
    }

    @Override
    public void adviseOnRemainingPackets(@NotNull Lifetime adviseLifetime, @NotNull Function2<? super InetSocketAddress, ? super byte[], Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)adviseLifetime, (String)"adviseLifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.remainingPacketsAdvise.advise(adviseLifetime, arg_0 -> TurnDatagramSocketWrapper.adviseOnRemainingPackets$lambda$0(handler, arg_0));
    }

    @Override
    public void adviseOnSpecificAddressPackets(@NotNull Lifetime adviseLifetime, @NotNull InetSocketAddress address, @NotNull Function1<? super byte[], Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)adviseLifetime, (String)"adviseLifetime");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        adviseLifetime.bracketIfAlive(() -> TurnDatagramSocketWrapper.adviseOnSpecificAddressPackets$lambda$0(this, address, handler), () -> TurnDatagramSocketWrapper.adviseOnSpecificAddressPackets$lambda$1(this, address));
    }

    @Override
    public void send(@NotNull byte[] buffer, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        ChannelInfo channelInfo = this.channelsByPeer.get(address);
        if (channelInfo != null) {
            Logger $this$trace$iv = TurnDatagramSocketWrapperKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Send data [Channel " + this.toHex(channelInfo.getChannelNumber()) + "] -> " + address);
            }
            this.socket.send(TurnChannelPacketUtils.INSTANCE.formatPacket(channelInfo.getChannelNumber(), buffer), this.turnServerAddress);
        } else if (Intrinsics.areEqual((Object)address, (Object)this.turnServerAddress)) {
            Logger $this$trace$iv = TurnDatagramSocketWrapperKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Send message [TURN server] -> " + address);
            }
            this.socket.send(buffer, address);
        } else {
            Logger $this$trace$iv = TurnDatagramSocketWrapperKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Send message [Send Indication] -> " + address);
            }
            TransportAddress peerAddress = new TransportAddress(address, Transport.UDP);
            Indication sendIndication = new SendIndication(peerAddress, buffer).create();
            byte[] byArray = sendIndication.encode(this.stunStack);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
            this.socket.send(byArray, this.turnServerAddress);
        }
    }

    private final void turnServerPacketHandler(byte[] packet) {
        Message packetData2;
        char channelNumber = TurnChannelPacketUtils.INSTANCE.getChannelNumberFromPacket(packet);
        if (this.peersByChannel.containsKey(Character.valueOf(channelNumber))) {
            ChannelInfo channelInfo = (ChannelInfo)MapsKt.getValue((Map)this.peersByChannel, (Object)Character.valueOf(channelNumber));
            byte[] packetData2 = TurnChannelPacketUtils.INSTANCE.getDataFromPacket(packet);
            Logger $this$trace$iv = TurnDatagramSocketWrapperKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Handling message as channel event for channel with info: " + channelInfo);
            }
            this.dispatchDataFromPeer(channelInfo.getPeerAddress(), packetData2);
            return;
        }
        try {
            packetData2 = Message.decode((byte[])packet, (int)0, (int)packet.length);
            Intrinsics.checkNotNull((Object)packetData2);
        }
        catch (StunException e) {
            TurnDatagramSocketWrapperKt.access$getLogger$p().warn("Can't parse STUN message, probably channel data message, but channel bind response not received", (Throwable)e);
            return;
        }
        Message message = packetData2;
        Collection collection = this.messageEvents.get((Object)Character.valueOf(message.getMessageType()));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection messageEventHandlers = collection;
        Logger $this$debug_u24default$iv = TurnDatagramSocketWrapperKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Handling package as a message of type " + this.toHex(message.getMessageType()) + " (handlers: " + messageEventHandlers.size() + ")", t$iv);
        }
        if (messageEventHandlers.isEmpty()) {
            TurnDatagramSocketWrapperKt.access$getLogger$p().warn("Unhandled packet from turn server messageType " + this.toHex(message.getMessageType()));
            return;
        }
        Iterable $this$forEach$iv = messageEventHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 handler = (Function1)element$iv;
            boolean bl = false;
            handler.invoke((Object)message);
        }
    }

    private final void adviseOnSpecificMessage(Lifetime adviseLifetime, char messageType, Function1<? super Message, Unit> handler) {
        adviseLifetime.bracketIfAlive(() -> TurnDatagramSocketWrapper.adviseOnSpecificMessage$lambda$0(this, messageType, handler), () -> TurnDatagramSocketWrapper.adviseOnSpecificMessage$lambda$1(this, messageType, handler));
    }

    private final String toHex(char $this$toHex) {
        String string = "0x%04x";
        Object[] objectArray = new Object[]{(short)$this$toHex};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final Unit _init_$lambda$0(TurnDatagramSocketWrapper this$0, byte[] packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this$0.turnServerPacketHandler(packet);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnRemainingPackets$lambda$0(Function2 $handler, TurnPacketEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $handler.invoke((Object)it.getAddress(), (Object)it.getData());
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificAddressPackets$lambda$0(TurnDatagramSocketWrapper this$0, InetSocketAddress $address, Function1 $handler) {
        ((Map)this$0.advisesByPeer).put($address, $handler);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificAddressPackets$lambda$1(TurnDatagramSocketWrapper this$0, InetSocketAddress $address) {
        this$0.advisesByPeer.remove($address);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificMessage$lambda$0(TurnDatagramSocketWrapper this$0, char $messageType, Function1 $handler) {
        this$0.messageEvents.putValue((Object)Character.valueOf($messageType), (Object)$handler);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificMessage$lambda$1(TurnDatagramSocketWrapper this$0, char $messageType, Function1 $handler) {
        this$0.messageEvents.remove((Object)Character.valueOf($messageType), (Object)$handler);
        return Unit.INSTANCE;
    }
}

