/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel.frame;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.ConnectionDeclineReason;
import com.intellij.platform.split.connection.protocol.WireConnectStatus;
import com.intellij.platform.split.connection.protocol.channel.frame.AcceptedFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.CurrentConfirmationFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.DeclinedFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.ForceTerminateWireFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactoryKt;
import com.intellij.platform.split.connection.protocol.channel.frame.JoinPinFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.MessageFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.PasswordRequiredFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.PingFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.SessionTokenFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemMessageFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.TransportAcceptanceFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.TransportIndexFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.WireExistFrame;
import com.intellij.util.io.IoKt;
import com.jetbrains.rd.platform.codeWithMe.util.ByteArrayUtilsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u0002H!\"\n\b\u0000\u0010!\u0018\u0001*\u00020\f*\u00020\fH\u0086\b\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u0004\u0018\u0001H!\"\n\b\u0000\u0010!\u0018\u0001*\u00020\f*\u00020\fH\u0086\b\u00a2\u0006\u0002\u0010\"J\u0019\u0010$\u001a\u00020\u0012\"\n\b\u0000\u0010!\u0018\u0001*\u00020\f*\u00020\fH\u0086\bJ\n\u0010%\u001a\u00020&*\u00020\u0005J\n\u0010'\u001a\u00020\f*\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/frame/FrameFactory;", "", "<init>", "()V", "WIRE_STATE_VALUE_BUFFER_SIZE", "", "INT_VALUE_BUFFER_SIZE", "PING_FRAME", "Lcom/intellij/platform/split/connection/protocol/channel/frame/PingFrame;", "getPING_FRAME", "()Lcom/intellij/platform/split/connection/protocol/channel/frame/PingFrame;", "getFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "createWireExistFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/WireExistFrame;", "exists", "", "createTransportIndexFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/TransportIndexFrame;", "index", "createTransportAcceptanceFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/TransportAcceptanceFrame;", "accepted", "createCurrentConfirmationFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/CurrentConfirmationFrame;", "number", "createForceTerminateWireFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/ForceTerminateWireFrame;", "reason", "Lcom/intellij/platform/split/connection/ConnectionDeclineReason;", "checkFrameType", "T", "(Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;)Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "asFrameOfType", "isFrameOfType", "toByteArray", "", "toFrame", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nFrameFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameFactory.kt\ncom/intellij/platform/split/connection/protocol/channel/frame/FrameFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n67#2,4:139\n*S KotlinDebug\n*F\n+ 1 FrameFactory.kt\ncom/intellij/platform/split/connection/protocol/channel/frame/FrameFactory\n*L\n36#1:139,4\n*E\n"})
public final class FrameFactory {
    @NotNull
    public static final FrameFactory INSTANCE = new FrameFactory();
    public static final int WIRE_STATE_VALUE_BUFFER_SIZE = 1;
    private static final int INT_VALUE_BUFFER_SIZE = 4;
    @NotNull
    private static final PingFrame PING_FRAME = new PingFrame();

    private FrameFactory() {
    }

    @NotNull
    public final PingFrame getPING_FRAME() {
        return PING_FRAME;
    }

    private final Frame getFrame(ByteBuffer buffer) {
        buffer.rewind();
        int frameLength = buffer.remaining();
        Logger $this$trace$iv = FrameFactoryKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Get a new byte buffer of size: " + frameLength + ". Going to define an exact Frame instance.");
        }
        if (frameLength == 0) {
            return PING_FRAME;
        }
        int ack = buffer.getInt();
        if (ack == -1) {
            ByteBuffer data = buffer.slice();
            int connectStatusCode = data.getInt();
            WireConnectStatus frameId = WireConnectStatus.Companion.findByCode(connectStatusCode);
            ByteBuffer dataSlice = data.slice();
            Intrinsics.checkNotNull((Object)dataSlice);
            byte[] dataBytes = IoKt.toByteArray$default((ByteBuffer)dataSlice, (boolean)false, (int)1, null);
            return switch (WhenMappings.$EnumSwitchMapping$0[frameId.ordinal()]) {
                case 1 -> new AcceptedFrame();
                case 2 -> new DeclinedFrame();
                case 3 -> new JoinPinFrame(dataBytes);
                case 4 -> new PasswordRequiredFrame(dataBytes);
                case 5 -> new SessionTokenFrame(dataBytes);
                case 6 -> new WireExistFrame(dataBytes);
                case 7 -> new TransportAcceptanceFrame(dataBytes);
                case 8 -> new TransportIndexFrame(dataBytes);
                case 9 -> new CurrentConfirmationFrame(dataBytes);
                case 10 -> new ForceTerminateWireFrame(dataBytes);
                default -> new SystemMessageFrame(frameId, dataBytes);
            };
        }
        int confirmedFrameNumber = buffer.getInt();
        ByteBuffer data = buffer.slice();
        Intrinsics.checkNotNull((Object)data);
        return new MessageFrame(ack, confirmedFrameNumber, IoKt.toByteArray$default((ByteBuffer)data, (boolean)false, (int)1, null));
    }

    @NotNull
    public final WireExistFrame createWireExistFrame(boolean exists) {
        int intValue = exists ? 1 : 0;
        byte[] buffer = ByteArrayUtilsKt.toByteArray((int)intValue, (int)1);
        return new WireExistFrame(buffer);
    }

    @NotNull
    public final TransportIndexFrame createTransportIndexFrame(int index) {
        byte[] buffer = ByteArrayUtilsKt.toByteArray((int)index, (int)4);
        return new TransportIndexFrame(buffer);
    }

    @NotNull
    public final TransportAcceptanceFrame createTransportAcceptanceFrame(boolean accepted) {
        int intValue = accepted ? 1 : 0;
        byte[] buffer = ByteArrayUtilsKt.toByteArray((int)intValue, (int)1);
        return new TransportAcceptanceFrame(buffer);
    }

    @NotNull
    public final CurrentConfirmationFrame createCurrentConfirmationFrame(int number) {
        byte[] buffer = ByteArrayUtilsKt.toByteArray((int)number, (int)4);
        return new CurrentConfirmationFrame(buffer);
    }

    @NotNull
    public final ForceTerminateWireFrame createForceTerminateWireFrame(@NotNull ConnectionDeclineReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        byte[] buffer = ByteArrayUtilsKt.toByteArray((int)reason.ordinal(), (int)4);
        return new ForceTerminateWireFrame(buffer);
    }

    public final /* synthetic */ <T extends Frame> T checkFrameType(Frame $this$checkFrameType) {
        Intrinsics.checkNotNullParameter((Object)$this$checkFrameType, (String)"<this>");
        boolean $i$f$checkFrameType = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!($this$checkFrameType instanceof Frame)) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException("Expected to get frame instance of <" + Frame.class.getSimpleName() + ">, but received frame: " + $this$checkFrameType);
        }
        return (T)$this$checkFrameType;
    }

    public final /* synthetic */ <T extends Frame> T asFrameOfType(Frame $this$asFrameOfType) {
        Intrinsics.checkNotNullParameter((Object)$this$asFrameOfType, (String)"<this>");
        boolean $i$f$asFrameOfType = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!($this$asFrameOfType instanceof Frame)) {
            return null;
        }
        return (T)$this$asFrameOfType;
    }

    public final /* synthetic */ <T extends Frame> boolean isFrameOfType(Frame $this$isFrameOfType) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrameOfType, (String)"<this>");
        boolean $i$f$isFrameOfType = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        return $this$isFrameOfType instanceof Frame;
    }

    @NotNull
    public final byte[] toByteArray(int $this$toByteArray) {
        return ByteArrayUtilsKt.toByteArray((int)$this$toByteArray, (int)4);
    }

    @NotNull
    public final Frame toFrame(@NotNull ByteBuffer $this$toFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$toFrame, (String)"<this>");
        return this.getFrame($this$toFrame);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WireConnectStatus.values().length];
            try {
                nArray[WireConnectStatus.ACCEPTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.DECLINED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.JOIN_PIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.PASSWORD_REQUIRED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.SESSION_TOKEN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.WIRE_EXIST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.TRANSPORT_ACCEPTANCE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.TRANSPORT_INDEX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.CURRENT_CONFIRMED_FRAME_ACK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.FORCE_TERMINATE_WIRE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

