/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport.creator;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.impl.ConnectionFlowService;
import com.intellij.platform.split.connection.impl.config.ConnectionConfiguration;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactory;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.TransportAcceptanceFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.TransportIndexFrame;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportCreator;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportCreatorEngine;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportCreatorEngineImpl;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportCreatorEngineImplKt;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.transport.exception.NoConnectedTransportsException;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportCreatorEngineImpl;", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportCreatorEngine;", "baseTransportLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "myCreators", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportCreator;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentTransportIndex", "", "getCurrentTransportIndex", "()I", "creators", "", "getCreators", "()Ljava/util/List;", "addCreator", "", "creator", "addCreators", "getCreatorsOfType", "transportType", "Lcom/intellij/platform/split/connection/TransportType;", "waitFirstConnectedTransport", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "lifetime", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTransportIndex", "creatorName", "", "transportInfo", "getTransportAcceptance", "", "(Ljava/lang/String;Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTransportCreatorEngineImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportCreatorEngineImpl.kt\ncom/intellij/platform/split/connection/protocol/transport/creator/TransportCreatorEngineImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n1915#2,2:205\n777#2:207\n873#2,2:208\n1915#2:210\n1916#2:216\n60#3,5:211\n60#3,5:217\n60#3,5:222\n60#3,5:227\n*S KotlinDebug\n*F\n+ 1 TransportCreatorEngineImpl.kt\ncom/intellij/platform/split/connection/protocol/transport/creator/TransportCreatorEngineImpl\n*L\n51#1:205,2\n55#1:207\n55#1:208,2\n93#1:210\n93#1:216\n96#1:211,5\n192#1:217,5\n73#1:222,5\n79#1:227,5\n*E\n"})
public final class TransportCreatorEngineImpl
implements TransportCreatorEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime baseTransportLifetime;
    @NotNull
    private final ConcurrentList<TransportCreator> myCreators;
    @NotNull
    private static final AtomicInteger transportIndex = new AtomicInteger(0);

    public TransportCreatorEngineImpl(@NotNull Lifetime baseTransportLifetime) {
        Intrinsics.checkNotNullParameter((Object)baseTransportLifetime, (String)"baseTransportLifetime");
        this.baseTransportLifetime = baseTransportLifetime;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.myCreators = concurrentList;
    }

    public final int getCurrentTransportIndex() {
        return transportIndex.get();
    }

    @Override
    @NotNull
    public List<TransportCreator> getCreators() {
        return CollectionsKt.toList((Iterable)((Iterable)this.myCreators));
    }

    @Override
    public void addCreator(@NotNull TransportCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        this.myCreators.add((Object)creator);
    }

    @Override
    public void addCreators(@NotNull List<? extends TransportCreator> creators) {
        Intrinsics.checkNotNullParameter(creators, (String)"creators");
        Iterable $this$forEach$iv = creators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransportCreator creator = (TransportCreator)element$iv;
            boolean bl = false;
            this.addCreator(creator);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TransportCreator> getCreatorsOfType(@NotNull TransportType transportType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)transportType, (String)"transportType");
        Iterable $this$filter$iv = (Iterable)this.myCreators;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TransportCreator creator = (TransportCreator)element$iv$iv;
            boolean bl = false;
            if (!(creator.getTransportType() == transportType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object waitFirstConnectedTransport(@NotNull Lifetime lifetime, @NotNull Continuation<? super TransportInfo> $completion) {
        if (!($completion instanceof waitFirstConnectedTransport.1)) ** GOTO lbl-1000
        var21_3 = $completion;
        if ((var21_3.label & -2147483648) != 0) {
            var21_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransportCreatorEngineImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.waitFirstConnectedTransport(null, (Continuation<? super TransportInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                TransportCreatorEngineImplKt.access$getLogger$p().info("Transport Engine. Start logic to receive first connected transport (transports defined: " + this.myCreators.size() + ")");
                if (this.myCreators.isEmpty()) {
                    throw new NoConnectedTransportsException("Transport Engine. No transports found to perform connection");
                }
                transportCreateFuture = new CompletableFuture<TransportInfo>();
                transportLifetime = this.baseTransportLifetime.createNested();
                sharedTransportIndex = TransportCreatorEngineImpl.transportIndex.getAndIncrement();
                engineName = "Transport Engine (index: " + sharedTransportIndex + ")";
                lifetime.onTermination((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, waitFirstConnectedTransport$lambda$0(java.lang.String ), ()Lkotlin/Unit;)((String)engineName));
                notConnectedTransportsCount = new AtomicInteger(0);
                $this$forEach$iv = CollectionsKt.toList((Iterable)((Iterable)this.myCreators));
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    creator = (TransportCreator)element$iv;
                    $i$a$-forEach-TransportCreatorEngineImpl$waitFirstConnectedTransport$3 = false;
                    creatorName = "Transport Creator (type: " + creator.getTransportType().getStringId() + ", index: " + sharedTransportIndex + ")";
                    $this$debug_u24default$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var18_26 = $this$debug_u24default$iv;
                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$1 = false;
                        var18_26.debug(creatorName + " Start background thread to wait for transport ready: " + creator.getName(), t$iv);
                    }
                    BuildersKt.launch$default((CoroutineScope)ConnectionFlowService.Companion.getInstance().getCoroutineScope(), (CoroutineContext)((CoroutineContext)ConnectionFlowService.Companion.getConnectionPool()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(transportLifetime, creator, creatorName, sharedTransportIndex, this, transportCreateFuture, notConnectedTransportsCount, (String)engineName, null){
                        Object L$0;
                        Object L$1;
                        int label;
                        final /* synthetic */ LifetimeDefinition $transportLifetime;
                        final /* synthetic */ TransportCreator $creator;
                        final /* synthetic */ String $creatorName;
                        final /* synthetic */ int $sharedTransportIndex;
                        final /* synthetic */ TransportCreatorEngineImpl this$0;
                        final /* synthetic */ CompletableFuture<TransportInfo> $transportCreateFuture;
                        final /* synthetic */ AtomicInteger $notConnectedTransportsCount;
                        final /* synthetic */ String $engineName;
                        {
                            this.$transportLifetime = $transportLifetime;
                            this.$creator = $creator;
                            this.$creatorName = $creatorName;
                            this.$sharedTransportIndex = $sharedTransportIndex;
                            this.this$0 = $receiver;
                            this.$transportCreateFuture = $transportCreateFuture;
                            this.$notConnectedTransportsCount = $notConnectedTransportsCount;
                            this.$engineName = $engineName;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var2_3 = TransportCreatorEngineImplKt.access$getLogger$p();
                                    var4_4 = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$1 = false;
                                        var12_19.debug(var4_4 + " Start creator thread", (Throwable)t$iv);
                                    }
                                    transportCreateLifetime = this.$transportLifetime.createNested();
                                    t$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                    $i$f$debug = this.$creatorName;
                                    $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$1 = this.$creator;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$2 = false;
                                        var12_19.debug($i$f$debug + " Create transport and wait ready for: " + $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$1.getName(), (Throwable)t$iv);
                                    }
                                    this.L$0 = transportCreateLifetime;
                                    this.label = 1;
                                    v0 = this.$creator.createTransportAndWaitReady((Lifetime)transportCreateLifetime, (Continuation<? super TransportInfo>)((Continuation)this));
                                    ** if (v0 != var13_2) goto lbl32
lbl31:
                                    // 1 sources

                                    return var13_2;
lbl32:
                                    // 1 sources

                                    ** GOTO lbl39
                                }
                                case 1: {
                                    transportCreateLifetime = (LifetimeDefinition)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl39:
                                    // 2 sources

                                    transportInfo = (TransportInfo)v0;
                                    v1 = transportInfo;
                                    TransportCreatorEngineImplKt.access$getLogger$p().info(this.$creatorName + " Got created transport: " + (v1 != null ? v1.getName() : null));
                                    if (transportInfo != null) ** GOTO lbl65
                                    t$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                    $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$1 = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$3 = false;
                                        var12_19.debug((String)$i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$1 + " Transport is not defined.", t$iv);
                                    }
                                    TransportCreatorEngineImpl.access$waitFirstConnectedTransport$failCreator(this.$notConnectedTransportsCount, this.this$0, this.$transportCreateFuture, this.$engineName, this.$sharedTransportIndex, this.$creatorName, this.$creator, transportCreateLifetime);
                                    $this$debug_u24default$iv = Unit.INSTANCE;
                                    t$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                    $i$f$debug = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$5 = false;
                                        var12_19.debug($i$f$debug + " Finish connection thread", (Throwable)t$iv);
                                    }
                                    return $this$debug_u24default$iv;
lbl65:
                                    // 2 sources

                                    transportInfo.assignTransportIndex(this.$sharedTransportIndex);
                                    TransportCreatorEngineImpl.access$sendTransportIndex(this.this$0, this.$creatorName, transportInfo);
                                    this.L$0 = transportCreateLifetime;
                                    this.L$1 = transportInfo;
                                    this.label = 2;
                                    v2 = TransportCreatorEngineImpl.access$getTransportAcceptance(this.this$0, this.$creatorName, transportInfo, (Continuation)this);
                                    ** if (v2 != var13_2) goto lbl73
lbl72:
                                    // 1 sources

                                    return var13_2;
lbl73:
                                    // 1 sources

                                    ** GOTO lbl81
                                }
                                case 2: {
                                    transportInfo = (TransportInfo)this.L$1;
                                    transportCreateLifetime = (LifetimeDefinition)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl81:
                                    // 2 sources

                                    if (isTransportAccepted = ((Boolean)v2).booleanValue()) ** GOTO lbl96
                                    TransportCreatorEngineImplKt.access$getLogger$p().info(this.$creatorName + " Transport (" + transportInfo.getName() + ") got state: DECLINED");
                                    TransportCreatorEngineImpl.access$waitFirstConnectedTransport$failCreator(this.$notConnectedTransportsCount, this.this$0, this.$transportCreateFuture, this.$engineName, this.$sharedTransportIndex, this.$creatorName, this.$creator, transportCreateLifetime);
                                    $this$debug_u24default$iv = Unit.INSTANCE;
                                    t$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                    $i$f$debug = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$5 = false;
                                        var12_19.debug($i$f$debug + " Finish connection thread", t$iv);
                                    }
                                    return $this$debug_u24default$iv;
lbl96:
                                    // 2 sources

                                    TransportCreatorEngineImplKt.access$getLogger$p().info(this.$creatorName + " Transport (" + transportInfo.getName() + ") got state: ACCEPTED");
                                    isSucceeded = this.$transportCreateFuture.complete(transportInfo);
                                    $this$debug_u24default$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                    $i$f$debug = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$4 = false;
                                        var12_19.debug($i$f$debug + " Completed future (" + transportInfo.getName() + ") with result: " + (isSucceeded != false), t$iv);
                                    }
                                    if (isSucceeded) ** GOTO lbl122
                                    TransportCreatorEngineImplKt.access$getLogger$p().warn(this.$creatorName + " Got two accepted transports, second is: <" + transportInfo.getName() + "> - bug?");
                                    transportInfo.getTransport().terminateTransport();
                                    TransportCreatorEngineImpl.access$waitFirstConnectedTransport$failCreator(this.$notConnectedTransportsCount, this.this$0, this.$transportCreateFuture, this.$engineName, this.$sharedTransportIndex, this.$creatorName, this.$creator, transportCreateLifetime);
                                    $this$debug_u24default$iv = Unit.INSTANCE;
                                    t$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                    var9_35 = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$5 = false;
                                        var12_19.debug(var9_35 + " Finish connection thread", t$iv);
                                    }
                                    return $this$debug_u24default$iv;
lbl122:
                                    // 1 sources

                                    try {
                                        TransportCreatorEngineImplKt.access$getLogger$p().info(this.$creatorName + " Accepted transport: " + transportInfo.getName());
                                    }
                                    catch (Throwable t) {
                                        try {
                                            TransportCreatorEngineImplKt.access$getLogger$p().debug(this.$creatorName + " Connection for creator (" + this.$creator.getName() + ") failed with exception: " + t.getMessage(), t);
                                            TransportCreatorEngineImpl.access$waitFirstConnectedTransport$failCreator(this.$notConnectedTransportsCount, this.this$0, this.$transportCreateFuture, this.$engineName, this.$sharedTransportIndex, this.$creatorName, this.$creator, transportCreateLifetime);
                                        }
                                        catch (Throwable var3_12) {
                                            t$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                                            var6_23 = this.$creatorName;
                                            t$iv = null;
                                            $i$f$debug = false;
                                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                                var12_19 = $this$debug_u24default$iv;
                                                $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$5 = false;
                                                var12_19.debug(var6_23 + " Finish connection thread", t$iv);
                                            }
                                            throw var3_12;
                                        }
                                        t = TransportCreatorEngineImplKt.access$getLogger$p();
                                        isSucceeded = this.$creatorName;
                                        t$iv = null;
                                        $i$f$debug = false;
                                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                                            var12_19 = $this$debug_u24default$iv;
                                            $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$5 = false;
                                            var12_19.debug(isSucceeded + " Finish connection thread", t$iv);
                                        } else {
                                            ** GOTO lbl159
                                        }
                                    }
                                    transportInfo = TransportCreatorEngineImplKt.access$getLogger$p();
                                    isSucceeded = this.$creatorName;
                                    t$iv = null;
                                    $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        var12_19 = $this$debug_u24default$iv;
                                        $i$a$-debug$default-TransportCreatorEngineImpl$waitFirstConnectedTransport$3$2$5 = false;
                                        var12_19.debug(isSucceeded + " Finish connection thread", t$iv);
                                    }
lbl159:
                                    // 4 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
                awaitTransportsConnectTimeout = ((Duration)ConnectionConfiguration.INSTANCE.getTransportAwaitFirstConnectedTimeout().getValue()).unbox-impl();
                TransportCreatorEngineImplKt.access$getLogger$p().info((String)engineName + " Start waiting for a first connected transport with timeout: " + Duration.toString-impl((long)awaitTransportsConnectTimeout) + "...");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)lifetime);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(transportCreateFuture);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)transportLifetime);
                $continuation.L$3 = engineName;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)notConnectedTransportsCount);
                $continuation.I$0 = sharedTransportIndex;
                $continuation.J$0 = awaitTransportsConnectTimeout;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)awaitTransportsConnectTimeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransportInfo>, Object>(transportCreateFuture, (String)engineName, null){
                    int label;
                    final /* synthetic */ CompletableFuture<TransportInfo> $transportCreateFuture;
                    final /* synthetic */ String $engineName;
                    {
                        this.$transportCreateFuture = $transportCreateFuture;
                        this.$engineName = $engineName;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = FutureKt.await((CompletionStage)this.$transportCreateFuture, (Continuation)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                acceptedTransport = (TransportInfo)v0;
                                v1 = acceptedTransport;
                                TransportCreatorEngineImplKt.access$getLogger$p().info(this.$engineName + " Awaited next connected and ready transport: " + (v1 != null ? v1.getName() : null));
                                return acceptedTransport;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super TransportInfo> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl63
            }
            case 1: {
                awaitTransportsConnectTimeout = $continuation.J$0;
                sharedTransportIndex = $continuation.I$0;
                notConnectedTransportsCount = (AtomicInteger)$continuation.L$4;
                engineName = (String)$continuation.L$3;
                transportLifetime = (LifetimeDefinition)$continuation.L$2;
                transportCreateFuture = (CompletableFuture)$continuation.L$1;
                lifetime = (Lifetime)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl63:
                // 2 sources

                if ((transportCreateResult = (TransportInfo)v0) == null) {
                    throw new IllegalStateException("Timeout waiting for first connected transport after: " + Duration.toString-impl((long)awaitTransportsConnectTimeout));
                }
                TransportCreatorEngineImplKt.access$getLogger$p().info((String)engineName + " Connected transport is set. New transport to proceed: " + transportCreateResult.getName());
                return transportCreateResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendTransportIndex(String creatorName, TransportInfo transportInfo) {
        TransportCreatorEngineImplKt.access$getLogger$p().info(creatorName + " Send transport index frame for transport: " + transportInfo.getName());
        TransportIndexFrame transportIndexFrame = FrameFactory.INSTANCE.createTransportIndexFrame(transportInfo.getTransportIndex());
        transportInfo.getTransport().send(transportIndexFrame);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getTransportAcceptance(String creatorName, TransportInfo transportInfo, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof getTransportAcceptance.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransportCreatorEngineImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransportCreatorEngineImpl.access$getTransportAcceptance(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                transportAcceptanceFrameReceiveTimeout = ((Duration)ConnectionConfiguration.INSTANCE.getTransportReceiveSystemFrameTimeout().getValue()).unbox-impl();
                TransportCreatorEngineImplKt.access$getLogger$p().info(creatorName + " Start waiting for host acceptance for transport (" + transportInfo.getName() + ") with timeout: " + Duration.toString-impl((long)transportAcceptanceFrameReceiveTimeout));
                $continuation.L$0 = creatorName;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)transportInfo);
                $continuation.J$0 = transportAcceptanceFrameReceiveTimeout;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)transportAcceptanceFrameReceiveTimeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SystemFrame>, Object>(transportInfo, null){
                    int label;
                    final /* synthetic */ TransportInfo $transportInfo;
                    {
                        this.$transportInfo = $transportInfo;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$transportInfo.getTransport().receiveSingleSystemFrame((Continuation<? super SystemFrame>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super SystemFrame> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                transportAcceptanceFrameReceiveTimeout = $continuation.J$0;
                transportInfo = (TransportInfo)$continuation.L$1;
                creatorName = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if ((transportAcceptedFrame = (SystemFrame)v0) == null) {
                    $this$debug_u24default$iv = TransportCreatorEngineImplKt.access$getLogger$p();
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var11_12 = $this$debug_u24default$iv;
                        $i$a$-debug$default-TransportCreatorEngineImpl$getTransportAcceptance$2 = false;
                        var11_12.debug(creatorName + " Timeout waiting for transport host acceptance after: " + Duration.toString-impl((long)transportAcceptanceFrameReceiveTimeout), t$iv);
                    }
                    return Boxing.boxBoolean((boolean)false);
                }
                if (!(transportAcceptedFrame instanceof TransportAcceptanceFrame)) {
                    TransportCreatorEngineImplKt.access$getLogger$p().warn(creatorName + " Expected to receive <Transport Acceptance Frame>, but got: <" + transportAcceptedFrame + ">");
                    return Boxing.boxBoolean((boolean)false);
                }
                return Boxing.boxBoolean((boolean)((TransportAcceptanceFrame)transportAcceptedFrame).getAccepted());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit waitFirstConnectedTransport$lambda$0(String $engineName) {
        Logger $this$debug_u24default$iv = TransportCreatorEngineImplKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug($engineName + " Transports connection await lifetime has been terminated. Transport await operation is going to be canceled.", t$iv);
        }
        return Unit.INSTANCE;
    }

    private static final void waitFirstConnectedTransport$failCreator(AtomicInteger notConnectedTransportsCount, TransportCreatorEngineImpl this$0, CompletableFuture<TransportInfo> transportCreateFuture, String engineName, int sharedTransportIndex, String creatorName, TransportCreator creator, LifetimeDefinition creatorLifetime) {
        Logger $this$debug_u24default$iv = TransportCreatorEngineImplKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(creatorName + " [\u2193] Creator failed: " + creator.getName(), t$iv);
        }
        int failedTransportsCount = notConnectedTransportsCount.incrementAndGet();
        creatorLifetime.terminate(true);
        if (failedTransportsCount == this$0.myCreators.size()) {
            transportCreateFuture.completeExceptionally(new NoConnectedTransportsException(engineName + " All <" + this$0.myCreators.size() + "> transports (index: " + sharedTransportIndex + ") were not able to connect."));
        }
    }

    public static final /* synthetic */ void access$waitFirstConnectedTransport$failCreator(AtomicInteger notConnectedTransportsCount, TransportCreatorEngineImpl this$0, CompletableFuture transportCreateFuture, String engineName, int sharedTransportIndex, String creatorName, TransportCreator creator, LifetimeDefinition creatorLifetime) {
        TransportCreatorEngineImpl.waitFirstConnectedTransport$failCreator(notConnectedTransportsCount, this$0, transportCreateFuture, engineName, sharedTransportIndex, creatorName, creator, creatorLifetime);
    }

    public static final /* synthetic */ void access$sendTransportIndex(TransportCreatorEngineImpl $this, String creatorName, TransportInfo transportInfo) {
        $this.sendTransportIndex(creatorName, transportInfo);
    }

    public static final /* synthetic */ Object access$getTransportAcceptance(TransportCreatorEngineImpl $this, String creatorName, TransportInfo transportInfo, Continuation $completion) {
        return $this.getTransportAcceptance(creatorName, transportInfo, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportCreatorEngineImpl$Companion;", "", "<init>", "()V", "transportIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

