/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.widget;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.transport.stats.TransportStatisticsData;
import com.intellij.platform.split.connection.protocol.wire.WireStatsCounter;
import com.intellij.platform.split.connection.protocol.wire.WireStatsMode;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.Signal;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "registeredWires", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "getRegisteredWires", "()Lcom/intellij/util/containers/ConcurrentList;", "wiresChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "hasFrameShown", "", "registerWire", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wire", "showUi", "showWireFrame", "Companion", "ProtocolEntitiesStatsModel", "WireStatsTableModel", "intellij.platform.split.connection"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWireStatsRegistryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService$Companion\n*L\n1#1,272:1\n1#2:273\n43#3,5:274\n43#3,5:279\n*S KotlinDebug\n*F\n+ 1 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService\n*L\n107#1:274,5\n113#1:279,5\n*E\n"})
public final class WireStatsRegistryService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentList<ICodeWithMeWire> registeredWires;
    @NotNull
    private final Signal<Unit> wiresChanged;
    private boolean hasFrameShown;

    public WireStatsRegistryService() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.registeredWires = concurrentList;
        this.wiresChanged = new Signal();
    }

    @NotNull
    public final ConcurrentList<ICodeWithMeWire> getRegisteredWires() {
        return this.registeredWires;
    }

    public final void registerWire(@NotNull Lifetime lifetime, @NotNull ICodeWithMeWire wire) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)wire, (String)"wire");
        CollectionExKt.addUnique((Collection)((Collection)this.registeredWires), (Lifetime)lifetime, (Object)wire);
        ApplicationKt.getApplication().invokeLater(() -> WireStatsRegistryService.registerWire$lambda$0(this));
    }

    public final void showUi() {
        if (this.hasFrameShown) {
            return;
        }
        JFrame frame = new JFrame(PlatformSplitBundle.INSTANCE.message("protocol.transmission.stats", new Object[0]));
        frame.setDefaultCloseOperation(1);
        frame.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        LifetimeDefinition lifetimeDef = this.getServiceLifetime().createNested();
        this.getServiceLifetime().onTermination(() -> WireStatsRegistryService.showUi$lambda$0(frame, this));
        RdSwingKt.visibleProperty((Component)frame).getChange().advise(this.getServiceLifetime(), arg_0 -> WireStatsRegistryService.showUi$lambda$1(lifetimeDef, arg_0));
        WireStatsTableModel tableModel = new WireStatsTableModel();
        JBTable table = new JBTable((TableModel)tableModel);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoCreateRowSorter(true);
        table.setShowColumns(true);
        TableSpeedSearch.installOn((JTable)((JTable)table)).setFilteringMode(true);
        DialogPanel panel = BuilderKt.panel(arg_0 -> WireStatsRegistryService.showUi$lambda$2(frame, table, this, arg_0));
        frame.getContentPane().add((Component)panel, "Center");
        this.wiresChanged.advise(lifetimeDef.getLifetime(), arg_0 -> WireStatsRegistryService.showUi$lambda$3(table, tableModel, arg_0));
        ScheduledFuture<?> future = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> WireStatsRegistryService.showUi$lambda$4(table, tableModel), 1L, 1L, TimeUnit.SECONDS);
        lifetimeDef.getLifetime().onTermination(() -> WireStatsRegistryService.showUi$lambda$5(future));
        frame.pack();
        frame.setVisible(true);
        this.hasFrameShown = true;
    }

    private final void showWireFrame(ICodeWithMeWire wire) {
        Object[] objectArray = new Object[]{wire.getId()};
        JFrame frame = new JFrame(PlatformSplitBundle.INSTANCE.message("protocol.stats.for.wire.id", objectArray));
        frame.setDefaultCloseOperation(1);
        frame.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        LifetimeDefinition lifetimeDef = this.getServiceLifetime().createNested();
        lifetimeDef.getLifetime().onTermination(() -> WireStatsRegistryService.showWireFrame$lambda$0(frame, this));
        RdSwingKt.visibleProperty((Component)frame).getChange().advise(this.getServiceLifetime(), arg_0 -> WireStatsRegistryService.showWireFrame$lambda$1(lifetimeDef, arg_0));
        JBTable table = new JBTable();
        ProtocolEntitiesStatsModel tableModel = new ProtocolEntitiesStatsModel(lifetimeDef.getLifetime(), wire.getWireStats(), (JTable)table);
        table.setModel((TableModel)tableModel);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoCreateRowSorter(true);
        table.setShowColumns(true);
        TableSpeedSearch.installOn((JTable)((JTable)table)).setFilteringMode(true);
        DialogPanel panel = BuilderKt.panel(arg_0 -> WireStatsRegistryService.showWireFrame$lambda$2(frame, table, arg_0));
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private static final void registerWire$lambda$0(WireStatsRegistryService this$0) {
        this$0.wiresChanged.fire((Object)Unit.INSTANCE);
    }

    private static final void showUi$lambda$2$0$0$0(JFrame $frame, JBCheckBox $this_applyToComponent, ActionEvent it) {
        $frame.setAlwaysOnTop($this_applyToComponent.isSelected());
    }

    private static final Unit showUi$lambda$2$0$0(JFrame $frame, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener(arg_0 -> WireStatsRegistryService.showUi$lambda$2$0$0$0($frame, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$2$2$0(JBTable $table, WireStatsRegistryService this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selected = $table.getSelectedRow();
        if (selected >= 0) {
            ICodeWithMeWire wire = (ICodeWithMeWire)CollectionsKt.first((List)CollectionsKt.drop((Iterable)((Iterable)this$0.registeredWires), (int)selected));
            Intrinsics.checkNotNull((Object)wire);
            this$0.showWireFrame(wire);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$2$0(JFrame $frame, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.checkBox(PlatformSplitBundle.INSTANCE.message("checkbox.stay.on.top", new Object[0])).applyToComponent(arg_0 -> WireStatsRegistryService.showUi$lambda$2$0$0($frame, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showUi$lambda$2$1(JBTable $table, Row $this$row) {
        void $this$showUi_u24lambda_u242_u241_u240;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)$table);
        Row row = $this$row;
        boolean bl = false;
        $this$showUi_u24lambda_u242_u241_u240.setMinimumSize((Dimension)JBUI.size((int)300, (int)300));
        row.cell((JComponent)jBScrollPane).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$2$2(JBTable $table, WireStatsRegistryService this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(PlatformSplitBundle.INSTANCE.message("button.show.protocol.tree.stats.for.selected.wire", new Object[0]), arg_0 -> WireStatsRegistryService.showUi$lambda$2$2$0($table, this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$0(JFrame $frame, WireStatsRegistryService this$0) {
        $frame.setVisible(false);
        this$0.hasFrameShown = false;
        $frame.dispose();
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$1(LifetimeDefinition $lifetimeDef, boolean it) {
        if (!it) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)$lifetimeDef, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$2(JFrame $frame, JBTable $table, WireStatsRegistryService this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WireStatsRegistryService.showUi$lambda$2$0($frame, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WireStatsRegistryService.showUi$lambda$2$1($table, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WireStatsRegistryService.showUi$lambda$2$2($table, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit showUi$lambda$3(JBTable $table, WireStatsTableModel $tableModel, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Companion companion = Companion;
        JTable $this$withPreserveSelection$iv = (JTable)$table;
        boolean $i$f$withPreserveSelection = false;
        int oldSelection$iv = $this$withPreserveSelection$iv.getSelectedRow();
        boolean bl = false;
        $tableModel.fireTableDataChanged();
        if (oldSelection$iv >= 0 && oldSelection$iv < $this$withPreserveSelection$iv.getRowCount()) {
            $this$withPreserveSelection$iv.changeSelection(oldSelection$iv, 0, false, false);
        }
        return Unit.INSTANCE;
    }

    private static final void showUi$lambda$4(JBTable $table, WireStatsTableModel $tableModel) {
        Companion companion = Companion;
        JTable $this$withPreserveSelection$iv = (JTable)$table;
        boolean $i$f$withPreserveSelection = false;
        int oldSelection$iv = $this$withPreserveSelection$iv.getSelectedRow();
        boolean bl = false;
        $tableModel.fireTableDataChanged();
        if (oldSelection$iv >= 0 && oldSelection$iv < $this$withPreserveSelection$iv.getRowCount()) {
            $this$withPreserveSelection$iv.changeSelection(oldSelection$iv, 0, false, false);
        }
    }

    private static final Unit showUi$lambda$5(ScheduledFuture $future) {
        $future.cancel(false);
        return Unit.INSTANCE;
    }

    private static final void showWireFrame$lambda$2$0$0$0(JFrame $frame, JBCheckBox $this_applyToComponent, ActionEvent it) {
        $frame.setAlwaysOnTop($this_applyToComponent.isSelected());
    }

    private static final Unit showWireFrame$lambda$2$0$0(JFrame $frame, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener(arg_0 -> WireStatsRegistryService.showWireFrame$lambda$2$0$0$0($frame, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit showWireFrame$lambda$2$0(JFrame $frame, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.checkBox(PlatformSplitBundle.INSTANCE.message("checkbox.stay.on.top", new Object[0])).applyToComponent(arg_0 -> WireStatsRegistryService.showWireFrame$lambda$2$0$0($frame, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showWireFrame$lambda$2$1(JBTable $table, Row $this$row) {
        void $this$showWireFrame_u24lambda_u242_u241_u240;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)$table);
        Row row = $this$row;
        boolean bl = false;
        $this$showWireFrame_u24lambda_u242_u241_u240.setMinimumSize((Dimension)JBUI.size((int)300, (int)300));
        row.cell((JComponent)jBScrollPane).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit showWireFrame$lambda$0(JFrame $frame, WireStatsRegistryService this$0) {
        $frame.setVisible(false);
        this$0.hasFrameShown = false;
        $frame.dispose();
        return Unit.INSTANCE;
    }

    private static final Unit showWireFrame$lambda$1(LifetimeDefinition $lifetimeDef, boolean it) {
        if (!it) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)$lifetimeDef, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showWireFrame$lambda$2(JFrame $frame, JBTable $table, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WireStatsRegistryService.showWireFrame$lambda$2$0($frame, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WireStatsRegistryService.showWireFrame$lambda$2$1($table, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001b\u0010\u0006\u001a\u00020\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0082\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService;", "withPreserveSelection", "", "Ljavax/swing/JTable;", "block", "Lkotlin/Function0;", "intellij.platform.split.connection"})
    @SourceDebugExtension(value={"SMAP\nWireStatsRegistryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,272:1\n42#2,3:273\n*S KotlinDebug\n*F\n+ 1 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService$Companion\n*L\n40#1:273,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WireStatsRegistryService getInstance() {
            boolean $i$f$service = false;
            Class<WireStatsRegistryService> serviceClass$iv = WireStatsRegistryService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (WireStatsRegistryService)((Object)object);
        }

        private final void withPreserveSelection(JTable $this$withPreserveSelection, Function0<Unit> block) {
            boolean $i$f$withPreserveSelection = false;
            int oldSelection = $this$withPreserveSelection.getSelectedRow();
            block.invoke();
            if (oldSelection >= 0 && oldSelection < $this$withPreserveSelection.getRowCount()) {
                $this$withPreserveSelection.changeSelection(oldSelection, 0, false, false);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0014\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService$ProtocolEntitiesStatsModel;", "Ljavax/swing/table/AbstractTableModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wireStats", "Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounter;", "table", "Ljavax/swing/JTable;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounter;Ljavax/swing/JTable;)V", "getWireStats", "()Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounter;", "getTable", "()Ljavax/swing/JTable;", "rdIdList", "Ljava/util/ArrayList;", "Lcom/jetbrains/rd/framework/RdId;", "Lkotlin/collections/ArrayList;", "getRdIdList", "()Ljava/util/ArrayList;", "getRowCount", "", "getColumnName", "", "column", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "getColumnCount", "filenameRegex", "Lkotlin/text/Regex;", "getFilenameRegex", "()Lkotlin/text/Regex;", "getValueAt", "", "rowIndex", "intellij.platform.split.connection"})
    @SourceDebugExtension(value={"SMAP\nWireStatsRegistryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService$ProtocolEntitiesStatsModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService$Companion\n*L\n1#1,272:1\n3938#2:273\n4474#2,2:274\n43#3,5:276\n*S KotlinDebug\n*F\n+ 1 WireStatsRegistryService.kt\ncom/intellij/platform/split/connection/widget/WireStatsRegistryService$ProtocolEntitiesStatsModel\n*L\n170#1:273\n170#1:274,2\n173#1:276,5\n*E\n"})
    private static final class ProtocolEntitiesStatsModel
    extends AbstractTableModel {
        @NotNull
        private final WireStatsCounter wireStats;
        @NotNull
        private final JTable table;
        @NotNull
        private final ArrayList<RdId> rdIdList;
        @NotNull
        private final Regex filenameRegex;

        public ProtocolEntitiesStatsModel(@NotNull Lifetime lifetime, @NotNull WireStatsCounter wireStats, @NotNull JTable table) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)wireStats, (String)"wireStats");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            this.wireStats = wireStats;
            this.table = table;
            this.rdIdList = new ArrayList();
            this.wireStats.setStatsMode(WireStatsMode.PerEntity);
            ScheduledFuture<?> future = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> ProtocolEntitiesStatsModel._init_$lambda$0(this), 1L, 1L, TimeUnit.SECONDS);
            lifetime.onTermination(() -> ProtocolEntitiesStatsModel._init_$lambda$1(future, this));
            this.filenameRegex = new Regex("filePath\\s*=\\s*\"[^\"]*[/\\\\]([^\"\\\\/]+)\"");
        }

        @NotNull
        public final WireStatsCounter getWireStats() {
            return this.wireStats;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public final ArrayList<RdId> getRdIdList() {
            return this.rdIdList;
        }

        @Override
        public int getRowCount() {
            return this.rdIdList.size();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> PlatformSplitBundle.INSTANCE.message("protocol.entities.wire.stats.registry.column.name.entity", new Object[0]);
                case 1 -> PlatformSplitBundle.INSTANCE.message("protocol.entities.wire.stats.registry.column.name.speed.down", new Object[0]);
                case 2 -> PlatformSplitBundle.INSTANCE.message("protocol.entities.wire.stats.registry.column.name.speed.up", new Object[0]);
                case 3 -> PlatformSplitBundle.INSTANCE.message("protocol.entities.wire.stats.registry.column.name.total.down", new Object[0]);
                case 4 -> PlatformSplitBundle.INSTANCE.message("protocol.entities.wire.stats.registry.column.name.total.up", new Object[0]);
                default -> "";
            };
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> String.class;
                case 1, 2, 3, 4 -> Long.class;
                default -> Object.class;
            };
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @NotNull
        public final Regex getFilenameRegex() {
            return this.filenameRegex;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object object;
            if (rowIndex >= this.rdIdList.size()) {
                return null;
            }
            RdId rdId = this.rdIdList.get(rowIndex);
            Intrinsics.checkNotNullExpressionValue((Object)rdId, (String)"get(...)");
            long rdid = rdId.unbox-impl();
            TransportStatisticsData transportStatisticsData = this.wireStats.getEntityStats-s1GeQ58(rdid);
            if (transportStatisticsData == null) {
                return "-";
            }
            TransportStatisticsData wire = transportStatisticsData;
            switch (columnIndex) {
                case 0: {
                    Function1 function1;
                    CharSequence charSequence;
                    Regex regex;
                    object = this.wireStats.getStoredName-s1GeQ58(rdid);
                    if (object != null && (object = (regex = this.filenameRegex).replace(charSequence = (CharSequence)object, function1 = ProtocolEntitiesStatsModel::getValueAt$lambda$0)) != null) break;
                    object = RdId.toString-impl((long)rdid);
                    break;
                }
                case 1: {
                    object = wire.getReceiveSpeed();
                    break;
                }
                case 2: {
                    object = wire.getSendSpeed();
                    break;
                }
                case 3: {
                    object = wire.getTotalReceive();
                    break;
                }
                case 4: {
                    object = wire.getTotalSend();
                    break;
                }
                default: {
                    object = null;
                }
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private static final void _init_$lambda$0(ProtocolEntitiesStatsModel this$0) {
            void $this$filterTo$iv$iv;
            Companion $this$filter$iv;
            this$0.rdIdList.clear();
            RdId[] rdIdArray = this$0.wireStats.getStoredIds();
            ArrayList<RdId> arrayList = this$0.rdIdList;
            boolean $i$f$filter = false;
            void var3_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                long rdId = element$iv$iv.unbox-impl();
                boolean bl = false;
                String string = this$0.wireStats.getStoredName-s1GeQ58(rdId);
                boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"DiagnosticsModel", (boolean)false, (int)2, null) : false;
                if (!(!bl2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            arrayList.addAll((List)destination$iv$iv);
            $this$filter$iv = Companion;
            JTable $this$withPreserveSelection$iv = this$0.table;
            boolean $i$f$withPreserveSelection = false;
            int oldSelection$iv = $this$withPreserveSelection$iv.getSelectedRow();
            boolean bl = false;
            this$0.fireTableDataChanged();
            if (oldSelection$iv >= 0 && oldSelection$iv < $this$withPreserveSelection$iv.getRowCount()) {
                $this$withPreserveSelection$iv.changeSelection(oldSelection$iv, 0, false, false);
            }
        }

        private static final Unit _init_$lambda$1(ScheduledFuture $future, ProtocolEntitiesStatsModel this$0) {
            $future.cancel(false);
            this$0.wireStats.setStatsMode(WireStatsMode.Simple);
            return Unit.INSTANCE;
        }

        private static final CharSequence getValueAt$lambda$0(MatchResult name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "fileName=\"" + name.getGroupValues().get(1) + "\"";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService$WireStatsTableModel;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "(Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService;)V", "getRowCount", "", "getColumnCount", "getColumnName", "", "column", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "getValueAt", "", "rowIndex", "intellij.platform.split.connection"})
    private final class WireStatsTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return WireStatsRegistryService.this.getRegisteredWires().size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.wire", new Object[0]);
                case 1 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.speed.down", new Object[0]);
                case 2 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.speed.up", new Object[0]);
                case 3 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.total.down", new Object[0]);
                case 4 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.total.up", new Object[0]);
                case 5 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.compression.down", new Object[0]);
                case 6 -> PlatformSplitBundle.INSTANCE.message("wire.stats.table.registry.column.name.compression.up", new Object[0]);
                default -> "";
            };
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> String.class;
                case 1, 2, 3, 4 -> Long.class;
                case 5, 6 -> Integer.class;
                default -> Object.class;
            };
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            ICodeWithMeWire wire = (ICodeWithMeWire)WireStatsRegistryService.this.getRegisteredWires().get(rowIndex);
            TransportStatisticsData totalStats = wire.getWireStats().getTotalStats();
            return switch (columnIndex) {
                case 0 -> wire.getId();
                case 1 -> totalStats.getReceiveSpeed();
                case 2 -> totalStats.getSendSpeed();
                case 3 -> totalStats.getTotalReceive();
                case 4 -> totalStats.getTotalSend();
                case 5 -> wire.getReceiveCompressionRatio();
                case 6 -> wire.getTransmitCompressionRatio();
                default -> null;
            };
        }
    }
}

