/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.cloud.ip;

import ai.grazie.model.cloud.ip.IPAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lai/grazie/model/cloud/ip/IPv4Address;", "Lai/grazie/model/cloud/ip/IPAddress;", "bytes", "", "<init>", "([B)V", "getBytes", "()[B", "display", "", "getDisplay", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "component1", "copy", "toString", "Companion", "model-cloud"})
@SourceDebugExtension(value={"SMAP\nIPv4Address.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPv4Address.kt\nai/grazie/model/cloud/ip/IPv4Address\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class IPv4Address
implements IPAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    @NotNull
    private final String display;

    public IPv4Address(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.display = ArraysKt.joinToString$default((byte[])this.getBytes(), (CharSequence)".", null, null, (int)0, null, IPv4Address::display$lambda$0, (int)30, null);
        if (!(this.getBytes().length == 4)) {
            boolean bl = false;
            String string = "Invalid IPv4 address: " + this.getDisplay();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public String getDisplay() {
        return this.display;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IPv4Address cfr_ignored_0 = (IPv4Address)other;
        if (!Arrays.equals(this.getBytes(), ((IPv4Address)other).getBytes())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDisplay(), (Object)((IPv4Address)other).getDisplay());
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.getBytes());
        result2 = 31 * result2 + this.getDisplay().hashCode();
        return result2;
    }

    @NotNull
    public final byte[] component1() {
        return this.bytes;
    }

    @NotNull
    public final IPv4Address copy(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return new IPv4Address(bytes);
    }

    public static /* synthetic */ IPv4Address copy$default(IPv4Address iPv4Address, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = iPv4Address.bytes;
        }
        return iPv4Address.copy(byArray);
    }

    @NotNull
    public String toString() {
        return "IPv4Address(bytes=" + Arrays.toString(this.bytes) + ")";
    }

    private static final CharSequence display$lambda$0(byte it) {
        return UByte.toString-impl((byte)UByte.constructor-impl((byte)it));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/ip/IPv4Address$Companion;", "", "<init>", "()V", "check", "", "ip", "", "parseOrNull", "Lai/grazie/model/cloud/ip/IPv4Address;", "parse", "model-cloud"})
    @SourceDebugExtension(value={"SMAP\nIPv4Address.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPv4Address.kt\nai/grazie/model/cloud/ip/IPv4Address$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1734#2,3:50\n1557#2:53\n1628#2,3:54\n*S KotlinDebug\n*F\n+ 1 IPv4Address.kt\nai/grazie/model/cloud/ip/IPv4Address$Companion\n*L\n11#1:50,3\n18#1:53\n18#1:54,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean check(@NotNull String ip) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
                String[] stringArray = new String[]{"."};
                List parts = StringsKt.split$default((CharSequence)ip, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (parts.size() != 4) {
                    return false;
                }
                Iterable $this$all$iv = parts;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        IntRange intRange = new IntRange(0, 255);
                        Integer n = StringsKt.toIntOrNull((String)it);
                        if (n != null && intRange.contains(n.intValue())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final IPv4Address parseOrNull(@NotNull String ip) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            if (Intrinsics.areEqual((Object)ip, (Object)"localhost") || Intrinsics.areEqual((Object)ip, (Object)"kubernetes.docker.internal")) {
                byte[] byArray = new byte[]{127, 0, 0, 1};
                return new IPv4Address(byArray);
            }
            if (!this.check(ip)) {
                return null;
            }
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)ip, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UStringsKt.toUByte((String)it));
            }
            byte[] bytes = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
            return new IPv4Address(bytes);
        }

        @NotNull
        public final IPv4Address parse(@NotNull String ip) {
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            IPv4Address iPv4Address = this.parseOrNull(ip);
            if (iPv4Address == null) {
                throw new IllegalStateException(("Invalid IPv4 address: " + ip).toString());
            }
            return iPv4Address;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

