/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class XDebuggerEditorsProvider {
    @NotNull
    public abstract FileType getFileType();

    @Deprecated
    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        if (text == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        throw new AbstractMethodError("createDocument must be implemented in " + String.valueOf(this.getClass()));
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode, @Nullable String purpose) {
        if (project == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(5);
        }
        Document document = this.createDocument(project, expression.getExpression(), sourcePosition, mode);
        if (document == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(6);
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(9);
        }
        Document document = this.createDocument(project, expression, sourcePosition, mode, null);
        if (document == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(10);
        }
        return document;
    }

    public void afterEditorCreated(@Nullable Editor editor) {
    }

    @NotNull
    public @Unmodifiable Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        FileType type;
        if (project == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(11);
        }
        Collection<Language> collection = (type = this.getFileType()) instanceof LanguageFileType ? Collections.singleton(((LanguageFileType)type).getLanguage()) : Collections.emptyList();
        if (collection == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @ApiStatus.Internal
    @NotNull
    public @NotNull CompletableFuture<@NotNull @Unmodifiable Collection<Language>> getSupportedLanguagesAsync(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        if (project == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(13);
        }
        CompletableFuture<Collection<Language>> completableFuture = CompletableFuture.completedFuture(this.getSupportedLanguages(project, sourcePosition));
        if (completableFuture == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(15);
        }
        if (document == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(17);
        }
        XExpression xExpression = XDebuggerUtil.getInstance().createExpression(document.getText(), language, null, mode);
        if (xExpression == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(18);
        }
        return xExpression;
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        InlineDebuggerHelper inlineDebuggerHelper = InlineDebuggerHelper.DEFAULT;
        if (inlineDebuggerHelper == null) {
            XDebuggerEditorsProvider.$$$reportNull$$$0(19);
        }
        return inlineDebuggerHelper;
    }

    @ApiStatus.Experimental
    public boolean isEvaluateExpressionFieldEnabled() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12, 14, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/evaluation/XDebuggerEditorsProvider";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguagesAsync";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineDebuggerHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedLanguages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedLanguagesAsync";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 12, 14, 18, 19 -> new IllegalStateException(string);
        };
    }
}

