/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webstorm.typeEngineWidget.survey;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import com.intellij.webstorm.typeEngineWidget.survey.WebStormTypeEngineFeedbackConfigKt;
import com.intellij.webstorm.typeEngineWidget.survey.WebStormTypeEngineFeedbackDialog;
import com.intellij.webstorm.typeEngineWidget.survey.WebStormTypeEngineState;
import com.intellij.webstorm.typeEngineWidget.survey.WebStormTypeEngineSurveyState;
import com.jetbrains.webstorm.WebStormBundle;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J \u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/webstorm/typeEngineWidget/survey/WebStormTypeEngineFeedbackConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "elapsedMinNumberDaysFromFirstDetection", "", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "forTest", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "updateStateAfterNotificationShowed", "", "updateStateAfterDialogClosedOk", "isUsageTimeEnough", "state", "Lcom/intellij/webstorm/typeEngineWidget/survey/WebStormTypeEngineState;", "intellij.webstorm.typeEngineWidget"})
public final class WebStormTypeEngineFeedbackConfig
implements InIdeFeedbackSurveyConfig {
    private final int elapsedMinNumberDaysFromFirstDetection;
    @NotNull
    private final String surveyId;
    private final boolean requireIdeEAP;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, Month.JULY, 31);

    public WebStormTypeEngineFeedbackConfig() {
        this.elapsedMinNumberDaysFromFirstDetection = 3;
        this.surveyId = "webstorm_type_engine_evaluation_feedback";
        this.requireIdeEAP = true;
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isWebStorm();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WebStormTypeEngineState state = WebStormTypeEngineSurveyState.Companion.getInstance().getState();
        TypeScriptCompilerSettings tsSettings = TypeScriptCompilerSettings.Companion.getSettings(project);
        return Registry.Companion.is("typescript.servicePoweredTypeEngine.survey.enabled") && !state.getSurveyShown() && !state.getSurveySubmitted() && WebStormTypeEngineFeedbackConfigKt.isAnyProjectOpenNow() && TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)tsSettings.getUseService(), (boolean)tsSettings.getUseTypesFromServer()) && this.isUsageTimeEnough(state);
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = WebStormBundle.message((String)"typescript.engine.survey.notification.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = WebStormBundle.message((String)"typescript.engine.survey.notification.context", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new RequestFeedbackNotification("Feedback In IDE", string, string2);
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (BlockBasedFeedbackDialog)new WebStormTypeEngineFeedbackDialog(project, forTest);
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WebStormTypeEngineSurveyState.Companion.getInstance().getState().setSurveyShown(true);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WebStormTypeEngineSurveyState.Companion.getInstance().getState().setSurveySubmitted(true);
    }

    private final boolean isUsageTimeEnough(WebStormTypeEngineState state) {
        LocalDateTime endExclusive;
        kotlinx.datetime.LocalDateTime firstUsageTime = state.getFirstTrackedUsage();
        if (firstUsageTime == null) {
            return false;
        }
        LocalDateTime startInclusive = ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)firstUsageTime);
        return Duration.between(startInclusive, endExclusive = LocalDateTime.now()).toDays() >= (long)this.elapsedMinNumberDaysFromFirstDetection;
    }
}

