/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.DeduplicatingVirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class FileIndexBase
implements FileIndex {
    final DirectoryIndex myDirectoryIndex;
    final WorkspaceFileIndexEx myWorkspaceFileIndex;

    FileIndexBase(@NotNull Project project) {
        if (project == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        this.myDirectoryIndex = DirectoryIndex.getInstance(project);
        this.myWorkspaceFileIndex = (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(project);
    }

    protected abstract boolean isScopeDisposed();

    public boolean iterateContent(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        return this.iterateContent(processor, null);
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor, @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        ContentIteratorEx processorEx = FileIndexBase.toContentIteratorEx(processor);
        return this.myWorkspaceFileIndex.processContentUnderDirectory(dir, processorEx, customFilter, fileSet -> !this.isScopeDisposed() && this.isInContent((WorkspaceFileSetWithCustomData<?>)fileSet));
    }

    @NotNull
    private static ContentIteratorEx toContentIteratorEx(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        if (processor instanceof ContentIteratorEx) {
            ContentIteratorEx contentIteratorEx = (ContentIteratorEx)processor;
            if (contentIteratorEx == null) {
                FileIndexBase.$$$reportNull$$$0(5);
            }
            return contentIteratorEx;
        }
        ContentIteratorEx contentIteratorEx = fileOrDir -> processor.processFile(fileOrDir) ? TreeNodeProcessingResult.CONTINUE : TreeNodeProcessingResult.STOP;
        if (contentIteratorEx == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return contentIteratorEx;
    }

    @ApiStatus.Internal
    protected boolean iterateProvidedRootsOfContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter, @NotNull Collection<VirtualFile> topLevelRecursiveRoots, @NotNull Collection<VirtualFile> nonRecursiveRoots) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        if (topLevelRecursiveRoots == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        if (nonRecursiveRoots == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        DeduplicatingVirtualFileFilter deduplicatingFilter = new DeduplicatingVirtualFileFilter(filter);
        ContentIteratorEx processorEx = FileIndexBase.toContentIteratorEx(processor);
        for (VirtualFile root : topLevelRecursiveRoots) {
            if (this.iterateContentUnderDirectory(root, (ContentIterator)processorEx, (VirtualFileFilter)deduplicatingFilter)) continue;
            return false;
        }
        for (VirtualFile root : nonRecursiveRoots) {
            if (!deduplicatingFilter.accept(root) || processorEx.processFileEx(root) != TreeNodeProcessingResult.STOP) continue;
            return false;
        }
        return true;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        return this.iterateContentUnderDirectory(dir, processor, null);
    }

    protected boolean isInContent(@NotNull WorkspaceFileSetWithCustomData<?> fileSet) {
        if (fileSet == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        return fileSet.getKind().isContent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelRecursiveRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonRecursiveRoots";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toContentIteratorEx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toContentIteratorEx";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "iterateProvidedRootsOfContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

