/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters.meters;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileSetLimiter;
import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.LinesStorage;
import com.intellij.util.SystemProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/CsvGzippedMetricsExporter;", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "fileToWrite", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "writeToFile", "storage", "Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/LinesStorage;", "initFileCreating", "", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "instrumentType", "Lio/opentelemetry/sdk/metrics/InstrumentType;", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "metrics", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "updateFileForMetrics", "flush", "shutdown", "Companion", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCsvGzippedMetricsExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsvGzippedMetricsExporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/CsvGzippedMetricsExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,121:1\n1915#2:122\n1916#2:125\n1342#3,2:123\n*S KotlinDebug\n*F\n+ 1 CsvGzippedMetricsExporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/CsvGzippedMetricsExporter\n*L\n62#1:122\n62#1:125\n62#1:123,2\n*E\n"})
public final class CsvGzippedMetricsExporter
implements MetricExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Path fileToWrite;
    @NotNull
    private Path writeToFile;
    @NotNull
    private final LinesStorage storage;
    @NotNull
    private static final Logger LOG;

    public CsvGzippedMetricsExporter(@NotNull Path fileToWrite) {
        Intrinsics.checkNotNullParameter((Object)fileToWrite, (String)"fileToWrite");
        this.writeToFile = this.fileToWrite = fileToWrite;
        this.storage = new LinesStorage(this.fileToWrite);
        this.initFileCreating(this.writeToFile);
    }

    private final void initFileCreating(Path writeToFile) {
        Object object;
        Path parentDir;
        if (!Files.exists(writeToFile, new LinkOption[0]) && !Files.isDirectory(parentDir = writeToFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        CsvGzippedMetricsExporter csvGzippedMetricsExporter = this;
        try {
            CsvGzippedMetricsExporter $this$initFileCreating_u24lambda_u240 = csvGzippedMetricsExporter;
            boolean bl = false;
            ArrayList tmp = new ArrayList();
            List<String> lines = $this$initFileCreating_u24lambda_u240.storage.getLines();
            if (!((Collection)lines).isEmpty()) {
                tmp.addAll(lines);
                $this$initFileCreating_u24lambda_u240.storage.clearStorage();
            }
            $this$initFileCreating_u24lambda_u240.storage.appendHeaderLines();
            if (tmp.size() > 0) {
                Iterator iterator = tmp.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    String line = (String)e;
                    $this$initFileCreating_u24lambda_u240.storage.appendLine(line);
                }
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)LOG);
    }

    @NotNull
    public AggregationTemporality getAggregationTemporality(@NotNull InstrumentType instrumentType) {
        Intrinsics.checkNotNullParameter((Object)instrumentType, (String)"instrumentType");
        return AggregationTemporality.DELTA;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends MetricData> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        if (metrics.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
            return completableResultCode;
        }
        CompletableResultCode result = new CompletableResultCode();
        Iterable $this$forEach$iv = metrics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            MetricData it = (MetricData)element$iv;
            boolean bl = false;
            Sequence sequence = OpenTelemetryUtils.INSTANCE.toCsvStream(it);
            LinesStorage linesStorage = this.storage;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String p0 = (String)element$iv2;
                boolean bl2 = false;
                linesStorage.appendLine(p0);
            }
        }
        try {
            long fileSize = Files.size(this.fileToWrite);
            if (fileSize > 0xA00000L) {
                this.updateFileForMetrics();
            }
            this.storage.dump();
            result.succeed();
        }
        catch (Exception e) {
            LOG.error("Error occurred when writing metrics to file", (Throwable)e);
            result.fail();
        }
        return result;
    }

    private final void updateFileForMetrics() {
        Path newPath;
        this.fileToWrite = newPath = Companion.generatePathForConnectionMetrics();
        this.initFileCreating(newPath);
        this.storage.updateDestFile(this.fileToWrite);
    }

    @Nullable
    public CompletableResultCode flush() {
        this.updateFileForMetrics();
        return CompletableResultCode.ofSuccess();
    }

    @Nullable
    public CompletableResultCode shutdown() {
        this.storage.closeBufferedWriter();
        return CompletableResultCode.ofSuccess();
    }

    static {
        Logger logger = Logger.getInstance(CsvGzippedMetricsExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/CsvGzippedMetricsExporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "generatePathForConnectionMetrics", "Ljava/nio/file/Path;", "generatePathForLuxMetrics", "generatePath", "pathResolvedAgainstLogDir", "maxFilesToKeep", "", "intellij.platform.diagnostic.telemetry.exporters"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path generatePathForConnectionMetrics() {
            String connectionMetricsPath = "open-telemetry-connection-metrics.csv.gz";
            Path pathResolvedAgainstLogDir = PathManager.getLogDir().resolve(connectionMetricsPath).toAbsolutePath();
            int maxFilesToKeep = SystemProperties.getIntProperty((String)"idea.diagnostic.opentelemetry.rdct.metrics.max-files-to-keep", (int)14);
            Intrinsics.checkNotNull((Object)pathResolvedAgainstLogDir);
            return this.generatePath(pathResolvedAgainstLogDir, maxFilesToKeep);
        }

        @NotNull
        public final Path generatePathForLuxMetrics() {
            String luxMetricsPath = "open-telemetry-lux-metrics.csv.gz";
            Path pathResolvedAgainstLogDir = PathManager.getLogDir().resolve(luxMetricsPath).toAbsolutePath();
            int maxFilesToKeep = SystemProperties.getIntProperty((String)"idea.diagnostic.opentelemetry.lux.metrics.max-files-to-keep", (int)14);
            Intrinsics.checkNotNull((Object)pathResolvedAgainstLogDir);
            return this.generatePath(pathResolvedAgainstLogDir, maxFilesToKeep);
        }

        private final Path generatePath(Path pathResolvedAgainstLogDir, int maxFilesToKeep) {
            Path path = FileSetLimiter.inDirectory((Path)pathResolvedAgainstLogDir.getParent()).withBaseNameAndDateFormatSuffix(((Object)pathResolvedAgainstLogDir.getFileName()).toString(), "yyyy-MM-dd-HH-mm-ss").removeOldFilesBut(maxFilesToKeep, FileSetLimiter.DELETE_ASYNC).createNewFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createNewFile(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

