/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCacheImpl;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.diagnostic.telemetry.helpers.Nanoseconds;
import com.intellij.platform.diagnostic.telemetry.helpers.NanosecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.ReferenceChange;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexChangedEvent;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexListener;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ExcludedFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleWorkspaceFileSetsImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.RemoveFileSetsRegistrarImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.StoreFileSetsRegistrarImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplier;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl$collectEntitiesWithChangedParent$;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImplKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataMetrics;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u00af\u0001\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012J\u0010\u000b\u001aF\u0012\u0004\u0012\u00020\r\u00128\u00126\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000ej\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011`\u00130\fj\u0002`\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012$\u0010\u0017\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0019\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00040\u00030\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ@\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020-H\u0016J\b\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;H\u0017J)\u0010<\u001a\u0004\u0018\u0001082\u0006\u0010=\u001a\u00020\t2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u0002080?\u00a2\u0006\u0002\u0010AJ8\u0010B\u001a\u000208\"\b\b\u0000\u0010C*\u00020\u00102\f\u0010D\u001a\b\u0012\u0004\u0012\u0002HC0\u00042\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0002JR\u0010K\u001a\u000208\"\b\b\u0000\u0010L*\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002HL0O2\u0006\u0010E\u001a\u00020F2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00100Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00100Q2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0002Jb\u0010T\u001a\u000208\"\b\b\u0000\u0010L*\u00020\u0010\"\b\b\u0001\u0010C*\u00020\u00102\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u0002HC0V2\u0006\u0010E\u001a\u00020F2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002HL0Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HL0Q2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HL0\u0019H\u0002JT\u0010X\u001a\u000208\"\b\b\u0000\u0010C*\u00020\u0010\"\b\b\u0001\u0010Y*\u00020\u00102\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u0002HY0Z2\u0006\u0010E\u001a\u00020F2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002HC0Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HC0QH\u0002Jh\u0010[\u001a\u000208\"\b\b\u0000\u0010C*\u00020\u0010\"\b\b\u0001\u0010\\*\u00020\u00102\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u0002H\\0]2\u0006\u0010E\u001a\u00020F2\u0016\u0010P\u001a\u0012\u0012\u0004\u0012\u0002HC0^j\b\u0012\u0004\u0012\u0002HC`_2\u0016\u0010R\u001a\u0012\u0012\u0004\u0012\u0002HC0^j\b\u0012\u0004\u0012\u0002HC`_H\u0002J\b\u0010`\u001a\u000208H\u0016J*\u0010a\u001a\u0002082\u0012\u0010b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0c2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\t0cH\u0016J\u0018\u0010e\u001a\u0002082\u0006\u0010E\u001a\u00020F2\u0006\u0010f\u001a\u00020gH\u0016J\b\u0010h\u001a\u000208H\u0016J\b\u0010i\u001a\u000208H\u0016J\u0018\u0010j\u001a\u00020-2\u0006\u0010k\u001a\u00020\t2\u0006\u0010l\u001a\u00020\rH\u0002J \u0010m\u001a\u0002082\u0006\u0010l\u001a\u00020\r2\u000e\u0010n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u0011H\u0002J\u0018\u0010o\u001a\u00020-2\u0006\u0010p\u001a\u00020\t2\u0006\u0010q\u001a\u00020\tH\u0002J\u0018\u0010r\u001a\u00020\t2\u0006\u0010p\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0012\u0010s\u001a\u0004\u0018\u00010\r2\u0006\u0010t\u001a\u00020\tH\u0016J\u001e\u0010u\u001a\b\u0012\u0004\u0012\u00020\t0v2\u0006\u0010l\u001a\u00020\r2\u0006\u0010w\u001a\u00020-H\u0016J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020\t0v2\u0006\u0010l\u001a\u00020\rH\u0016J\b\u0010y\u001a\u000208H\u0016J\b\u0010z\u001a\u000208H\u0016J\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020}0|2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u001c\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u00012\u000e\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010\u0003H\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\u000b\u001aF\u0012\u0004\u0012\u00020\r\u00128\u00126\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000ej\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011`\u00130\fj\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0017\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0019\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00040\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u001c\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u001d0\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n '*\u0004\u0018\u00010&0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010(\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0)j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\t0)j\b\u0012\u0004\u0012\u00020\t`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001\u00b2\u0006\u0011\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020\u00100|X\u008a\u0084\u0002\u00b2\u0006\u0011\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00100|X\u008a\u0084\u0002\u00b2\u0006\u001b\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u0002HL0|\"\b\b\u0000\u0010L*\u00020\u0010X\u008a\u0084\u0002\u00b2\u0006\u001b\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u0002HL0|\"\b\b\u0000\u0010L*\u00020\u0010X\u008a\u0084\u0002"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "contributorList", "", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "project", "Lcom/intellij/openapi/project/Project;", "fileSets", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSetsByPackagePrefix", "Ljava/util/HashMap;", "", "Ljava/util/LinkedHashMap;", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lkotlin/collections/LinkedHashMap;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PackagePrefixStorage;", "nonExistingFilesRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "contributors", "", "Ljava/lang/Class;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;Ljava/util/Map;Ljava/util/HashMap;Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;Ljava/util/Map;)V", "contributorDependencies", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription;", "packageDirectoryCache", "Lcom/intellij/openapi/roots/impl/PackageDirectoryCacheImpl;", "nonIncrementalContributors", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors;", "fileIdWithoutFileSets", "Lcom/intellij/util/containers/ConcurrentBitSet;", "Lorg/jetbrains/annotations/NotNull;", "fileTypeRegistry", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry;", "kotlin.jvm.PlatformType", "dirtyEntities", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "dirtyFiles", "hasDirtyEntities", "", "getFileInfo", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileInternalInfo;", "file", "honorExclusion", "includeContentSets", "includeContentNonIndexableSets", "includeExternalSets", "includeExternalSourceSets", "includeCustomKindSets", "ensureIsUpToDate", "", "visitFileSets", "visitor", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetVisitor;", "processFileSets", "virtualFile", "action", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;)Lkotlin/Unit;", "processChangesByContributor", "E", "contributor", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "storeRegistrar", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoreFileSetsRegistrarImpl;", "removeRegistrar", "Lcom/intellij/workspaceModel/core/fileIndex/impl/RemoveFileSetsRegistrarImpl;", "processOnReference", "R", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "dependencyDescription", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription$OnReference;", "removedEntities", "", "addedEntities", "entityClass", "processOnArbitraryEntityDependency", "dependency", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription$OnArbitraryEntity;", "dependantClass", "collectEntitiesWithChangedParent", "P", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription$OnParent;", "collectEntitiesWithChangedChild", "C", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription$OnChild;", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "resetCustomContributors", "markDirty", "entityPointers", "", "filesToInvalidate", "onEntitiesChanged", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "updateDirtyEntities", "resetFileCache", "isPackageDirectory", "dir", "packageName", "fillPackageFilesAndDirectories", "result", "isVersionRoot", "root", "directory", "correctRoot", "getPackageName", "dirOrFile", "getDirectoriesByPackageName", "Lcom/intellij/util/Query;", "includeLibrarySources", "getFilesByPackageName", "onLowMemory", "clearPackageDirectoryCache", "getNonExistentFileSetKinds", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingFileSetKind;", "url", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "analyzeVfsChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplier;", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.platform.projectModel.impl", "entitiesInStorageAfter", "entitiesInStorageBefore", "dependantEntitiesInStorageAfter", "dependantEntitiesInStorageBefore"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileIndexDataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileIndexDataImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NanosecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/NanosecondsMeasurer\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,840:1\n1300#2,2:841\n1315#2,4:843\n1915#2,2:872\n1915#2,2:874\n777#2:891\n873#2,2:892\n1915#2,2:894\n1480#2,5:896\n1480#2,5:901\n1480#2,5:914\n1480#2,5:919\n43#3,2:847\n45#3:852\n43#3,2:853\n45#3:858\n43#3,2:860\n45#3:865\n43#3,2:866\n45#3:871\n43#3,2:881\n45#3:886\n43#3,2:887\n45#3:907\n43#3,2:908\n45#3:913\n43#3,2:926\n45#3:931\n43#3,2:932\n45#3:937\n45#4,3:849\n45#4,3:855\n45#4,3:862\n45#4,3:868\n45#4,3:883\n45#4,2:889\n47#4:906\n45#4,3:910\n45#4,3:928\n45#4,3:934\n1#5:859\n479#6:876\n1342#6,2:877\n1342#6,2:879\n14060#7,2:924\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileIndexDataImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl\n*L\n152#1:841,2\n152#1:843,4\n339#1:872,2\n356#1:874,2\n425#1:891\n425#1:892,2\n425#1:894,2\n430#1:896,5\n431#1:901,5\n467#1:914,5\n468#1:919,5\n171#1:847,2\n171#1:852\n264#1:853,2\n264#1:858\n298#1:860,2\n298#1:865\n303#1:866,2\n303#1:871\n413#1:881,2\n413#1:886\n421#1:887,2\n421#1:907\n455#1:908,2\n455#1:913\n528#1:926,2\n528#1:931\n549#1:932,2\n549#1:937\n171#1:849,3\n264#1:855,3\n298#1:862,3\n303#1:868,3\n413#1:883,3\n421#1:889,2\n421#1:906\n455#1:910,3\n528#1:928,3\n549#1:934,3\n386#1:876\n386#1:877,2\n396#1:879,2\n495#1:924,2\n*E\n"})
public final class WorkspaceFileIndexDataImpl
implements WorkspaceFileIndexData {
    @NotNull
    private final List<WorkspaceFileIndexContributor<?>> contributorList;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, StoredFileSetCollection> fileSets;
    @NotNull
    private final HashMap<String, LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>>> fileSetsByPackagePrefix;
    @NotNull
    private final NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry;
    @NotNull
    private final Map<Class<WorkspaceEntity>, List<WorkspaceFileIndexContributor<WorkspaceEntity>>> contributors;
    @NotNull
    private final Map<WorkspaceFileIndexContributor<?>, List<DependencyDescription<? extends WorkspaceEntity>>> contributorDependencies;
    @NotNull
    private final PackageDirectoryCacheImpl packageDirectoryCache;
    @NotNull
    private final NonIncrementalContributors nonIncrementalContributors;
    @NotNull
    private final ConcurrentBitSet fileIdWithoutFileSets;
    private final FileTypeRegistry fileTypeRegistry;
    @NotNull
    private final HashSet<EntityPointer<WorkspaceEntity>> dirtyEntities;
    @NotNull
    private final HashSet<VirtualFile> dirtyFiles;
    private volatile boolean hasDirtyEntities;

    /*
     * WARNING - void declaration
     */
    public WorkspaceFileIndexDataImpl(@NotNull List<? extends WorkspaceFileIndexContributor<?>> contributorList, @NotNull Project project, @NotNull Map<VirtualFile, StoredFileSetCollection> fileSets, @NotNull HashMap<String, LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>>> fileSetsByPackagePrefix, @NotNull NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry, @NotNull Map<Class<WorkspaceEntity>, ? extends List<? extends WorkspaceFileIndexContributor<WorkspaceEntity>>> contributors) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(contributorList, (String)"contributorList");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(fileSets, (String)"fileSets");
        Intrinsics.checkNotNullParameter(fileSetsByPackagePrefix, (String)"fileSetsByPackagePrefix");
        Intrinsics.checkNotNullParameter((Object)nonExistingFilesRegistry, (String)"nonExistingFilesRegistry");
        Intrinsics.checkNotNullParameter(contributors, (String)"contributors");
        this.contributorList = contributorList;
        this.project = project;
        this.fileSets = fileSets;
        this.fileSetsByPackagePrefix = fileSetsByPackagePrefix;
        this.nonExistingFilesRegistry = nonExistingFilesRegistry;
        this.contributors = contributors;
        Iterable iterable = this.contributorList;
        WorkspaceFileIndexDataImpl workspaceFileIndexDataImpl = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var10_11 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WorkspaceFileIndexContributor workspaceFileIndexContributor = (WorkspaceFileIndexContributor)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            List list = it.getDependenciesOnOtherEntities();
            map.put(t, list);
        }
        workspaceFileIndexDataImpl.contributorDependencies = destination$iv$iv;
        this.packageDirectoryCache = new PackageDirectoryCacheImpl((arg_0, arg_1) -> WorkspaceFileIndexDataImpl.packageDirectoryCache$lambda$0((Function2)new Function2<String, List<? super VirtualFile>, Unit>((Object)this){

            public final void invoke(String p0, List<? super VirtualFile> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                WorkspaceFileIndexDataImpl.access$fillPackageFilesAndDirectories((WorkspaceFileIndexDataImpl)this.receiver, p0, p1);
            }
        }, arg_0, arg_1), (arg_0, arg_1) -> WorkspaceFileIndexDataImpl.packageDirectoryCache$lambda$1((Function2)new Function2<VirtualFile, String, Boolean>((Object)this){

            public final Boolean invoke(VirtualFile p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return WorkspaceFileIndexDataImpl.access$isPackageDirectory((WorkspaceFileIndexDataImpl)this.receiver, p0, p1);
            }
        }, arg_0, arg_1));
        this.nonIncrementalContributors = new NonIncrementalContributors(this.project);
        ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentBitSet, (String)"create(...)");
        this.fileIdWithoutFileSets = concurrentBitSet;
        this.fileTypeRegistry = FileTypeRegistry.getInstance();
        this.dirtyEntities = new HashSet();
        this.dirtyFiles = new HashSet();
    }

    @Override
    @NotNull
    public WorkspaceFileInternalInfo getFileInfo(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets) {
        WorkspaceFileInternalInfo workspaceFileInternalInfo;
        AtomicLong atomicLong;
        long start$iv$iv;
        WorkspaceFileInternalInfo value$iv;
        block11: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getGetFileInfoTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
            boolean bl = false;
            value$iv = null;
            boolean $i$f$measureNanoTime = false;
            start$iv$iv = System.nanoTime();
            atomicLong = arg0$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!file.isValid()) {
                workspaceFileInternalInfo = WorkspaceFileInternalInfo.NonWorkspace.INVALID;
            } else if (file.getFileSystem() instanceof NonPhysicalFileSystem && file.getParent() == null) {
                workspaceFileInternalInfo = WorkspaceFileInternalInfo.NonWorkspace.NOT_UNDER_ROOTS;
            } else {
                int originalAcceptedKindMask;
                this.ensureIsUpToDate();
                int acceptedKindsMask = originalAcceptedKindMask = (includeContentSets ? 1 : 0) | (includeContentNonIndexableSets ? 16 : 0) | (includeExternalSets ? 2 : 0) | (includeExternalSourceSets ? 4 : 0) | (includeCustomKindSets ? 8 : 0);
                for (VirtualFile current = file; current != null; current = current.getParent()) {
                    boolean mayHaveFileSets;
                    VirtualFile virtualFile = current;
                    VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
                    int fileId = virtualFileWithId != null ? virtualFileWithId.getId() : -1;
                    boolean bl4 = mayHaveFileSets = fileId < 0 || !this.fileIdWithoutFileSets.get(fileId);
                    if (!mayHaveFileSets) continue;
                    StoredFileSetCollection storedFileSets = this.fileSets.get(current);
                    if (storedFileSets != null) {
                        int masks = storedFileSets.computeMasks(acceptedKindsMask << 2, this.project, honorExclusion, file);
                        int storedKindMask = masks & 3;
                        acceptedKindsMask = masks >> 2 & 0x1F;
                        if (acceptedKindsMask == 0) {
                            workspaceFileInternalInfo = WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED;
                            break block11;
                        }
                        if ((storedKindMask & 1) != 0) {
                            if (storedKindMask == 1) {
                                workspaceFileInternalInfo = (WorkspaceFileInternalInfo)((Object)storedFileSets);
                            } else {
                                ArrayList acceptedFileSets = new ArrayList();
                                int currentKindMask = acceptedKindsMask;
                                storedFileSets.forEach((Function1<? super StoredFileSet, Unit>)((Function1)arg_0 -> WorkspaceFileIndexDataImpl.getFileInfo$lambda$0$0(currentKindMask, file, acceptedFileSets, arg_0)));
                                workspaceFileInternalInfo = acceptedFileSets.size() > 1 ? (WorkspaceFileInternalInfo)new MultipleWorkspaceFileSetsImpl(acceptedFileSets) : (WorkspaceFileInternalInfo)CollectionsKt.first((List)acceptedFileSets);
                            }
                            break block11;
                        }
                    }
                    if (this.fileTypeRegistry.isFileIgnored(current)) {
                        workspaceFileInternalInfo = WorkspaceFileInternalInfo.NonWorkspace.IGNORED;
                        break block11;
                    }
                    if (fileId < 0 || storedFileSets != null) continue;
                    this.fileIdWithoutFileSets.set(fileId);
                }
                workspaceFileInternalInfo = originalAcceptedKindMask != acceptedKindsMask ? (WorkspaceFileInternalInfo)WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED : (WorkspaceFileInternalInfo)WorkspaceFileInternalInfo.NonWorkspace.NOT_UNDER_ROOTS;
            }
        }
        value$iv = workspaceFileInternalInfo;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        return value$iv;
    }

    private final void ensureIsUpToDate() {
        SlowOperations.assertSlowOperationsAreAllowed();
        if (this.hasDirtyEntities && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.updateDirtyEntities();
        }
        ThreadingAssertions.assertReadAccess();
        this.nonIncrementalContributors.updateIfNeeded(this.fileSets, this.fileSetsByPackagePrefix, this.nonExistingFilesRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresReadLock
    public void visitFileSets(@NotNull WorkspaceFileSetVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        ThreadingAssertions.assertReadAccess();
        long start2 = Nanoseconds.Companion.now-LxeuWQM();
        try {
            this.ensureIsUpToDate();
            Function1 action = arg_0 -> WorkspaceFileIndexDataImpl.visitFileSets$lambda$0(visitor2, arg_0);
            for (StoredFileSetCollection value : this.fileSets.values()) {
                value.forEach((Function1<? super StoredFileSet, Unit>)action);
            }
        }
        finally {
            NanosecondsMeasurer.addElapsedTime-D2aE-ow((AtomicLong)WorkspaceFileIndexDataMetrics.INSTANCE.getVisitFileSetsTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl(), (long)start2);
        }
    }

    @Nullable
    public final Unit processFileSets(@NotNull VirtualFile virtualFile, @NotNull Function1<? super StoredFileSet, Unit> action) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getProcessFileSetsTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        StoredFileSetCollection storedFileSetCollection = this.fileSets.get(virtualFile);
        if (storedFileSetCollection != null) {
            storedFileSetCollection.forEach(action);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        value$iv = unit;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        return value$iv;
    }

    private final <E extends WorkspaceEntity> void processChangesByContributor(WorkspaceFileIndexContributor<E> contributor, VersionedStorageChange event, StoreFileSetsRegistrarImpl storeRegistrar, RemoveFileSetsRegistrarImpl removeRegistrar) {
        LinkedHashSet<WorkspaceEntity> removedEntities = new LinkedHashSet<WorkspaceEntity>();
        LinkedHashSet<WorkspaceEntity> addedEntities = new LinkedHashSet<WorkspaceEntity>();
        for (EntityChange change : event.getChanges(contributor.getEntityClass())) {
            WorkspaceEntity it;
            if (change.getOldEntity() != null) {
                boolean bl = false;
                removedEntities.add(it);
            }
            if (change.getNewEntity() == null) continue;
            boolean bl = false;
            addedEntities.add(it);
        }
        for (DependencyDescription dependency : (List)MapsKt.getValue(this.contributorDependencies, contributor)) {
            DependencyDescription dependencyDescription = dependency;
            if (dependencyDescription instanceof DependencyDescription.OnParent) {
                DependencyDescription dependencyDescription2 = dependency;
                Intrinsics.checkNotNull((Object)dependencyDescription2, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.DependencyDescription.OnParent<E of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl.processChangesByContributor, *>");
                this.collectEntitiesWithChangedParent((DependencyDescription.OnParent)dependencyDescription2, event, removedEntities, addedEntities);
                continue;
            }
            if (dependencyDescription instanceof DependencyDescription.OnChild) {
                DependencyDescription dependencyDescription3 = dependency;
                Intrinsics.checkNotNull((Object)dependencyDescription3, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.DependencyDescription.OnChild<E of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl.processChangesByContributor, *>");
                this.collectEntitiesWithChangedChild((DependencyDescription.OnChild)dependencyDescription3, event, removedEntities, addedEntities);
                continue;
            }
            if (dependencyDescription instanceof DependencyDescription.OnArbitraryEntity) {
                DependencyDescription dependencyDescription4 = dependency;
                Intrinsics.checkNotNull((Object)dependencyDescription4, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.DependencyDescription.OnArbitraryEntity<E of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl.processChangesByContributor, *>");
                this.processOnArbitraryEntityDependency((DependencyDescription.OnArbitraryEntity)dependencyDescription4, event, (Set)removedEntities, (Set)addedEntities, contributor.getEntityClass());
                continue;
            }
            if (dependencyDescription instanceof DependencyDescription.OnReference) {
                DependencyDescription.OnReference onReference = (DependencyDescription.OnReference)dependency;
                Set set = TypeIntrinsics.asMutableSet(removedEntities);
                Set set2 = TypeIntrinsics.asMutableSet(addedEntities);
                Class<WorkspaceEntity> clazz = contributor.getEntityClass();
                Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<com.intellij.platform.workspace.storage.WorkspaceEntity>");
                this.processOnReference(onReference, event, set, set2, clazz);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getRegisterFileSetsTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = removedEntities.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            WorkspaceEntity removed = (WorkspaceEntity)e;
            contributor.registerFileSets(removed, removeRegistrar, (EntityStorage)event.getStorageBefore());
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getRegisterFileSetsTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        bl = false;
        value$iv = null;
        $i$f$measureNanoTime = false;
        start$iv$iv = System.nanoTime();
        atomicLong = arg0$iv;
        bl2 = false;
        boolean bl4 = false;
        Iterator iterator3 = addedEntities.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            WorkspaceEntity added = (WorkspaceEntity)e;
            contributor.registerFileSets(added, storeRegistrar, (EntityStorage)event.getStorageAfter());
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
    }

    private final <R extends WorkspaceEntityWithSymbolicId> void processOnReference(DependencyDescription.OnReference<R> dependencyDescription, VersionedStorageChange event, Set<WorkspaceEntity> removedEntities, Set<WorkspaceEntity> addedEntities, Class<WorkspaceEntity> entityClass) {
        Lazy entitiesInStorageAfter$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WorkspaceFileIndexDataImpl.processOnReference$lambda$0(event, entityClass));
        Lazy entitiesInStorageBefore$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WorkspaceFileIndexDataImpl.processOnReference$lambda$2(event, entityClass));
        Iterable $this$forEach$iv = event.getChangedReferences(dependencyDescription.getReferenceSymbolicEntityIdClass());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReferenceChange it = (ReferenceChange)element$iv;
            boolean bl = false;
            ReferenceChange referenceChange = it;
            if (referenceChange instanceof ReferenceChange.Added) {
                WorkspaceFileIndexDataImpl.processOnReference$processAddedSymbolicEntityId(event, addedEntities, removedEntities, (Lazy<? extends Set<? extends WorkspaceEntity>>)entitiesInStorageBefore$delegate, ((ReferenceChange.Added)it).getSymbolicEntityId());
                continue;
            }
            if (referenceChange instanceof ReferenceChange.Removed) {
                WorkspaceFileIndexDataImpl.processOnReference$processRemovedSymbolicEntityId(event, removedEntities, addedEntities, (Lazy<? extends Set<? extends WorkspaceEntity>>)entitiesInStorageAfter$delegate, ((ReferenceChange.Removed)it).getSymbolicEntityId());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final <R extends WorkspaceEntity, E extends WorkspaceEntity> void processOnArbitraryEntityDependency(DependencyDescription.OnArbitraryEntity<R, E> dependency, VersionedStorageChange event, Set<R> removedEntities, Set<R> addedEntities, Class<R> dependantClass) {
        Lazy dependantEntitiesInStorageAfter$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WorkspaceFileIndexDataImpl.processOnArbitraryEntityDependency$lambda$0(event, dependantClass));
        Lazy dependantEntitiesInStorageBefore$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> WorkspaceFileIndexDataImpl.processOnArbitraryEntityDependency$lambda$2(event, dependantClass));
        Iterable $this$forEach$iv = event.getChanges(dependency.getEntityClass());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sequence dependantEntities;
            WorkspaceEntity it;
            EntityChange change = (EntityChange)element$iv;
            boolean bl = false;
            if (change.getOldEntity() != null) {
                boolean bl2 = false;
                dependantEntities = (Sequence)dependency.getDependantEntitiesGetter().invoke((Object)it);
                for (WorkspaceEntity entity : dependantEntities) {
                    removedEntities.add(entity);
                    if (!WorkspaceFileIndexDataImpl.processOnArbitraryEntityDependency$lambda$1(dependantEntitiesInStorageAfter$delegate).contains(entity)) continue;
                    addedEntities.add(entity);
                }
            }
            if (change.getNewEntity() == null) continue;
            boolean bl3 = false;
            dependantEntities = (Sequence)dependency.getDependantEntitiesGetter().invoke((Object)it);
            for (WorkspaceEntity entity : dependantEntities) {
                addedEntities.add(entity);
                if (!WorkspaceFileIndexDataImpl.processOnArbitraryEntityDependency$lambda$3(dependantEntitiesInStorageBefore$delegate).contains(entity)) continue;
                removedEntities.add(entity);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends WorkspaceEntity, P extends WorkspaceEntity> void collectEntitiesWithChangedParent(DependencyDescription.OnParent<E, P> dependency, VersionedStorageChange event, Set<E> removedEntities, Set<E> addedEntities) {
        void $this$forEach$iv;
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)event.getChanges(dependency.getParentClass()));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectEntitiesWithChangedParent$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        $this$filterIsInstance$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityChange.Replaced change = (EntityChange.Replaced)element$iv;
            boolean bl = false;
            SequencesKt.toCollection((Sequence)((Sequence)dependency.getChildrenGetter().invoke((Object)change.getOldEntity())), (Collection)removedEntities);
            SequencesKt.toCollection((Sequence)((Sequence)dependency.getChildrenGetter().invoke((Object)change.getNewEntity())), (Collection)addedEntities);
        }
    }

    private final <E extends WorkspaceEntity, C extends WorkspaceEntity> void collectEntitiesWithChangedChild(DependencyDescription.OnChild<E, C> dependency, VersionedStorageChange event, LinkedHashSet<E> removedEntities, LinkedHashSet<E> addedEntities) {
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)event.getChanges(dependency.getChildClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity it;
            EntityChange change = (EntityChange)element$iv;
            boolean bl = false;
            if (change.getOldEntity() != null) {
                boolean bl2 = false;
                removedEntities.add(dependency.getParentGetter().invoke((Object)it));
            }
            if (change.getNewEntity() == null) continue;
            boolean bl3 = false;
            addedEntities.add(dependency.getParentGetter().invoke((Object)it));
        }
    }

    @Override
    public void resetCustomContributors() {
        ThreadingAssertions.assertWriteAccess();
        this.nonIncrementalContributors.resetCache();
        this.resetFileCache();
    }

    @Override
    public void markDirty(@NotNull Collection<? extends EntityPointer<? extends WorkspaceEntity>> entityPointers, @NotNull Collection<? extends VirtualFile> filesToInvalidate) {
        Intrinsics.checkNotNullParameter(entityPointers, (String)"entityPointers");
        Intrinsics.checkNotNullParameter(filesToInvalidate, (String)"filesToInvalidate");
        AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getMarkDirtyTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ThreadingAssertions.assertWriteAccess();
        this.dirtyEntities.addAll(entityPointers);
        this.dirtyFiles.addAll(filesToInvalidate);
        this.hasDirtyEntities = !((Collection)this.dirtyEntities).isEmpty();
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEntitiesChanged(@NotNull VersionedStorageChange event, @NotNull EntityStorageKind storageKind) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getOnEntitiesChangedTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ThreadingAssertions.assertWriteAccess();
        RemoveFileSetsRegistrarImpl removeRegistrar = new RemoveFileSetsRegistrarImpl(storageKind, this.nonExistingFilesRegistry, this.fileSets, this.fileSetsByPackagePrefix);
        StoreFileSetsRegistrarImpl storeRegistrar = new StoreFileSetsRegistrarImpl(storageKind, this.nonExistingFilesRegistry, this.fileSets, this.fileSetsByPackagePrefix);
        Iterable $this$filter$iv = this.contributorList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            WorkspaceFileIndexContributor it = (WorkspaceFileIndexContributor)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getStorageKind() == storageKind)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceFileIndexContributor it = (WorkspaceFileIndexContributor)element$iv;
            boolean bl5 = false;
            this.processChangesByContributor(it, event, storeRegistrar, removeRegistrar);
        }
        this.resetFileCache();
        if (!storeRegistrar.getRegisteredFileSets().isEmpty() || !removeRegistrar.getRemovedFileSets().isEmpty()) {
            Iterable list$iv;
            Set it;
            Iterable $this$flatMapTo$iv;
            Iterable $i$f$forEach2 = removeRegistrar.getRemovedFileSets().values();
            Collection destination$iv = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                it = (Set)element$iv;
                boolean bl6 = false;
                list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Collection collection = destination$iv;
            $this$flatMapTo$iv = storeRegistrar.getRegisteredFileSets().values();
            destination$iv = new HashSet();
            Collection collection2 = collection;
            $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                it = (Set)element$iv;
                boolean bl7 = false;
                list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            EntityStorage entityStorage = (EntityStorage)event.getStorageAfter();
            EntityStorage entityStorage2 = (EntityStorage)event.getStorageBefore();
            Collection collection3 = destination$iv;
            Collection collection4 = collection2;
            WorkspaceFileIndexChangedEvent changeLog = new WorkspaceFileIndexChangedEvent(collection4, collection3, entityStorage2, entityStorage);
            ((WorkspaceFileIndexListener)this.project.getMessageBus().syncPublisher(WorkspaceFileIndexListener.Companion.getTOPIC())).workspaceFileIndexChanged(changeLog);
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
    }

    @Override
    public void updateDirtyEntities() {
        Object reference;
        long start2 = Nanoseconds.Companion.now-LxeuWQM();
        ThreadingAssertions.assertWriteAccess();
        Iterator<VirtualFile> iterator = this.dirtyFiles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<VirtualFile> iterator2 = iterator;
        while (iterator2.hasNext()) {
            VirtualFile file;
            StoredFileSetCollection collection;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            StoredFileSetCollection storedFileSetCollection = collection = this.fileSets.remove(file);
            if (storedFileSetCollection == null) continue;
            storedFileSetCollection.forEach((Function1<? super StoredFileSet, Unit>)((Function1)arg_0 -> WorkspaceFileIndexDataImpl.updateDirtyEntities$lambda$0(this, arg_0)));
        }
        ImmutableEntityStorage storage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        RemoveFileSetsRegistrarImpl removeRegistrar = new RemoveFileSetsRegistrarImpl(EntityStorageKind.MAIN, this.nonExistingFilesRegistry, this.fileSets, this.fileSetsByPackagePrefix);
        StoreFileSetsRegistrarImpl storeRegistrar = new StoreFileSetsRegistrarImpl(EntityStorageKind.MAIN, this.nonExistingFilesRegistry, this.fileSets, this.fileSetsByPackagePrefix);
        Iterator<EntityPointer<WorkspaceEntity>> iterator3 = this.dirtyEntities.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator<EntityPointer<WorkspaceEntity>> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            List<WorkspaceFileIndexContributor<WorkspaceEntity>> contributors;
            WorkspaceEntity entity;
            Intrinsics.checkNotNullExpressionValue(iterator4.next(), (String)"next(...)");
            if (reference.resolve((EntityStorage)storage) == null || this.contributors.get(entity.getEntityInterface()) == null) continue;
            AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getRegisterFileSetsTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
            boolean bl = false;
            Unit value$iv = null;
            boolean $i$f$measureNanoTime = false;
            long start$iv$iv = System.nanoTime();
            AtomicLong atomicLong = arg0$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            WorkspaceFileIndexDataImplKt.access$registerFileSets(entity, (EntityStorage)storage, removeRegistrar, contributors);
            WorkspaceFileIndexDataImplKt.access$registerFileSets(entity, (EntityStorage)storage, storeRegistrar, contributors);
            value$iv = Unit.INSTANCE;
            atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        }
        this.dirtyFiles.clear();
        this.dirtyEntities.clear();
        this.resetFileCache();
        this.hasDirtyEntities = false;
        NanosecondsMeasurer.addElapsedTime-D2aE-ow((AtomicLong)WorkspaceFileIndexDataMetrics.INSTANCE.getUpdateDirtyEntitiesTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl(), (long)start2);
        if (!storeRegistrar.getRegisteredFileSets().isEmpty() || !removeRegistrar.getRemovedFileSets().isEmpty()) {
            Iterable list$iv;
            Set it;
            Iterable $this$flatMapTo$iv;
            reference = removeRegistrar.getRemovedFileSets().values();
            Collection destination$iv = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                it = (Set)element$iv;
                boolean bl = false;
                list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Collection collection = destination$iv;
            $this$flatMapTo$iv = storeRegistrar.getRegisteredFileSets().values();
            destination$iv = new HashSet();
            Collection collection2 = collection;
            $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                it = (Set)element$iv;
                boolean bl = false;
                list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            EntityStorage entityStorage = (EntityStorage)storage;
            EntityStorage entityStorage2 = (EntityStorage)storage;
            Collection collection3 = destination$iv;
            Collection collection4 = collection2;
            WorkspaceFileIndexChangedEvent changeLog = new WorkspaceFileIndexChangedEvent(collection4, collection3, entityStorage2, entityStorage);
            ((WorkspaceFileIndexListener)this.project.getMessageBus().syncPublisher(WorkspaceFileIndexListener.Companion.getTOPIC())).workspaceFileIndexChanged(changeLog);
        }
    }

    @Override
    public void resetFileCache() {
        this.fileIdWithoutFileSets.clear();
        this.packageDirectoryCache.clear();
    }

    private final boolean isPackageDirectory(VirtualFile dir, String packageName) {
        return Intrinsics.areEqual((Object)this.getPackageName(dir), (Object)packageName);
    }

    private final void fillPackageFilesAndDirectories(String packageName, List<? super VirtualFile> result) {
        HashSet<VirtualFile> addedRoots = new HashSet<VirtualFile>();
        LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>> linkedHashMap = this.fileSetsByPackagePrefix.get(packageName);
        if (linkedHashMap == null) {
            return;
        }
        LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>> map = linkedHashMap;
        Iterator<List<WorkspaceFileSetImpl>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List<WorkspaceFileSetImpl> list;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            for (WorkspaceFileSetImpl fileSet : list) {
                VirtualFile root = fileSet.getRoot();
                if (!root.isValid()) continue;
                if (addedRoots.add(root)) {
                    result.add((VirtualFile)root);
                }
                if (!Intrinsics.areEqual((Object)root.getFileSystem().getProtocol(), (Object)"jar")) continue;
                VirtualFile[] virtualFileArray = root.findChild("META-INF");
                if (virtualFileArray == null || (virtualFileArray = virtualFileArray.findChild("versions")) == null || (virtualFileArray = virtualFileArray.getChildren()) == null) continue;
                VirtualFile[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile versionRoot = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String string = versionRoot.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Integer version = StringsKt.toIntOrNull((String)string);
                    if (version == null || version < 9 || !addedRoots.add(versionRoot)) continue;
                    Intrinsics.checkNotNull((Object)versionRoot);
                    result.add((VirtualFile)versionRoot);
                }
            }
        }
    }

    private final boolean isVersionRoot(VirtualFile root, VirtualFile directory) {
        VirtualFile grandParent;
        VirtualFile virtualFile = directory.getParent();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile parent = virtualFile;
        if (Intrinsics.areEqual((Object)parent.getName(), (Object)"versions") && (grandParent = parent.getParent()) != null && Intrinsics.areEqual((Object)grandParent.getName(), (Object)"META-INF") && Intrinsics.areEqual((Object)root, (Object)grandParent.getParent())) {
            String string = directory.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Integer version = StringsKt.toIntOrNull((String)string);
            return version != null && version >= 9;
        }
        return false;
    }

    private final VirtualFile correctRoot(VirtualFile root, VirtualFile file) {
        if (!(root.getFileType() instanceof ArchiveFileType)) {
            return root;
        }
        VirtualFile cur = file;
        while (!Intrinsics.areEqual((Object)cur, (Object)root)) {
            if (this.isVersionRoot(root, cur)) {
                return cur;
            }
            Intrinsics.checkNotNullExpressionValue((Object)cur.getParent(), (String)"getParent(...)");
        }
        return root;
    }

    @Override
    @Nullable
    public String getPackageName(@NotNull VirtualFile dirOrFile) {
        Object object;
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData;
        Intrinsics.checkNotNullParameter((Object)dirOrFile, (String)"dirOrFile");
        AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getGetPackageNameTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        boolean bl = false;
        String value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        WorkspaceFileInternalInfo info = this.getFileInfo(dirOrFile, true, true, true, true, true, true);
        if (info instanceof WorkspaceFileSetWithCustomData) {
            WorkspaceFileInternalInfo workspaceFileInternalInfo;
            WorkspaceFileInternalInfo it = workspaceFileInternalInfo = info;
            boolean bl4 = false;
            workspaceFileSetWithCustomData = (WorkspaceFileSetWithCustomData)((Object)(((WorkspaceFileSetWithCustomData)((Object)it)).getData() instanceof JvmPackageRootDataInternal ? workspaceFileInternalInfo : null));
        } else {
            workspaceFileSetWithCustomData = info instanceof MultipleWorkspaceFileSets ? ((MultipleWorkspaceFileSets)info).find(JvmPackageRootDataInternal.class) : null;
        }
        if (workspaceFileSetWithCustomData == null) {
            object = null;
        } else {
            WorkspaceFileSetWithCustomData fileSet = workspaceFileSetWithCustomData;
            Object obj = fileSet.getData();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal");
            String packagePrefix = ((JvmPackageRootDataInternal)obj).getPackagePrefix();
            if (!fileSet.getRoot().isDirectory()) {
                object = packagePrefix;
            } else {
                VirtualFile dir;
                VirtualFile virtualFile = dir = dirOrFile.isDirectory() ? dirOrFile : dirOrFile.getParent();
                if (!dir.isDirectory()) {
                    object = null;
                } else {
                    VirtualFile virtualFile2 = fileSet.getRoot();
                    Intrinsics.checkNotNull((Object)dir);
                    String string = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)this.correctRoot(virtualFile2, dir), (char)'.');
                    if (string == null) {
                        throw new IllegalStateException((dir.getPresentableUrl() + " is not under " + fileSet.getRoot().getPresentableUrl()).toString());
                    }
                    String packageName = string;
                    object = ((CharSequence)packagePrefix).length() == 0 ? packageName : (((CharSequence)packageName).length() == 0 ? packagePrefix : packagePrefix + "." + packageName);
                }
            }
        }
        value$iv = object;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        return value$iv;
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        AtomicLong arg0$iv = WorkspaceFileIndexDataMetrics.INSTANCE.getGetDirectoriesByPackageNameTimeNanosec-vjg3Xho$intellij_platform_projectModel_impl();
        boolean bl = false;
        Query value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        CollectionQuery query = new CollectionQuery((Collection)this.packageDirectoryCache.getDirectoriesByPackageName(packageName));
        value$iv = includeLibrarySources ? (Query)query : query.filtering(arg_0 -> WorkspaceFileIndexDataImpl.getDirectoriesByPackageName$lambda$0$1(arg_0 -> WorkspaceFileIndexDataImpl.getDirectoriesByPackageName$lambda$0$0(this, arg_0), arg_0));
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        return value$iv;
    }

    @Override
    @NotNull
    public Query<VirtualFile> getFilesByPackageName(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return (Query)new CollectionQuery((Collection)this.packageDirectoryCache.getFilesByPackageName(packageName));
    }

    @Override
    public void onLowMemory() {
        this.packageDirectoryCache.onLowMemory();
    }

    @Override
    public void clearPackageDirectoryCache() {
        this.packageDirectoryCache.clear();
    }

    @Override
    @NotNull
    public Set<NonExistingFileSetKind> getNonExistentFileSetKinds(@NotNull VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.nonExistingFilesRegistry.getFileSetKindsFor(url);
    }

    @Override
    @Nullable
    public VfsChangeApplier analyzeVfsChanges(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        return this.nonExistingFilesRegistry.analyzeVfsChanges(events, this);
    }

    private static final void packageDirectoryCache$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final boolean packageDirectoryCache$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final Unit getFileInfo$lambda$0$0(int $currentKindMask, VirtualFile $file, ArrayList $acceptedFileSets, StoredFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        if (fileSet instanceof WorkspaceFileSetImpl && ((WorkspaceFileSetImpl)fileSet).accepts($currentKindMask, $file)) {
            $acceptedFileSets.add(fileSet);
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitFileSets$lambda$0(WorkspaceFileSetVisitor $visitor, StoredFileSet storedFileSet) {
        Intrinsics.checkNotNullParameter((Object)storedFileSet, (String)"storedFileSet");
        StoredFileSet storedFileSet2 = storedFileSet;
        if (storedFileSet2 instanceof WorkspaceFileSetImpl) {
            $visitor.visitIncludedRoot((WorkspaceFileSet)((Object)storedFileSet), ((WorkspaceFileSetImpl)storedFileSet).getEntityPointer());
        } else if (!(storedFileSet2 instanceof ExcludedFileSet)) {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Set<WorkspaceEntity> processOnReference$lambda$1(Lazy<? extends Set<? extends WorkspaceEntity>> $entitiesInStorageAfter$delegate) {
        Lazy<? extends Set<? extends WorkspaceEntity>> lazy = $entitiesInStorageAfter$delegate;
        return (Set)lazy.getValue();
    }

    private static final Set processOnReference$lambda$0(VersionedStorageChange $event, Class $entityClass) {
        return SequencesKt.toSet((Sequence)$event.getStorageAfter().entities($entityClass));
    }

    private static final Set<WorkspaceEntity> processOnReference$lambda$3(Lazy<? extends Set<? extends WorkspaceEntity>> $entitiesInStorageBefore$delegate) {
        Lazy<? extends Set<? extends WorkspaceEntity>> lazy = $entitiesInStorageBefore$delegate;
        return (Set)lazy.getValue();
    }

    private static final Set processOnReference$lambda$2(VersionedStorageChange $event, Class $entityClass) {
        return SequencesKt.toSet((Sequence)$event.getStorageBefore().entities($entityClass));
    }

    private static final <R extends WorkspaceEntityWithSymbolicId> void processOnReference$processAddedSymbolicEntityId(VersionedStorageChange $event, Set<WorkspaceEntity> $addedEntities, Set<WorkspaceEntity> $removedEntities, Lazy<? extends Set<? extends WorkspaceEntity>> entitiesInStorageBefore$delegate, SymbolicEntityId<? extends R> symbolicEntityId) {
        block1: {
            WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = symbolicEntityId.resolve((EntityStorage)$event.getStorageAfter());
            if (workspaceEntityWithSymbolicId == null) break block1;
            WorkspaceEntityWithSymbolicId referencedEntity = workspaceEntityWithSymbolicId;
            boolean bl = false;
            $addedEntities.add((WorkspaceEntity)referencedEntity);
            if (WorkspaceFileIndexDataImpl.processOnReference$lambda$3(entitiesInStorageBefore$delegate).contains(referencedEntity)) {
                $removedEntities.add((WorkspaceEntity)referencedEntity);
            }
        }
    }

    private static final <R extends WorkspaceEntityWithSymbolicId> void processOnReference$processRemovedSymbolicEntityId(VersionedStorageChange $event, Set<WorkspaceEntity> $removedEntities, Set<WorkspaceEntity> $addedEntities, Lazy<? extends Set<? extends WorkspaceEntity>> entitiesInStorageAfter$delegate, SymbolicEntityId<? extends R> symbolicEntityId) {
        block1: {
            WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = symbolicEntityId.resolve((EntityStorage)$event.getStorageBefore());
            if (workspaceEntityWithSymbolicId == null) break block1;
            WorkspaceEntityWithSymbolicId it = workspaceEntityWithSymbolicId;
            boolean bl = false;
            $removedEntities.add((WorkspaceEntity)it);
            if (WorkspaceFileIndexDataImpl.processOnReference$lambda$1(entitiesInStorageAfter$delegate).contains(it)) {
                $addedEntities.add((WorkspaceEntity)it);
            }
        }
    }

    private static final <R extends WorkspaceEntity> Set<R> processOnArbitraryEntityDependency$lambda$1(Lazy<? extends Set<? extends R>> $dependantEntitiesInStorageAfter$delegate) {
        Lazy<? extends Set<? extends R>> lazy = $dependantEntitiesInStorageAfter$delegate;
        return (Set)lazy.getValue();
    }

    private static final Set processOnArbitraryEntityDependency$lambda$0(VersionedStorageChange $event, Class $dependantClass) {
        return SequencesKt.toSet((Sequence)$event.getStorageAfter().entities($dependantClass));
    }

    private static final <R extends WorkspaceEntity> Set<R> processOnArbitraryEntityDependency$lambda$3(Lazy<? extends Set<? extends R>> $dependantEntitiesInStorageBefore$delegate) {
        Lazy<? extends Set<? extends R>> lazy = $dependantEntitiesInStorageBefore$delegate;
        return (Set)lazy.getValue();
    }

    private static final Set processOnArbitraryEntityDependency$lambda$2(VersionedStorageChange $event, Class $dependantClass) {
        return SequencesKt.toSet((Sequence)$event.getStorageBefore().entities($dependantClass));
    }

    private static final Unit updateDirtyEntities$lambda$0(WorkspaceFileIndexDataImpl this$0, StoredFileSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dirtyEntities.add(it.getEntityPointer());
        return Unit.INSTANCE;
    }

    private static final boolean getDirectoriesByPackageName$lambda$0$0(WorkspaceFileIndexDataImpl this$0, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return !(this$0.getFileInfo(it, true, true, true, true, false, true) instanceof WorkspaceFileInternalInfo.NonWorkspace);
    }

    private static final boolean getDirectoriesByPackageName$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$fillPackageFilesAndDirectories(WorkspaceFileIndexDataImpl $this, String packageName, List result) {
        $this.fillPackageFilesAndDirectories(packageName, result);
    }

    public static final /* synthetic */ boolean access$isPackageDirectory(WorkspaceFileIndexDataImpl $this, VirtualFile dir, String packageName) {
        return $this.isPackageDirectory(dir, packageName);
    }
}

