/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization;

import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0001\rJ\"\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H&J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/FieldsToAnonymizeStorage;", "", "createFieldsToAnonymize", "", "Lcom/jetbrains/fus/reporting/anonymization/FieldsToAnonymizeStorage$Event;", "", "", "descriptors", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "getFieldsToAnonymize", "groupId", "eventId", "getSkipAnonymizationIds", "Event", "anonymization"})
public interface FieldsToAnonymizeStorage {
    @NotNull
    public Set<String> getFieldsToAnonymize(@NotNull String var1, @NotNull String var2);

    @NotNull
    public Set<String> getSkipAnonymizationIds();

    @NotNull
    default public Map<Event, Set<String>> createFieldsToAnonymize(@NotNull EventGroupRemoteDescriptors descriptors) {
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        Map result = new LinkedHashMap();
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group : descriptors.groups) {
            if (group.id == null) continue;
            List list = group.anonymized_fields;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (EventGroupRemoteDescriptors.AnonymizedFields anonymizedField : list) {
                String groupId;
                HashSet<String> fields = anonymizedField.fields;
                String event = anonymizedField.event;
                Collection collection = fields;
                if (collection == null || collection.isEmpty() || event == null) continue;
                result.put(new Event(groupId, event), fields);
            }
        }
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/FieldsToAnonymizeStorage$Event;", "", "groupId", "", "eventId", "(Ljava/lang/String;Ljava/lang/String;)V", "getEventId", "()Ljava/lang/String;", "getGroupId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "anonymization"})
    public static final class Event {
        @NotNull
        private final String groupId;
        @NotNull
        private final String eventId;

        public Event(@NotNull String groupId, @NotNull String eventId) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            this.groupId = groupId;
            this.eventId = eventId;
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public final String getEventId() {
            return this.eventId;
        }

        @NotNull
        public final String component1() {
            return this.groupId;
        }

        @NotNull
        public final String component2() {
            return this.eventId;
        }

        @NotNull
        public final Event copy(@NotNull String groupId, @NotNull String eventId) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            return new Event(groupId, eventId);
        }

        public static /* synthetic */ Event copy$default(Event event, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = event.groupId;
            }
            if ((n & 2) != 0) {
                string2 = event.eventId;
            }
            return event.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Event(groupId=" + this.groupId + ", eventId=" + this.eventId + ")";
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = result * 31 + this.eventId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)event.groupId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eventId, (Object)event.eventId);
        }
    }
}

