/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.HtmlSkipReferenceCheck;
import com.intellij.codeInsight.daemon.impl.analysis.XmlPathReferenceInspection;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public final class HtmlUnknownTargetInspection
extends XmlPathReferenceInspection {
    @NotNull
    public String getShortName() {
        return "HtmlUnknownTarget";
    }

    @Override
    protected boolean isForHtml() {
        return true;
    }

    @Override
    protected boolean needToCheckRef(PsiReference reference) {
        return super.needToCheckRef(reference) && !(reference instanceof AnchorReference) && HtmlUnknownTargetInspection.notRemoteBase(reference) && !HtmlSkipReferenceCheck.isSkip(reference);
    }

    static boolean notRemoteBase(PsiReference reference) {
        PsiFile psiFile = reference.getElement().getContainingFile();
        String basePath = psiFile instanceof XmlFile ? HtmlUtil.getHrefBase((XmlFile)((XmlFile)psiFile)) : null;
        return basePath == null || !HtmlUtil.hasHtmlPrefix((String)basePath);
    }
}

