/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.DumbAware;
import com.intellij.pom.PomIconProvider;
import com.intellij.pom.PomTarget;
import com.intellij.util.xml.DomTarget;
import org.jetbrains.annotations.NotNull;

import javax.swing.Icon;

public class DefaultDomTargetIconProvider extends PomIconProvider implements DumbAware {
  @Override
  public Icon getIcon(@NotNull PomTarget target, int flags) {
    if (target instanceof DomTarget) {
      return ((DomTarget)target).getDomElement().getPresentation().getIcon();
    }
    return null;
  }
}
