/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.ui.DomColumnInfo;
import com.intellij.util.xml.ui.ErrorableTableCellRenderer;
import java.lang.reflect.Type;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ChildGenericValueColumnInfo<T extends DomElement>
extends DomColumnInfo<T, String> {
    private final TableCellEditor myEditor;
    private final DomFixedChildDescription myChildDescription;

    public ChildGenericValueColumnInfo(@NlsContexts.ColumnName String name, @NotNull DomFixedChildDescription description, TableCellRenderer renderer, TableCellEditor editor) {
        if (description == null) {
            ChildGenericValueColumnInfo.$$$reportNull$$$0(0);
        }
        super(name, renderer);
        this.myEditor = editor;
        this.myChildDescription = description;
    }

    public ChildGenericValueColumnInfo(@NlsContexts.ColumnName String name, DomFixedChildDescription description, TableCellEditor editor) {
        this(name, description, new DefaultTableCellRenderer(), editor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChildGenericValueColumnInfo that = (ChildGenericValueColumnInfo)((Object)o);
        return this.myChildDescription.equals(that.myChildDescription);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myChildDescription.hashCode();
        return result;
    }

    public final TableCellEditor getEditor(T value) {
        return this.myEditor;
    }

    public final Class<T> getColumnClass() {
        return ClassUtil.getRawType((Type)this.myChildDescription.getType());
    }

    public TableCellRenderer getCustomizedRenderer(T domElement, TableCellRenderer renderer) {
        assert (domElement.isValid());
        return this.getErrorableCellRenderer(renderer, domElement);
    }

    public DefaultTableCellRenderer getErrorableCellRenderer(TableCellRenderer renderer, T domElement) {
        return new ErrorableTableCellRenderer<GenericDomValue>(this.getGenericValue(domElement), renderer, (DomElement)domElement);
    }

    public void setValue(T o, String aValue) {
        this.getGenericValue(o).setStringValue(aValue);
    }

    protected final GenericDomValue getGenericValue(T o) {
        return (GenericDomValue)this.myChildDescription.getValues((DomElement)o).get(0);
    }

    public final String valueOf(T object) {
        if (!object.isValid()) {
            return null;
        }
        String stringValue = this.getGenericValue(object).getStringValue();
        return StringUtil.isEmpty((String)stringValue) ? this.getEmptyValuePresentation(object) : stringValue;
    }

    protected final DomFixedChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    protected String getEmptyValuePresentation(T object) {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/xml/ui/ChildGenericValueColumnInfo", "<init>"));
    }
}

