/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.util.xml.ui;

import javax.swing.JComponent;
import java.lang.reflect.InvocationTargetException;

public abstract class BaseModifiableControl<Bound extends JComponent, T> extends BaseControl<Bound,T> {
  private boolean myModified;

  protected BaseModifiableControl(final DomWrapper<T> domWrapper) {
    super(domWrapper);
  }

  protected final void setModified() {
    myModified = true;
  }

  @Override
  protected void doCommit(final T value) throws IllegalAccessException, InvocationTargetException {
    super.doCommit(value);
    myModified = false;
  }

  @Override
  protected boolean isCommitted() {
    return !myModified;
  }
}
