// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

// Generated by JFlex 1.9.1 http://jflex.de/  (tweaked for IntelliJ platform)
// source: _XmlLexer.flex

 /* It's an automatically generated code. Do not modify it. */
package com.intellij.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.*;
import com.intellij.psi.xml.*;


public class __XmlLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int TAG = 2;
  public static final int PROCESSING_INSTRUCTION = 4;
  public static final int PI_ANY = 6;
  public static final int END_TAG = 8;
  public static final int COMMENT = 10;
  public static final int ATTR_LIST = 12;
  public static final int ATTR = 14;
  public static final int ATTR_VALUE_START = 16;
  public static final int ATTR_VALUE_DQ = 18;
  public static final int ATTR_VALUE_SQ = 20;
  public static final int DTD_MARKUP = 22;
  public static final int DOCTYPE = 24;
  public static final int CDATA = 26;
  public static final int C_COMMENT_START = 28;
  public static final int C_COMMENT_END = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10,  8,  8, 11, 11, 12, 12, 13, 13, 14, 14
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\41\u1f00\1\u0100\1\u2f00\1\u3000\1\u0100\1\u3100\1\u3200"+
    "\1\u3300\1\u3400\1\u1f00\1\u3500\1\u3600\1\u3700\1\u3800\1\u0100"+
    "\1\u3900\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u1f00"+
    "\1\u4000\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700"+
    "\1\u4800\1\u4900\1\u4a00\1\u4b00\1\u1f00\1\u4c00\1\u4d00\1\u4e00"+
    "\1\u1f00\3\u0100\1\u4f00\1\u5000\1\u5100\12\u1f00\4\u0100\1\u5200"+
    "\17\u1f00\2\u0100\1\u5300\41\u1f00\2\u0100\1\u5400\1\u5500\2\u1f00"+
    "\1\u5600\1\u5700\27\u0100\1\u5800\2\u0100\1\u5900\45\u1f00\1\u0100"+
    "\1\u5a00\1\u5b00\11\u1f00\1\u5c00\27\u1f00\1\u5d00\1\u5e00\1\u5f00"+
    "\1\u6000\11\u1f00\1\u6100\1\u6200\5\u1f00\1\u6300\1\u6400\4\u1f00"+
    "\1\u6500\21\u1f00\246\u0100\1\u6600\20\u0100\1\u6700\1\u6800\25\u0100"+
    "\1\u6900\34\u0100\1\u6a00\14\u1f00\2\u0100\1\u6b00\u0e05\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\2\1\1\0\2\1\22\0\1\1\1\2\1\3"+
    "\1\4\1\5\1\6\1\7\1\10\2\11\3\0\1\12"+
    "\1\13\1\14\12\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\0\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\2\32\1\33\2\32\1\34\1\35\1\32\1\36\1\37"+
    "\2\32\1\40\1\41\1\42\3\32\1\43\1\32\1\44"+
    "\1\45\1\46\1\0\1\47\1\0\1\50\1\51\4\31"+
    "\1\52\4\32\1\53\1\54\1\55\1\56\1\57\1\60"+
    "\1\32\1\61\1\62\1\63\2\32\1\64\2\32\1\65"+
    "\1\11\1\66\7\0\1\67\44\0\1\32\12\0\1\32"+
    "\4\0\1\32\5\0\27\32\1\0\37\32\1\0\u01ca\32"+
    "\4\0\14\32\16\0\5\32\7\0\1\32\1\0\1\32"+
    "\201\0\5\32\1\0\2\32\2\0\4\32\1\0\1\32"+
    "\6\0\1\32\1\0\3\32\1\0\1\32\1\0\24\32"+
    "\1\0\123\32\1\0\213\32\10\0\246\32\1\0\46\32"+
    "\2\0\1\32\6\0\51\32\107\0\33\32\4\0\4\32"+
    "\55\0\53\32\43\0\2\32\1\0\143\32\1\0\1\32"+
    "\17\0\2\32\7\0\2\32\12\0\3\32\2\0\1\32"+
    "\20\0\1\32\1\0\36\32\35\0\131\32\13\0\1\32"+
    "\30\0\41\32\11\0\2\32\4\0\1\32\5\0\26\32"+
    "\4\0\1\32\11\0\1\32\3\0\1\32\27\0\31\32"+
    "\7\0\13\32\65\0\25\32\1\0\10\32\106\0\66\32"+
    "\3\0\1\32\22\0\1\32\7\0\12\32\17\0\20\32"+
    "\4\0\10\32\2\0\2\32\2\0\26\32\1\0\7\32"+
    "\1\0\1\32\3\0\4\32\3\0\1\32\20\0\1\32"+
    "\15\0\2\32\1\0\3\32\16\0\2\32\12\0\1\32"+
    "\10\0\6\32\4\0\2\32\2\0\26\32\1\0\7\32"+
    "\1\0\2\32\1\0\2\32\1\0\2\32\37\0\4\32"+
    "\1\0\1\32\23\0\3\32\20\0\11\32\1\0\3\32"+
    "\1\0\26\32\1\0\7\32\1\0\2\32\1\0\5\32"+
    "\3\0\1\32\22\0\1\32\17\0\2\32\27\0\1\32"+
    "\13\0\10\32\2\0\2\32\2\0\26\32\1\0\7\32"+
    "\1\0\2\32\1\0\5\32\3\0\1\32\36\0\2\32"+
    "\1\0\3\32\17\0\1\32\21\0\1\32\1\0\6\32"+
    "\3\0\3\32\1\0\4\32\3\0\2\32\1\0\1\32"+
    "\1\0\2\32\3\0\2\32\3\0\3\32\3\0\14\32"+
    "\26\0\1\32\64\0\10\32\1\0\3\32\1\0\27\32"+
    "\1\0\20\32\3\0\1\32\32\0\3\32\5\0\2\32"+
    "\36\0\1\32\4\0\10\32\1\0\3\32\1\0\27\32"+
    "\1\0\12\32\1\0\5\32\3\0\1\32\40\0\1\32"+
    "\1\0\2\32\17\0\2\32\22\0\10\32\1\0\3\32"+
    "\1\0\51\32\2\0\1\32\20\0\1\32\5\0\3\32"+
    "\10\0\3\32\30\0\6\32\5\0\22\32\3\0\30\32"+
    "\1\0\11\32\1\0\1\32\2\0\7\32\72\0\60\32"+
    "\1\0\2\32\14\0\7\32\72\0\2\32\1\0\1\32"+
    "\1\0\5\32\1\0\30\32\1\0\1\32\1\0\12\32"+
    "\1\0\2\32\11\0\1\32\2\0\5\32\1\0\1\32"+
    "\25\0\4\32\40\0\1\32\77\0\10\32\1\0\44\32"+
    "\33\0\5\32\163\0\53\32\24\0\1\32\20\0\6\32"+
    "\4\0\4\32\3\0\1\32\3\0\2\32\7\0\3\32"+
    "\4\0\15\32\14\0\1\32\21\0\46\32\1\0\1\32"+
    "\5\0\1\32\2\0\53\32\1\0\115\32\1\0\4\32"+
    "\2\0\7\32\1\0\1\32\1\0\4\32\2\0\51\32"+
    "\1\0\4\32\2\0\41\32\1\0\4\32\2\0\7\32"+
    "\1\0\1\32\1\0\4\32\2\0\17\32\1\0\71\32"+
    "\1\0\4\32\2\0\103\32\45\0\20\32\20\0\126\32"+
    "\2\0\6\32\3\0\u016c\32\2\0\21\32\1\0\32\32"+
    "\5\0\113\32\6\0\10\32\7\0\15\32\1\0\4\32"+
    "\16\0\22\32\16\0\22\32\16\0\15\32\1\0\3\32"+
    "\17\0\64\32\43\0\1\32\4\0\1\32\103\0\131\32"+
    "\7\0\5\32\2\0\42\32\1\0\1\32\5\0\106\32"+
    "\12\0\37\32\61\0\36\32\2\0\5\32\13\0\54\32"+
    "\4\0\32\32\66\0\27\32\11\0\65\32\122\0\1\32"+
    "\135\0\57\32\21\0\7\32\67\0\36\32\15\0\2\32"+
    "\12\0\54\32\32\0\44\32\51\0\3\32\12\0\44\32"+
    "\2\0\11\32\7\0\53\32\2\0\3\32\51\0\4\32"+
    "\1\0\6\32\1\0\2\32\3\0\1\32\5\0\300\32"+
    "\100\0\26\32\2\0\6\32\2\0\46\32\2\0\6\32"+
    "\2\0\10\32\1\0\1\32\1\0\1\32\1\0\1\32"+
    "\1\0\37\32\2\0\65\32\1\0\7\32\1\0\1\32"+
    "\3\0\3\32\1\0\7\32\3\0\4\32\2\0\6\32"+
    "\4\0\15\32\5\0\3\32\1\0\7\32\53\0\2\67"+
    "\107\0\1\32\15\0\1\32\20\0\15\32\145\0\1\32"+
    "\4\0\1\32\2\0\12\32\1\0\1\32\3\0\5\32"+
    "\6\0\1\32\1\0\1\32\1\0\1\32\1\0\4\32"+
    "\1\0\13\32\2\0\4\32\5\0\5\32\4\0\1\32"+
    "\64\0\2\32\u017b\0\57\32\1\0\57\32\1\0\205\32"+
    "\6\0\4\32\3\0\2\32\14\0\46\32\1\0\1\32"+
    "\5\0\1\32\2\0\70\32\7\0\1\32\20\0\27\32"+
    "\11\0\7\32\1\0\7\32\1\0\7\32\1\0\7\32"+
    "\1\0\7\32\1\0\7\32\1\0\7\32\1\0\7\32"+
    "\120\0\1\32\325\0\2\32\52\0\5\32\5\0\2\32"+
    "\4\0\126\32\6\0\3\32\1\0\132\32\1\0\4\32"+
    "\5\0\53\32\1\0\136\32\21\0\33\32\65\0\306\32"+
    "\112\0\360\32\20\0\215\32\103\0\56\32\2\0\15\32"+
    "\3\0\20\32\12\0\2\32\24\0\57\32\20\0\37\32"+
    "\2\0\106\32\61\0\11\32\2\0\147\32\2\0\65\32"+
    "\2\0\5\32\60\0\13\32\1\0\3\32\1\0\4\32"+
    "\1\0\27\32\35\0\64\32\16\0\62\32\76\0\6\32"+
    "\3\0\1\32\1\0\2\32\13\0\34\32\12\0\27\32"+
    "\31\0\35\32\7\0\57\32\34\0\1\32\20\0\5\32"+
    "\1\0\12\32\12\0\5\32\1\0\51\32\27\0\3\32"+
    "\1\0\10\32\24\0\27\32\3\0\1\32\3\0\62\32"+
    "\1\0\1\32\3\0\2\32\2\0\5\32\2\0\1\32"+
    "\1\0\1\32\30\0\3\32\2\0\13\32\7\0\3\32"+
    "\14\0\6\32\2\0\6\32\2\0\6\32\11\0\7\32"+
    "\1\0\7\32\1\0\53\32\1\0\14\32\10\0\163\32"+
    "\35\0\244\32\14\0\27\32\4\0\61\32\4\0\156\32"+
    "\2\0\152\32\46\0\7\32\14\0\5\32\5\0\1\32"+
    "\1\0\12\32\1\0\15\32\1\0\5\32\1\0\1\32"+
    "\1\0\2\32\1\0\2\32\1\0\154\32\41\0\153\32"+
    "\22\0\100\32\2\0\66\32\50\0\14\32\164\0\5\32"+
    "\1\0\207\32\44\0\32\32\6\0\32\32\13\0\131\32"+
    "\3\0\6\32\2\0\6\32\2\0\6\32\2\0\3\32"+
    "\43\0\14\32\1\0\32\32\1\0\23\32\1\0\2\32"+
    "\1\0\17\32\2\0\16\32\42\0\173\32\205\0\35\32"+
    "\3\0\61\32\57\0\40\32\15\0\24\32\1\0\10\32"+
    "\6\0\46\32\12\0\36\32\2\0\44\32\4\0\10\32"+
    "\60\0\236\32\22\0\44\32\4\0\44\32\4\0\50\32"+
    "\10\0\64\32\234\0\67\32\11\0\26\32\12\0\10\32"+
    "\230\0\6\32\2\0\1\32\1\0\54\32\1\0\2\32"+
    "\3\0\1\32\2\0\27\32\12\0\27\32\11\0\37\32"+
    "\101\0\23\32\1\0\2\32\12\0\26\32\12\0\32\32"+
    "\106\0\70\32\6\0\2\32\100\0\1\32\17\0\4\32"+
    "\1\0\3\32\1\0\35\32\52\0\35\32\3\0\35\32"+
    "\43\0\10\32\1\0\34\32\33\0\66\32\12\0\26\32"+
    "\12\0\23\32\15\0\22\32\156\0\111\32\67\0\63\32"+
    "\15\0\63\32\15\0\44\32\334\0\35\32\12\0\1\32"+
    "\10\0\26\32\232\0\27\32\14\0\65\32\113\0\55\32"+
    "\40\0\31\32\32\0\44\32\35\0\1\32\13\0\43\32"+
    "\3\0\1\32\14\0\60\32\16\0\4\32\25\0\1\32"+
    "\1\0\1\32\43\0\22\32\1\0\31\32\124\0\7\32"+
    "\1\0\1\32\1\0\4\32\1\0\17\32\1\0\12\32"+
    "\7\0\57\32\46\0\10\32\2\0\2\32\2\0\26\32"+
    "\1\0\7\32\1\0\2\32\1\0\5\32\3\0\1\32"+
    "\22\0\1\32\14\0\5\32\236\0\65\32\22\0\4\32"+
    "\24\0\1\32\40\0\60\32\24\0\2\32\1\0\1\32"+
    "\270\0\57\32\51\0\4\32\44\0\60\32\24\0\1\32"+
    "\73\0\53\32\15\0\1\32\107\0\33\32\345\0\54\32"+
    "\164\0\100\32\37\0\1\32\240\0\10\32\2\0\47\32"+
    "\20\0\1\32\1\0\1\32\34\0\1\32\12\0\50\32"+
    "\7\0\1\32\25\0\1\32\13\0\56\32\23\0\1\32"+
    "\42\0\71\32\7\0\11\32\1\0\45\32\21\0\1\32"+
    "\61\0\36\32\160\0\7\32\1\0\2\32\1\0\46\32"+
    "\25\0\1\32\31\0\6\32\1\0\2\32\1\0\40\32"+
    "\16\0\1\32\u0147\0\23\32\15\0\232\32\346\0\304\32"+
    "\274\0\57\32\321\0\107\32\271\0\71\32\7\0\37\32"+
    "\161\0\36\32\22\0\60\32\20\0\4\32\37\0\25\32"+
    "\5\0\23\32\260\0\100\32\200\0\113\32\5\0\1\32"+
    "\102\0\15\32\100\0\2\32\1\0\1\32\34\0\370\32"+
    "\10\0\363\32\15\0\37\32\61\0\3\32\21\0\4\32"+
    "\10\0\u018c\32\4\0\153\32\5\0\15\32\3\0\11\32"+
    "\7\0\12\32\146\0\125\32\1\0\107\32\1\0\2\32"+
    "\2\0\1\32\2\0\2\32\2\0\4\32\1\0\14\32"+
    "\1\0\1\32\1\0\7\32\1\0\101\32\1\0\4\32"+
    "\2\0\10\32\1\0\7\32\1\0\34\32\1\0\4\32"+
    "\1\0\5\32\1\0\1\32\3\0\7\32\1\0\u0154\32"+
    "\2\0\31\32\1\0\31\32\1\0\37\32\1\0\31\32"+
    "\1\0\37\32\1\0\31\32\1\0\37\32\1\0\31\32"+
    "\1\0\37\32\1\0\31\32\1\0\10\32\64\0\55\32"+
    "\12\0\7\32\20\0\1\32\u0171\0\54\32\24\0\305\32"+
    "\73\0\104\32\7\0\1\32\264\0\4\32\1\0\33\32"+
    "\1\0\2\32\1\0\1\32\2\0\1\32\1\0\12\32"+
    "\1\0\4\32\1\0\1\32\1\0\1\32\6\0\1\32"+
    "\4\0\1\32\1\0\1\32\1\0\1\32\1\0\3\32"+
    "\1\0\2\32\1\0\1\32\2\0\1\32\1\0\1\32"+
    "\1\0\1\32\1\0\1\32\1\0\1\32\1\0\2\32"+
    "\1\0\1\32\2\0\4\32\1\0\7\32\1\0\4\32"+
    "\1\0\4\32\1\0\1\32\1\0\12\32\1\0\21\32"+
    "\5\0\3\32\1\0\5\32\1\0\21\32\104\0\327\32"+
    "\51\0\65\32\13\0\336\32\2\0\u0182\32\16\0\u0131\32"+
    "\37\0\36\32\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27648];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\16\0\1\1\1\2\1\1\1\3\1\4\1\1"+
    "\1\2\1\3\1\5\1\3\1\6\1\3\1\7\1\10"+
    "\1\3\1\10\4\11\1\12\1\13\1\14\1\13\1\15"+
    "\1\16\1\17\1\20\1\17\1\21\1\17\1\22\1\17"+
    "\1\23\1\24\2\23\1\14\5\23\1\25\2\12\1\26"+
    "\2\1\4\27\1\13\1\27\1\30\1\31\7\0\1\32"+
    "\1\33\1\34\1\6\1\0\1\10\1\35\1\10\1\12"+
    "\2\0\1\16\1\36\1\0\1\36\1\0\2\12\1\0"+
    "\1\26\1\0\1\37\1\31\3\0\1\40\10\0\1\41"+
    "\1\42\1\43\1\36\1\44\2\12\1\45\1\46\2\0"+
    "\1\47\2\0\2\12\2\0\2\12\2\0\1\50\1\51"+
    "\4\0\1\52\1\53";

  private static int [] zzUnpackAction() {
    int [] result = new int[144];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\70\0\160\0\250\0\340\0\u0118\0\u0150\0\u0188"+
    "\0\u01c0\0\u01f8\0\u0230\0\u0268\0\u02a0\0\u02d8\0\u0310\0\u0348"+
    "\0\u0380\0\u03b8\0\u03f0\0\u0428\0\u0460\0\u0498\0\u04d0\0\u0508"+
    "\0\u0540\0\u0578\0\u05b0\0\u04d0\0\u05e8\0\u0620\0\u0658\0\u04d0"+
    "\0\u03f0\0\u05b0\0\u0620\0\u0690\0\u04d0\0\u06c8\0\u0700\0\u04d0"+
    "\0\u0738\0\u04d0\0\u04d0\0\u03f0\0\u04d0\0\u05b0\0\u04d0\0\u0508"+
    "\0\u04d0\0\u04d0\0\u0770\0\u07a8\0\u03f0\0\u05b0\0\u07e0\0\u0818"+
    "\0\u0850\0\u0888\0\u04d0\0\u08c0\0\u08f8\0\u0930\0\u04d0\0\u0968"+
    "\0\u04d0\0\u03f0\0\u09a0\0\u05b0\0\u09d8\0\u0a10\0\u04d0\0\u0a48"+
    "\0\u0a80\0\u0ab8\0\u0af0\0\u0b28\0\u0b60\0\u0b98\0\u0bd0\0\u04d0"+
    "\0\u04d0\0\u04d0\0\u0c08\0\u0c40\0\u0c78\0\u04d0\0\u0cb0\0\u0ce8"+
    "\0\u0d20\0\u0d58\0\u0d90\0\u0dc8\0\u0e00\0\u0e38\0\u0e70\0\u0ea8"+
    "\0\u0ee0\0\u0f18\0\u04d0\0\u0f50\0\u04d0\0\u04d0\0\u0f88\0\u0fc0"+
    "\0\u0ff8\0\u04d0\0\u1030\0\u1068\0\u10a0\0\u10d8\0\u1110\0\u1148"+
    "\0\u1180\0\u11b8\0\u05e8\0\u04d0\0\u04d0\0\u04d0\0\u04d0\0\u11f0"+
    "\0\u1228\0\u04d0\0\u04d0\0\u1260\0\u1298\0\u04d0\0\u12d0\0\u1308"+
    "\0\u1340\0\u1378\0\u13b0\0\u13e8\0\u1420\0\u1458\0\u1490\0\u14c8"+
    "\0\u0690\0\u0690\0\u1500\0\u1538\0\u1570\0\u15a8\0\u04d0\0\u04d0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[144];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\20\1\21\2\20\2\22\1\20\1\23\10\20\1\24"+
    "\24\20\1\25\21\20\1\26\1\27\1\30\5\27\1\23"+
    "\4\27\1\31\1\27\1\32\1\27\1\33\1\27\1\34"+
    "\1\27\20\32\3\27\16\32\2\27\1\30\7\27\1\23"+
    "\6\27\1\35\1\27\1\33\2\27\1\36\20\35\3\27"+
    "\15\35\1\37\3\27\1\40\1\30\5\40\1\41\10\40"+
    "\1\42\2\40\1\43\43\40\1\30\1\27\1\30\5\27"+
    "\1\23\6\27\1\44\1\27\1\33\1\27\1\34\1\27"+
    "\20\44\3\27\16\44\2\27\1\30\12\45\1\46\5\45"+
    "\1\47\23\45\1\50\23\45\1\27\1\30\5\27\1\23"+
    "\6\27\1\51\1\27\1\33\3\27\20\51\3\27\16\51"+
    "\2\27\1\30\1\52\1\30\1\52\1\53\3\52\1\54"+
    "\1\55\7\52\1\56\1\57\45\52\1\60\7\27\1\23"+
    "\10\27\1\33\47\27\3\61\1\62\2\63\1\64\1\65"+
    "\10\61\1\66\53\61\2\67\1\70\1\65\1\62\7\61"+
    "\1\66\47\61\1\27\1\30\1\27\1\71\3\27\1\23"+
    "\1\72\5\27\1\44\1\27\1\33\1\27\1\73\1\27"+
    "\13\44\1\74\1\75\3\44\1\76\2\27\16\44\2\27"+
    "\1\30\46\77\1\100\21\77\7\101\1\102\2\101\1\103"+
    "\5\101\1\104\3\101\20\105\2\101\1\106\1\101\15\105"+
    "\12\101\1\102\2\101\1\103\5\101\1\104\3\101\20\105"+
    "\2\101\1\107\1\101\15\105\3\101\1\20\1\0\2\20"+
    "\2\0\1\20\1\0\10\20\1\0\24\20\1\25\22\20"+
    "\1\0\1\21\65\0\1\21\65\0\1\110\6\0\1\111"+
    "\11\0\1\112\5\0\20\112\3\0\1\112\1\113\1\112"+
    "\2\114\1\112\1\115\2\112\1\116\4\112\5\0\1\117"+
    "\11\0\1\120\6\0\1\121\44\0\1\20\1\0\5\20"+
    "\1\0\10\20\1\0\24\20\1\25\23\20\1\21\2\20"+
    "\2\0\1\20\1\0\10\20\1\0\24\20\1\25\21\20"+
    "\1\26\71\0\1\30\65\0\1\30\22\0\1\122\57\0"+
    "\2\32\1\0\1\32\1\123\5\0\20\32\3\0\16\32"+
    "\5\0\1\124\77\0\2\35\1\0\1\35\1\125\5\0"+
    "\20\35\3\0\16\35\25\0\1\126\57\0\2\35\1\0"+
    "\1\35\1\125\5\0\20\35\3\0\5\35\1\127\10\35"+
    "\15\0\2\44\1\0\1\44\1\130\5\0\20\44\3\0"+
    "\16\44\3\0\12\45\1\131\55\45\2\0\1\132\77\0"+
    "\2\51\1\0\1\51\1\133\5\0\20\51\3\0\16\51"+
    "\70\0\1\134\23\0\1\135\133\0\1\136\23\0\1\137"+
    "\46\0\3\71\1\61\64\71\10\72\1\61\57\72\12\0"+
    "\2\44\1\0\1\44\1\130\5\0\16\44\1\140\1\44"+
    "\3\0\16\44\15\0\2\44\1\0\1\44\1\130\5\0"+
    "\17\44\1\141\3\0\16\44\3\0\3\76\1\142\42\76"+
    "\1\143\21\76\46\0\1\144\33\0\1\131\56\0\2\105"+
    "\4\0\1\105\1\0\1\105\1\0\1\105\1\0\1\105"+
    "\6\0\20\105\4\0\15\105\2\0\1\105\22\0\1\145"+
    "\45\0\20\110\1\0\45\110\1\146\1\110\15\0\1\147"+
    "\46\0\1\150\15\0\2\112\1\0\1\112\1\151\1\152"+
    "\4\0\20\112\3\0\16\112\15\0\2\112\1\0\1\112"+
    "\1\151\1\152\4\0\20\112\3\0\5\112\1\153\2\112"+
    "\1\154\5\112\15\0\2\112\1\0\1\112\1\151\1\152"+
    "\4\0\20\112\3\0\13\112\1\155\2\112\15\0\2\112"+
    "\1\0\1\112\1\151\1\152\4\0\20\112\3\0\2\112"+
    "\1\156\13\112\15\0\2\112\1\0\1\112\1\151\1\152"+
    "\4\0\20\112\3\0\14\112\1\157\1\112\15\0\1\160"+
    "\14\0\1\161\14\0\1\162\35\0\2\123\1\0\1\123"+
    "\6\0\20\123\3\0\16\123\15\0\1\160\31\0\1\162"+
    "\35\0\2\125\1\0\1\125\6\0\20\125\3\0\16\125"+
    "\15\0\2\35\1\0\1\35\1\125\5\0\20\35\3\0"+
    "\4\35\1\163\11\35\15\0\2\130\1\0\1\130\6\0"+
    "\20\130\3\0\16\130\25\0\1\164\111\0\1\165\35\0"+
    "\2\133\1\0\1\133\6\0\20\133\3\0\16\133\3\0"+
    "\3\134\1\0\62\134\1\166\1\134\3\135\1\0\2\135"+
    "\1\167\61\135\10\136\1\0\55\136\1\166\1\136\6\137"+
    "\1\167\1\137\1\0\57\137\12\0\2\44\1\0\1\44"+
    "\1\130\5\0\1\44\1\170\16\44\3\0\16\44\15\0"+
    "\2\44\1\0\1\44\1\130\5\0\14\44\1\171\3\44"+
    "\3\0\16\44\3\0\3\142\1\76\64\142\22\0\1\172"+
    "\62\0\1\147\1\0\1\173\65\0\1\174\6\0\6\174"+
    "\16\0\2\174\30\0\2\151\1\0\1\151\1\0\1\152"+
    "\4\0\20\151\3\0\16\151\15\0\2\112\1\0\1\112"+
    "\1\151\1\152\4\0\20\112\3\0\10\112\1\155\5\112"+
    "\15\0\2\112\1\0\1\112\1\151\1\152\4\0\20\112"+
    "\3\0\7\112\1\175\6\112\15\0\2\112\1\0\1\112"+
    "\1\151\1\173\4\0\20\112\3\0\16\112\15\0\2\112"+
    "\1\0\1\112\1\151\1\152\4\0\20\112\3\0\12\112"+
    "\1\153\3\112\15\0\2\112\1\0\1\112\1\151\1\152"+
    "\4\0\20\112\3\0\7\112\1\114\6\112\15\0\1\176"+
    "\113\0\1\177\57\0\1\200\53\0\2\44\1\0\1\44"+
    "\1\130\5\0\10\44\1\201\7\44\3\0\16\44\15\0"+
    "\2\44\1\0\1\44\1\130\5\0\15\44\1\202\2\44"+
    "\3\0\16\44\20\0\1\174\1\0\1\173\4\0\6\174"+
    "\16\0\2\174\30\0\2\112\1\0\1\112\1\151\1\152"+
    "\4\0\20\112\3\0\12\112\1\155\3\112\31\0\1\203"+
    "\70\0\1\204\52\0\2\44\1\0\1\44\1\130\5\0"+
    "\7\44\1\205\10\44\3\0\16\44\15\0\2\44\1\0"+
    "\1\44\1\130\5\0\4\44\1\206\13\44\3\0\16\44"+
    "\44\0\1\207\52\0\1\210\55\0\2\44\1\0\1\44"+
    "\1\130\5\0\2\44\1\211\15\44\3\0\16\44\15\0"+
    "\2\44\1\0\1\44\1\130\5\0\11\44\1\212\6\44"+
    "\3\0\16\44\46\0\1\213\65\0\1\214\65\0\1\215"+
    "\54\0\1\216\73\0\1\217\103\0\1\220\23\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[5600];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\16\0\7\1\1\11\4\1\1\11\3\1\1\11"+
    "\4\1\1\11\2\1\1\11\1\1\2\11\1\1\1\11"+
    "\1\1\1\11\1\1\2\11\10\1\1\11\3\1\1\11"+
    "\1\1\1\11\5\1\1\11\1\1\7\0\3\11\1\1"+
    "\1\0\1\1\1\11\2\1\2\0\2\1\1\0\1\1"+
    "\1\0\2\1\1\0\1\11\1\0\2\11\3\0\1\11"+
    "\10\0\1\1\4\11\2\1\2\11\2\0\1\11\2\0"+
    "\2\1\2\0\2\1\2\0\2\1\4\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[144];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  private IElementType elTokenType = XmlTokenType.XML_DATA_CHARACTERS;
  private IElementType elTokenType2 = XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
  private IElementType javaEmbeddedTokenType = XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
  private boolean myConditionalCommentsSupport;

  public void setConditionalCommentsSupport(final boolean b) {
    myConditionalCommentsSupport = b;
  }

  public void setElTypes(IElementType _elTokenType,IElementType _elTokenType2) {
    elTokenType = _elTokenType;
    elTokenType2 = _elTokenType2;
  }

  public void setJavaEmbeddedType(IElementType _tokenType) {
    javaEmbeddedTokenType = _tokenType;
  }

  private int myPrevState = YYINITIAL;

  public int yyprevstate() {
    return myPrevState;
  }

  private int popState(){
    final int prev = myPrevState;
    myPrevState = YYINITIAL;
    return prev;
  }

  protected void pushState(int state){
    myPrevState = state;
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public __XmlLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return XmlTokenType.XML_DATA_CHARACTERS;
            }
          // fall through
          case 44: break;
          case 2:
            { return XmlTokenType.XML_REAL_WHITE_SPACE;
            }
          // fall through
          case 45: break;
          case 3:
            { if(yystate() == YYINITIAL){
        return XmlTokenType.XML_BAD_CHARACTER;
      }
      else yybegin(popState()); yypushback(yylength());
            }
          // fall through
          case 46: break;
          case 4:
            { yybegin(TAG); return XmlTokenType.XML_START_TAG_START;
            }
          // fall through
          case 47: break;
          case 5:
            { return XmlTokenType.XML_WHITE_SPACE;
            }
          // fall through
          case 48: break;
          case 6:
            { yybegin(ATTR_LIST); pushState(TAG); return XmlTokenType.XML_NAME;
            }
          // fall through
          case 49: break;
          case 7:
            { yybegin(YYINITIAL); return XmlTokenType.XML_TAG_END;
            }
          // fall through
          case 50: break;
          case 8:
            { yybegin(PI_ANY); return XmlTokenType.XML_NAME;
            }
          // fall through
          case 51: break;
          case 9:
            { return XmlTokenType.XML_TAG_CHARACTERS;
            }
          // fall through
          case 52: break;
          case 10:
            { return XmlTokenType.XML_NAME;
            }
          // fall through
          case 53: break;
          case 11:
            { return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 54: break;
          case 12:
            { return XmlTokenType.XML_BAD_CHARACTER;
            }
          // fall through
          case 55: break;
          case 13:
            { if (myConditionalCommentsSupport) {
    yybegin(C_COMMENT_START);
    return XmlTokenType.XML_CONDITIONAL_COMMENT_START;
  } else return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 56: break;
          case 14:
            { yybegin(ATTR); return XmlTokenType.XML_NAME;
            }
          // fall through
          case 57: break;
          case 15:
            { yybegin(ATTR_LIST); yypushback(yylength());
            }
          // fall through
          case 58: break;
          case 16:
            { yybegin(ATTR_VALUE_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 59: break;
          case 17:
            { yybegin(ATTR_VALUE_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 60: break;
          case 18:
            { return XmlTokenType.XML_EQ;
            }
          // fall through
          case 61: break;
          case 19:
            { return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            }
          // fall through
          case 62: break;
          case 20:
            { yybegin(ATTR_LIST); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            }
          // fall through
          case 63: break;
          case 21:
            { yybegin(YYINITIAL); return XmlTokenType.XML_DOCTYPE_END;
            }
          // fall through
          case 64: break;
          case 22:
            { return XmlElementType.XML_MARKUP_DECL;
            }
          // fall through
          case 65: break;
          case 23:
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 66: break;
          case 24:
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_END;
            }
          // fall through
          case 67: break;
          case 25:
            { return elTokenType;
            }
          // fall through
          case 68: break;
          case 26:
            { yybegin(END_TAG); return XmlTokenType.XML_END_TAG_START;
            }
          // fall through
          case 69: break;
          case 27:
            { yybegin(PROCESSING_INSTRUCTION); return XmlTokenType.XML_PI_START;
            }
          // fall through
          case 70: break;
          case 28:
            { yybegin(YYINITIAL); return XmlTokenType.XML_EMPTY_ELEMENT_END;
            }
          // fall through
          case 71: break;
          case 29:
            { yybegin(YYINITIAL); return XmlTokenType.XML_PI_END;
            }
          // fall through
          case 72: break;
          case 30:
            { return elTokenType2;
            }
          // fall through
          case 73: break;
          case 31:
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_START_END;
            }
          // fall through
          case 74: break;
          case 32:
            { return XmlTokenType.XML_ENTITY_REF_TOKEN;
            }
          // fall through
          case 75: break;
          case 33:
            { yybegin(ATTR_LIST); pushState(PROCESSING_INSTRUCTION); return XmlTokenType.XML_NAME;
            }
          // fall through
          case 76: break;
          case 34:
            { yybegin(YYINITIAL); return XmlTokenType.XML_COMMENT_END;
            }
          // fall through
          case 77: break;
          case 35:
            { if (myConditionalCommentsSupport) {
    yybegin(C_COMMENT_END);
    return XmlTokenType.XML_CONDITIONAL_COMMENT_END_START;
  } else return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 78: break;
          case 36:
            { return javaEmbeddedTokenType;
            }
          // fall through
          case 79: break;
          case 37:
            { yybegin(YYINITIAL); return XmlTokenType.XML_CDATA_END;
            }
          // fall through
          case 80: break;
          case 38:
            { return XmlTokenType.XML_CHAR_ENTITY_REF;
            }
          // fall through
          case 81: break;
          case 39:
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_START;
            }
          // fall through
          case 82: break;
          case 40:
            { return XmlTokenType.XML_DOCTYPE_PUBLIC;
            }
          // fall through
          case 83: break;
          case 41:
            { return XmlTokenType.XML_DOCTYPE_SYSTEM;
            }
          // fall through
          case 84: break;
          case 42:
            { yybegin(DOCTYPE); return XmlTokenType.XML_DOCTYPE_START;
            }
          // fall through
          case 85: break;
          case 43:
            { yybegin(CDATA); return XmlTokenType.XML_CDATA_START;
            }
          // fall through
          case 86: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
