// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

// Generated by JFlex 1.9.1 http://jflex.de/  (tweaked for IntelliJ platform)
// source: _HtmlLexer.flex

/* It's an automatically generated code. Do not modify it. */
package com.intellij.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.*;
import com.intellij.psi.xml.*;


public class _HtmlLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int DOC_TYPE = 2;
  public static final int COMMENT = 4;
  public static final int START_TAG_NAME = 6;
  public static final int END_TAG_NAME = 8;
  public static final int BEFORE_TAG_ATTRIBUTES = 10;
  public static final int TAG_ATTRIBUTES = 12;
  public static final int ATTRIBUTE_VALUE_START = 14;
  public static final int ATTRIBUTE_VALUE_DQ = 16;
  public static final int ATTRIBUTE_VALUE_SQ = 18;
  public static final int PROCESSING_INSTRUCTION = 20;
  public static final int TAG_CHARACTERS = 22;
  public static final int C_COMMENT_START = 24;
  public static final int C_COMMENT_END = 26;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\41\u1f00\1\u0100\1\u2f00\1\u3000\1\u0100\1\u3100\1\u3200"+
    "\1\u3300\1\u3400\1\u1f00\1\u3500\1\u3600\1\u3700\1\u3800\1\u0100"+
    "\1\u3900\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u1f00"+
    "\1\u4000\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700"+
    "\1\u4800\1\u4900\1\u4a00\1\u4b00\1\u1f00\1\u4c00\1\u4d00\1\u4e00"+
    "\1\u1f00\3\u0100\1\u4f00\1\u5000\1\u5100\12\u1f00\4\u0100\1\u5200"+
    "\17\u1f00\2\u0100\1\u5300\41\u1f00\2\u0100\1\u5400\1\u5500\2\u1f00"+
    "\1\u5600\1\u5700\27\u0100\1\u5800\2\u0100\1\u5900\45\u1f00\1\u0100"+
    "\1\u5a00\1\u5b00\11\u1f00\1\u5c00\27\u1f00\1\u5d00\1\u5e00\1\u5f00"+
    "\1\u6000\11\u1f00\1\u6100\1\u6200\5\u1f00\1\u6300\1\u6400\4\u1f00"+
    "\1\u6500\21\u1f00\246\u0100\1\u6600\20\u0100\1\u6700\1\u6800\25\u0100"+
    "\1\u6900\34\u0100\1\u6a00\14\u1f00\2\u0100\1\u6b00\u0e05\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\2\1\1\0\2\1\22\0\1\1\1\2\1\3"+
    "\1\4\1\5\1\0\1\6\1\7\2\10\3\0\1\11"+
    "\1\12\1\13\12\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\0\1\23\1\24\1\25\1\26\1\27\1\23"+
    "\1\30\1\31\1\32\2\30\1\33\1\34\1\30\1\35"+
    "\1\36\3\30\1\37\1\40\2\30\1\41\1\42\1\30"+
    "\1\43\1\44\1\45\1\0\1\15\1\0\1\46\1\47"+
    "\1\25\1\26\1\27\1\23\1\50\1\31\1\32\2\30"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\1\30\1\57"+
    "\1\60\1\61\2\30\1\41\1\42\1\30\1\0\1\10"+
    "\10\0\1\62\44\0\1\30\12\0\1\30\4\0\1\30"+
    "\5\0\27\30\1\0\37\30\1\0\u01ca\30\4\0\14\30"+
    "\16\0\5\30\7\0\1\30\1\0\1\30\201\0\5\30"+
    "\1\0\2\30\2\0\4\30\1\0\1\30\6\0\1\30"+
    "\1\0\3\30\1\0\1\30\1\0\24\30\1\0\123\30"+
    "\1\0\213\30\10\0\246\30\1\0\46\30\2\0\1\30"+
    "\6\0\51\30\107\0\33\30\4\0\4\30\55\0\53\30"+
    "\43\0\2\30\1\0\143\30\1\0\1\30\17\0\2\30"+
    "\7\0\2\30\12\0\3\30\2\0\1\30\20\0\1\30"+
    "\1\0\36\30\35\0\131\30\13\0\1\30\30\0\41\30"+
    "\11\0\2\30\4\0\1\30\5\0\26\30\4\0\1\30"+
    "\11\0\1\30\3\0\1\30\27\0\31\30\7\0\13\30"+
    "\65\0\25\30\1\0\10\30\106\0\66\30\3\0\1\30"+
    "\22\0\1\30\7\0\12\30\17\0\20\30\4\0\10\30"+
    "\2\0\2\30\2\0\26\30\1\0\7\30\1\0\1\30"+
    "\3\0\4\30\3\0\1\30\20\0\1\30\15\0\2\30"+
    "\1\0\3\30\16\0\2\30\12\0\1\30\10\0\6\30"+
    "\4\0\2\30\2\0\26\30\1\0\7\30\1\0\2\30"+
    "\1\0\2\30\1\0\2\30\37\0\4\30\1\0\1\30"+
    "\23\0\3\30\20\0\11\30\1\0\3\30\1\0\26\30"+
    "\1\0\7\30\1\0\2\30\1\0\5\30\3\0\1\30"+
    "\22\0\1\30\17\0\2\30\27\0\1\30\13\0\10\30"+
    "\2\0\2\30\2\0\26\30\1\0\7\30\1\0\2\30"+
    "\1\0\5\30\3\0\1\30\36\0\2\30\1\0\3\30"+
    "\17\0\1\30\21\0\1\30\1\0\6\30\3\0\3\30"+
    "\1\0\4\30\3\0\2\30\1\0\1\30\1\0\2\30"+
    "\3\0\2\30\3\0\3\30\3\0\14\30\26\0\1\30"+
    "\64\0\10\30\1\0\3\30\1\0\27\30\1\0\20\30"+
    "\3\0\1\30\32\0\3\30\5\0\2\30\36\0\1\30"+
    "\4\0\10\30\1\0\3\30\1\0\27\30\1\0\12\30"+
    "\1\0\5\30\3\0\1\30\40\0\1\30\1\0\2\30"+
    "\17\0\2\30\22\0\10\30\1\0\3\30\1\0\51\30"+
    "\2\0\1\30\20\0\1\30\5\0\3\30\10\0\3\30"+
    "\30\0\6\30\5\0\22\30\3\0\30\30\1\0\11\30"+
    "\1\0\1\30\2\0\7\30\72\0\60\30\1\0\2\30"+
    "\14\0\7\30\72\0\2\30\1\0\1\30\1\0\5\30"+
    "\1\0\30\30\1\0\1\30\1\0\12\30\1\0\2\30"+
    "\11\0\1\30\2\0\5\30\1\0\1\30\25\0\4\30"+
    "\40\0\1\30\77\0\10\30\1\0\44\30\33\0\5\30"+
    "\163\0\53\30\24\0\1\30\20\0\6\30\4\0\4\30"+
    "\3\0\1\30\3\0\2\30\7\0\3\30\4\0\15\30"+
    "\14\0\1\30\21\0\46\30\1\0\1\30\5\0\1\30"+
    "\2\0\53\30\1\0\115\30\1\0\4\30\2\0\7\30"+
    "\1\0\1\30\1\0\4\30\2\0\51\30\1\0\4\30"+
    "\2\0\41\30\1\0\4\30\2\0\7\30\1\0\1\30"+
    "\1\0\4\30\2\0\17\30\1\0\71\30\1\0\4\30"+
    "\2\0\103\30\45\0\20\30\20\0\126\30\2\0\6\30"+
    "\3\0\u016c\30\2\0\21\30\1\0\32\30\5\0\113\30"+
    "\6\0\10\30\7\0\15\30\1\0\4\30\16\0\22\30"+
    "\16\0\22\30\16\0\15\30\1\0\3\30\17\0\64\30"+
    "\43\0\1\30\4\0\1\30\103\0\131\30\7\0\5\30"+
    "\2\0\42\30\1\0\1\30\5\0\106\30\12\0\37\30"+
    "\61\0\36\30\2\0\5\30\13\0\54\30\4\0\32\30"+
    "\66\0\27\30\11\0\65\30\122\0\1\30\135\0\57\30"+
    "\21\0\7\30\67\0\36\30\15\0\2\30\12\0\54\30"+
    "\32\0\44\30\51\0\3\30\12\0\44\30\2\0\11\30"+
    "\7\0\53\30\2\0\3\30\51\0\4\30\1\0\6\30"+
    "\1\0\2\30\3\0\1\30\5\0\300\30\100\0\26\30"+
    "\2\0\6\30\2\0\46\30\2\0\6\30\2\0\10\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\1\0\37\30"+
    "\2\0\65\30\1\0\7\30\1\0\1\30\3\0\3\30"+
    "\1\0\7\30\3\0\4\30\2\0\6\30\4\0\15\30"+
    "\5\0\3\30\1\0\7\30\53\0\2\62\107\0\1\30"+
    "\15\0\1\30\20\0\15\30\145\0\1\30\4\0\1\30"+
    "\2\0\12\30\1\0\1\30\3\0\5\30\6\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\4\30\1\0\13\30"+
    "\2\0\4\30\5\0\5\30\4\0\1\30\64\0\2\30"+
    "\u017b\0\57\30\1\0\57\30\1\0\205\30\6\0\4\30"+
    "\3\0\2\30\14\0\46\30\1\0\1\30\5\0\1\30"+
    "\2\0\70\30\7\0\1\30\20\0\27\30\11\0\7\30"+
    "\1\0\7\30\1\0\7\30\1\0\7\30\1\0\7\30"+
    "\1\0\7\30\1\0\7\30\1\0\7\30\120\0\1\30"+
    "\325\0\2\30\52\0\5\30\5\0\2\30\4\0\126\30"+
    "\6\0\3\30\1\0\132\30\1\0\4\30\5\0\53\30"+
    "\1\0\136\30\21\0\33\30\65\0\306\30\112\0\360\30"+
    "\20\0\215\30\103\0\56\30\2\0\15\30\3\0\20\30"+
    "\12\0\2\30\24\0\57\30\20\0\37\30\2\0\106\30"+
    "\61\0\11\30\2\0\147\30\2\0\65\30\2\0\5\30"+
    "\60\0\13\30\1\0\3\30\1\0\4\30\1\0\27\30"+
    "\35\0\64\30\16\0\62\30\76\0\6\30\3\0\1\30"+
    "\1\0\2\30\13\0\34\30\12\0\27\30\31\0\35\30"+
    "\7\0\57\30\34\0\1\30\20\0\5\30\1\0\12\30"+
    "\12\0\5\30\1\0\51\30\27\0\3\30\1\0\10\30"+
    "\24\0\27\30\3\0\1\30\3\0\62\30\1\0\1\30"+
    "\3\0\2\30\2\0\5\30\2\0\1\30\1\0\1\30"+
    "\30\0\3\30\2\0\13\30\7\0\3\30\14\0\6\30"+
    "\2\0\6\30\2\0\6\30\11\0\7\30\1\0\7\30"+
    "\1\0\53\30\1\0\14\30\10\0\163\30\35\0\244\30"+
    "\14\0\27\30\4\0\61\30\4\0\156\30\2\0\152\30"+
    "\46\0\7\30\14\0\5\30\5\0\1\30\1\0\12\30"+
    "\1\0\15\30\1\0\5\30\1\0\1\30\1\0\2\30"+
    "\1\0\2\30\1\0\154\30\41\0\153\30\22\0\100\30"+
    "\2\0\66\30\50\0\14\30\164\0\5\30\1\0\207\30"+
    "\44\0\32\30\6\0\32\30\13\0\131\30\3\0\6\30"+
    "\2\0\6\30\2\0\6\30\2\0\3\30\43\0\14\30"+
    "\1\0\32\30\1\0\23\30\1\0\2\30\1\0\17\30"+
    "\2\0\16\30\42\0\173\30\205\0\35\30\3\0\61\30"+
    "\57\0\40\30\15\0\24\30\1\0\10\30\6\0\46\30"+
    "\12\0\36\30\2\0\44\30\4\0\10\30\60\0\236\30"+
    "\22\0\44\30\4\0\44\30\4\0\50\30\10\0\64\30"+
    "\234\0\67\30\11\0\26\30\12\0\10\30\230\0\6\30"+
    "\2\0\1\30\1\0\54\30\1\0\2\30\3\0\1\30"+
    "\2\0\27\30\12\0\27\30\11\0\37\30\101\0\23\30"+
    "\1\0\2\30\12\0\26\30\12\0\32\30\106\0\70\30"+
    "\6\0\2\30\100\0\1\30\17\0\4\30\1\0\3\30"+
    "\1\0\35\30\52\0\35\30\3\0\35\30\43\0\10\30"+
    "\1\0\34\30\33\0\66\30\12\0\26\30\12\0\23\30"+
    "\15\0\22\30\156\0\111\30\67\0\63\30\15\0\63\30"+
    "\15\0\44\30\334\0\35\30\12\0\1\30\10\0\26\30"+
    "\232\0\27\30\14\0\65\30\113\0\55\30\40\0\31\30"+
    "\32\0\44\30\35\0\1\30\13\0\43\30\3\0\1\30"+
    "\14\0\60\30\16\0\4\30\25\0\1\30\1\0\1\30"+
    "\43\0\22\30\1\0\31\30\124\0\7\30\1\0\1\30"+
    "\1\0\4\30\1\0\17\30\1\0\12\30\7\0\57\30"+
    "\46\0\10\30\2\0\2\30\2\0\26\30\1\0\7\30"+
    "\1\0\2\30\1\0\5\30\3\0\1\30\22\0\1\30"+
    "\14\0\5\30\236\0\65\30\22\0\4\30\24\0\1\30"+
    "\40\0\60\30\24\0\2\30\1\0\1\30\270\0\57\30"+
    "\51\0\4\30\44\0\60\30\24\0\1\30\73\0\53\30"+
    "\15\0\1\30\107\0\33\30\345\0\54\30\164\0\100\30"+
    "\37\0\1\30\240\0\10\30\2\0\47\30\20\0\1\30"+
    "\1\0\1\30\34\0\1\30\12\0\50\30\7\0\1\30"+
    "\25\0\1\30\13\0\56\30\23\0\1\30\42\0\71\30"+
    "\7\0\11\30\1\0\45\30\21\0\1\30\61\0\36\30"+
    "\160\0\7\30\1\0\2\30\1\0\46\30\25\0\1\30"+
    "\31\0\6\30\1\0\2\30\1\0\40\30\16\0\1\30"+
    "\u0147\0\23\30\15\0\232\30\346\0\304\30\274\0\57\30"+
    "\321\0\107\30\271\0\71\30\7\0\37\30\161\0\36\30"+
    "\22\0\60\30\20\0\4\30\37\0\25\30\5\0\23\30"+
    "\260\0\100\30\200\0\113\30\5\0\1\30\102\0\15\30"+
    "\100\0\2\30\1\0\1\30\34\0\370\30\10\0\363\30"+
    "\15\0\37\30\61\0\3\30\21\0\4\30\10\0\u018c\30"+
    "\4\0\153\30\5\0\15\30\3\0\11\30\7\0\12\30"+
    "\146\0\125\30\1\0\107\30\1\0\2\30\2\0\1\30"+
    "\2\0\2\30\2\0\4\30\1\0\14\30\1\0\1\30"+
    "\1\0\7\30\1\0\101\30\1\0\4\30\2\0\10\30"+
    "\1\0\7\30\1\0\34\30\1\0\4\30\1\0\5\30"+
    "\1\0\1\30\3\0\7\30\1\0\u0154\30\2\0\31\30"+
    "\1\0\31\30\1\0\37\30\1\0\31\30\1\0\37\30"+
    "\1\0\31\30\1\0\37\30\1\0\31\30\1\0\37\30"+
    "\1\0\31\30\1\0\10\30\64\0\55\30\12\0\7\30"+
    "\20\0\1\30\u0171\0\54\30\24\0\305\30\73\0\104\30"+
    "\7\0\1\30\264\0\4\30\1\0\33\30\1\0\2\30"+
    "\1\0\1\30\2\0\1\30\1\0\12\30\1\0\4\30"+
    "\1\0\1\30\1\0\1\30\6\0\1\30\4\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\3\30\1\0\2\30"+
    "\1\0\1\30\2\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\2\30\1\0\1\30"+
    "\2\0\4\30\1\0\7\30\1\0\4\30\1\0\4\30"+
    "\1\0\1\30\1\0\12\30\1\0\21\30\5\0\3\30"+
    "\1\0\5\30\1\0\21\30\104\0\327\30\51\0\65\30"+
    "\13\0\336\30\2\0\u0182\30\16\0\u0131\30\37\0\36\30"+
    "\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27648];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\11\0\1\2\3\0\1\1\1\3\4\1\1\3"+
    "\1\4\1\5\3\4\1\6\2\4\4\7\1\10\1\11"+
    "\2\12\1\13\1\14\1\12\1\15\1\12\1\16\1\17"+
    "\1\20\1\5\1\21\1\22\1\23\1\21\1\5\1\24"+
    "\1\25\2\24\1\2\1\26\1\4\3\27\3\30\1\7"+
    "\1\30\1\31\7\0\1\32\1\33\1\34\6\0\1\32"+
    "\1\35\1\21\2\0\1\36\2\0\1\37\7\0\1\40"+
    "\3\0\1\41\1\0\1\42\1\43\2\0\1\44\1\0"+
    "\1\17\1\0\1\45\1\4\3\0\1\46\2\0\1\47";

  private static int [] zzUnpackAction() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\377\0\u0132\0\u0165"+
    "\0\u0198\0\u01cb\0\u01fe\0\u0231\0\u0264\0\u0297\0\u02ca\0\u02fd"+
    "\0\u0330\0\u0363\0\u0396\0\u03c9\0\u03fc\0\u0330\0\u042f\0\u0462"+
    "\0\u0363\0\u0495\0\u0330\0\u04c8\0\u04fb\0\u0330\0\u0363\0\u052e"+
    "\0\u0561\0\u0330\0\u0330\0\u0330\0\u0363\0\u0594\0\u0330\0\u05c7"+
    "\0\u05fa\0\u062d\0\u0330\0\u0660\0\u0330\0\u0693\0\u06c6\0\u0330"+
    "\0\u0330\0\u06f9\0\u072c\0\u0330\0\u0330\0\u0363\0\u075f\0\u0792"+
    "\0\u0330\0\u07c5\0\u0330\0\u0363\0\u062d\0\u0330\0\u0363\0\u07f8"+
    "\0\u082b\0\u085e\0\u0330\0\u0891\0\u08c4\0\u08f7\0\u092a\0\u095d"+
    "\0\u0990\0\u09c3\0\u09f6\0\u0a29\0\u0330\0\u0462\0\u0495\0\u0a5c"+
    "\0\u0a8f\0\u0ac2\0\u0af5\0\u0330\0\u0330\0\u0b28\0\u0b5b\0\u0b8e"+
    "\0\u0330\0\u0bc1\0\u0bf4\0\u0330\0\u0c27\0\u0c5a\0\u0c8d\0\u0cc0"+
    "\0\u0cf3\0\u0d26\0\u0d59\0\u0d8c\0\u0dbf\0\u0df2\0\u0e25\0\u0330"+
    "\0\u0e58\0\u0330\0\u0330\0\u0e8b\0\u0ebe\0\u0330\0\u0ef1\0\u0330"+
    "\0\u0f24\0\u0330\0\u0f57\0\u0f8a\0\u0fbd\0\u0ff0\0\u0330\0\u1023"+
    "\0\u1056\0\u0330";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\17\1\20\2\17\2\21\1\22\10\17\1\23\24\17"+
    "\1\24\15\17\1\25\1\26\1\27\1\26\1\30\2\26"+
    "\1\31\1\32\11\26\1\33\7\26\1\34\4\26\1\35"+
    "\16\26\1\35\4\26\1\27\6\36\1\37\2\36\1\40"+
    "\5\36\1\41\1\36\1\42\21\36\1\43\17\36\1\44"+
    "\1\27\4\44\1\45\6\44\1\46\1\44\1\47\3\44"+
    "\20\46\3\44\14\46\1\27\1\44\1\27\4\44\1\45"+
    "\6\44\1\46\1\44\1\50\3\44\20\46\3\44\14\46"+
    "\1\27\1\44\1\51\4\44\1\45\4\44\1\52\5\44"+
    "\1\53\40\44\1\51\1\54\1\27\1\54\1\44\3\54"+
    "\1\44\3\54\1\52\3\54\1\44\1\55\1\53\40\54"+
    "\1\56\1\57\1\27\1\57\1\60\3\57\1\61\3\57"+
    "\1\62\5\57\1\53\40\57\1\63\3\64\1\65\2\64"+
    "\1\66\35\64\1\67\24\64\1\66\1\65\34\64\1\67"+
    "\16\64\21\70\1\71\1\72\40\70\1\73\1\27\4\73"+
    "\1\74\4\73\1\75\3\73\1\47\1\73\1\53\40\73"+
    "\1\27\6\76\1\77\2\76\1\100\11\76\20\101\2\76"+
    "\1\102\14\101\7\76\1\77\2\76\1\100\11\76\20\101"+
    "\2\76\1\103\14\101\1\76\1\17\1\0\2\17\3\0"+
    "\10\17\1\0\24\17\1\24\16\17\1\0\1\20\60\0"+
    "\1\20\67\0\1\104\10\0\1\105\5\0\20\105\3\0"+
    "\1\106\1\105\2\107\1\105\1\110\2\105\1\111\3\105"+
    "\3\0\1\112\10\0\1\113\1\0\1\114\4\0\1\115"+
    "\20\114\3\0\14\114\1\0\1\17\1\0\4\17\1\0"+
    "\10\17\1\0\24\17\1\24\17\17\1\20\2\17\3\0"+
    "\10\17\1\0\24\17\1\24\15\17\1\25\1\0\1\27"+
    "\60\0\1\27\3\116\1\64\57\116\7\117\1\64\53\117"+
    "\37\0\1\120\20\0\1\120\42\0\1\121\20\0\1\121"+
    "\12\0\1\122\53\0\1\123\71\0\2\46\1\0\2\46"+
    "\5\0\20\46\3\0\14\46\14\0\1\124\50\0\1\51"+
    "\60\0\1\51\21\0\1\125\41\0\1\54\1\0\1\54"+
    "\1\0\3\54\1\0\3\54\1\0\3\54\3\0\42\54"+
    "\1\27\1\54\1\0\3\54\1\0\3\54\1\0\3\54"+
    "\3\0\40\54\1\56\1\57\1\0\11\57\1\126\5\57"+
    "\1\0\42\57\1\0\11\57\1\126\5\57\1\125\42\57"+
    "\1\27\11\57\1\126\5\57\1\0\40\57\1\63\5\0"+
    "\1\64\55\0\21\70\1\0\1\127\61\70\1\71\41\70"+
    "\11\0\1\130\52\0\2\101\3\0\1\101\1\0\1\101"+
    "\1\0\1\101\1\0\1\101\6\0\20\101\3\0\15\101"+
    "\21\0\1\131\55\0\1\132\24\0\1\133\32\0\2\105"+
    "\1\0\2\105\1\134\4\0\20\105\3\0\14\105\12\0"+
    "\2\105\1\0\2\105\1\134\4\0\20\105\3\0\4\105"+
    "\1\135\2\105\1\136\4\105\12\0\2\105\1\0\2\105"+
    "\1\134\4\0\20\105\3\0\12\105\1\137\1\105\12\0"+
    "\2\105\1\0\2\105\1\134\4\0\20\105\3\0\1\105"+
    "\1\140\12\105\12\0\2\105\1\0\2\105\1\134\4\0"+
    "\20\105\3\0\13\105\1\141\12\0\1\142\14\0\1\143"+
    "\51\0\1\144\5\0\20\144\3\0\14\144\12\0\2\114"+
    "\1\0\2\114\5\0\20\114\3\0\14\114\35\0\1\145"+
    "\15\0\1\145\34\0\1\146\22\0\1\146\15\0\1\147"+
    "\16\0\1\150\52\0\1\151\31\0\1\152\17\0\13\57"+
    "\1\126\5\57\1\0\41\57\21\70\1\0\41\70\21\0"+
    "\1\150\55\0\1\132\1\0\1\153\60\0\1\154\6\0"+
    "\5\154\16\0\2\154\24\0\2\105\1\0\2\105\1\134"+
    "\4\0\20\105\3\0\7\105\1\137\4\105\12\0\2\105"+
    "\1\0\2\105\1\134\4\0\20\105\3\0\6\105\1\155"+
    "\5\105\12\0\2\105\1\0\2\105\1\153\4\0\20\105"+
    "\3\0\14\105\12\0\2\105\1\0\2\105\1\134\4\0"+
    "\20\105\3\0\11\105\1\135\2\105\12\0\2\105\1\0"+
    "\2\105\1\134\4\0\20\105\3\0\6\105\1\107\5\105"+
    "\12\0\1\156\106\0\1\157\16\0\1\157\17\0\2\144"+
    "\1\0\2\144\5\0\20\144\3\0\14\144\34\0\1\160"+
    "\15\0\1\160\44\0\1\161\15\0\1\161\32\0\1\162"+
    "\52\0\1\163\65\0\1\154\1\0\1\153\4\0\5\154"+
    "\16\0\2\154\24\0\2\105\1\0\2\105\1\134\4\0"+
    "\20\105\3\0\11\105\1\137\2\105\26\0\1\164\67\0"+
    "\1\165\41\0\1\147\7\0\1\150\100\0\1\166\20\0"+
    "\1\166\27\0\1\167\77\0\1\170\56\0\1\171\16\0"+
    "\1\171\34\0\1\172\33\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[4233];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\11\0\1\1\3\0\2\1\1\11\4\1\1\11"+
    "\4\1\1\11\2\1\1\11\3\1\3\11\2\1\1\11"+
    "\3\1\1\11\1\1\1\11\2\1\2\11\2\1\2\11"+
    "\3\1\1\11\1\1\1\11\2\1\1\11\4\1\1\11"+
    "\7\0\2\1\1\11\6\0\2\11\1\1\2\0\1\11"+
    "\2\0\1\11\7\0\1\1\3\0\1\11\1\0\2\11"+
    "\2\0\1\11\1\0\1\11\1\0\1\11\1\1\3\0"+
    "\1\11\2\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public _HtmlLexer() {
    this((java.io.Reader)null);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _HtmlLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return XmlTokenType.XML_DATA_CHARACTERS;
            }
          // fall through
          case 40: break;
          case 2:
            { return XmlTokenType.XML_PI_TARGET;
            }
          // fall through
          case 41: break;
          case 3:
            { return XmlTokenType.XML_REAL_WHITE_SPACE;
            }
          // fall through
          case 42: break;
          case 4:
            { return XmlTokenType.XML_BAD_CHARACTER;
            }
          // fall through
          case 43: break;
          case 5:
            { return XmlTokenType.XML_WHITE_SPACE;
            }
          // fall through
          case 44: break;
          case 6:
            { yybegin(YYINITIAL); return XmlTokenType.XML_DOCTYPE_END;
            }
          // fall through
          case 45: break;
          case 7:
            { return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 46: break;
          case 8:
            { // according to HTML spec (http://www.w3.org/html/wg/drafts/html/master/syntax.html#comments)
  // comments should start with <!-- and end with -->. The comment <!--> is not valid, but should terminate
  // comment token. Please note that it's not true for XML (http://www.w3.org/TR/REC-xml/#sec-comments)
  int loc = getTokenStart();
  char prev = zzBuffer.charAt(loc - 1);
  char prevPrev = zzBuffer.charAt(loc - 2);
  if (prev == '-' && prevPrev == '-') {
    yybegin(YYINITIAL); return XmlTokenType.XML_BAD_CHARACTER;
  }
  return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 47: break;
          case 9:
            { yybegin(C_COMMENT_START); return XmlTokenType.XML_CONDITIONAL_COMMENT_START;
            }
          // fall through
          case 48: break;
          case 10:
            { yybegin(YYINITIAL); yypushback(1); break;
            }
          // fall through
          case 49: break;
          case 11:
            { yybegin(BEFORE_TAG_ATTRIBUTES); return XmlTokenType.XML_NAME;
            }
          // fall through
          case 50: break;
          case 12:
            { return XmlTokenType.XML_START_TAG_START;
            }
          // fall through
          case 51: break;
          case 13:
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_WHITE_SPACE;
            }
          // fall through
          case 52: break;
          case 14:
            { yybegin(YYINITIAL); return XmlTokenType.XML_TAG_END;
            }
          // fall through
          case 53: break;
          case 15:
            { return XmlTokenType.XML_NAME;
            }
          // fall through
          case 54: break;
          case 16:
            { yybegin(ATTRIBUTE_VALUE_START); return XmlTokenType.XML_EQ;
            }
          // fall through
          case 55: break;
          case 17:
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            }
          // fall through
          case 56: break;
          case 18:
            { yybegin(ATTRIBUTE_VALUE_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 57: break;
          case 19:
            { yybegin(ATTRIBUTE_VALUE_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 58: break;
          case 20:
            { return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            }
          // fall through
          case 59: break;
          case 21:
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            }
          // fall through
          case 60: break;
          case 22:
            { yybegin(YYINITIAL); return XmlTokenType.XML_PI_END;
            }
          // fall through
          case 61: break;
          case 23:
            { return XmlTokenType.XML_TAG_CHARACTERS;
            }
          // fall through
          case 62: break;
          case 24:
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 63: break;
          case 25:
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_END;
            }
          // fall through
          case 64: break;
          case 26:
            { return XmlTokenType.XML_END_TAG_START;
            }
          // fall through
          case 65: break;
          case 27:
            { yybegin(START_TAG_NAME); yypushback(yylength());
            }
          // fall through
          case 66: break;
          case 28:
            { yybegin(PROCESSING_INSTRUCTION); return XmlTokenType.XML_PI_START;
            }
          // fall through
          case 67: break;
          case 29:
            { yybegin(YYINITIAL); return XmlTokenType.XML_EMPTY_ELEMENT_END;
            }
          // fall through
          case 68: break;
          case 30:
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_START_END;
            }
          // fall through
          case 69: break;
          case 31:
            { return XmlTokenType.XML_ENTITY_REF_TOKEN;
            }
          // fall through
          case 70: break;
          case 32:
            { yybegin(END_TAG_NAME); yypushback(yylength());
            }
          // fall through
          case 71: break;
          case 33:
            { yybegin(YYINITIAL); return XmlTokenType.XML_COMMENT_END;
            }
          // fall through
          case 72: break;
          case 34:
            { yybegin(C_COMMENT_END); return XmlTokenType.XML_CONDITIONAL_COMMENT_END_START;
            }
          // fall through
          case 73: break;
          case 35:
            { return XmlTokenType.XML_CHAR_ENTITY_REF;
            }
          // fall through
          case 74: break;
          case 36:
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_START;
            }
          // fall through
          case 75: break;
          case 37:
            { yybegin(YYINITIAL); return XmlTokenType.XML_BAD_CHARACTER;
            }
          // fall through
          case 76: break;
          case 38:
            { return XmlTokenType.XML_DOCTYPE_PUBLIC;
            }
          // fall through
          case 77: break;
          case 39:
            { yybegin(DOC_TYPE); return XmlTokenType.XML_DOCTYPE_START;
            }
          // fall through
          case 78: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
