// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

// Generated by JFlex 1.9.1 http://jflex.de/  (tweaked for IntelliJ platform)
// source: _DtdLexer.flex

 /* It's an automatically generated code. Do not modify it. */
package com.intellij.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.*;
import com.intellij.psi.xml.*;


public class _DtdLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int DECL = 2;
  public static final int DECL_ATTR = 4;
  public static final int DECL_ATTR_VALUE_DQ = 6;
  public static final int DECL_ATTR_VALUE_SQ = 8;
  public static final int TAG_NAME = 10;
  public static final int TAG_ATTRIBUTES = 12;
  public static final int COMMENT = 14;
  public static final int ATTRIBUTE_VALUE_START = 16;
  public static final int ATTRIBUTE_VALUE_DQ = 18;
  public static final int ATTRIBUTE_VALUE_SQ = 20;
  public static final int PROCESSING_INSTRUCTION = 22;
  public static final int DOCTYPE_MARKUP_STARTED = 24;
  public static final int DOCTYPE = 26;
  public static final int DOCTYPE_EXTERNAL_ID = 28;
  public static final int DOCTYPE_MARKUP = 30;
  public static final int DOCTYPE_MARKUP_DQ = 32;
  public static final int DOCTYPE_MARKUP_SQ = 34;
  public static final int CDATA = 36;
  public static final int CONDITIONAL = 38;
  public static final int DOCTYPE_COMMENT = 40;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19, 20, 20
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\41\u1f00\1\u0100\1\u2f00\1\u3000\1\u0100\1\u3100\1\u3200"+
    "\1\u3300\1\u3400\1\u1f00\1\u3500\1\u3600\1\u3700\1\u3800\1\u0100"+
    "\1\u3900\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u1f00"+
    "\1\u4000\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700"+
    "\1\u4800\1\u4900\1\u4a00\1\u4b00\1\u1f00\1\u4c00\1\u4d00\1\u4e00"+
    "\1\u1f00\3\u0100\1\u4f00\1\u5000\1\u5100\12\u1f00\4\u0100\1\u5200"+
    "\17\u1f00\2\u0100\1\u5300\41\u1f00\2\u0100\1\u5400\1\u5500\2\u1f00"+
    "\1\u5600\1\u5700\27\u0100\1\u5800\2\u0100\1\u5900\45\u1f00\1\u0100"+
    "\1\u5a00\1\u5b00\11\u1f00\1\u5c00\27\u1f00\1\u5d00\1\u5e00\1\u5f00"+
    "\1\u6000\11\u1f00\1\u6100\1\u6200\5\u1f00\1\u6300\1\u6400\4\u1f00"+
    "\1\u6500\21\u1f00\246\u0100\1\u6600\20\u0100\1\u6700\1\u6800\25\u0100"+
    "\1\u6900\34\u0100\1\u6a00\14\u1f00\2\u0100\1\u6b00\u0e05\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\2\1\1\0\2\1\22\0\1\2\1\3\1\4"+
    "\1\5\1\0\1\6\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\12\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\0\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\22\1\37\2\22\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\2\22\1\52\1\53\1\22\1\54\1\0\1\55"+
    "\1\0\1\22\1\0\6\56\5\22\1\57\1\60\12\22"+
    "\1\61\2\22\1\0\1\62\55\0\1\22\12\0\1\22"+
    "\4\0\1\22\5\0\27\22\1\0\37\22\1\0\u01ca\22"+
    "\4\0\14\22\16\0\5\22\7\0\1\22\1\0\1\22"+
    "\201\0\5\22\1\0\2\22\2\0\4\22\1\0\1\22"+
    "\6\0\1\22\1\0\3\22\1\0\1\22\1\0\24\22"+
    "\1\0\123\22\1\0\213\22\10\0\246\22\1\0\46\22"+
    "\2\0\1\22\6\0\51\22\107\0\33\22\4\0\4\22"+
    "\55\0\53\22\43\0\2\22\1\0\143\22\1\0\1\22"+
    "\17\0\2\22\7\0\2\22\12\0\3\22\2\0\1\22"+
    "\20\0\1\22\1\0\36\22\35\0\131\22\13\0\1\22"+
    "\30\0\41\22\11\0\2\22\4\0\1\22\5\0\26\22"+
    "\4\0\1\22\11\0\1\22\3\0\1\22\27\0\31\22"+
    "\7\0\13\22\65\0\25\22\1\0\10\22\106\0\66\22"+
    "\3\0\1\22\22\0\1\22\7\0\12\22\17\0\20\22"+
    "\4\0\10\22\2\0\2\22\2\0\26\22\1\0\7\22"+
    "\1\0\1\22\3\0\4\22\3\0\1\22\20\0\1\22"+
    "\15\0\2\22\1\0\3\22\16\0\2\22\12\0\1\22"+
    "\10\0\6\22\4\0\2\22\2\0\26\22\1\0\7\22"+
    "\1\0\2\22\1\0\2\22\1\0\2\22\37\0\4\22"+
    "\1\0\1\22\23\0\3\22\20\0\11\22\1\0\3\22"+
    "\1\0\26\22\1\0\7\22\1\0\2\22\1\0\5\22"+
    "\3\0\1\22\22\0\1\22\17\0\2\22\27\0\1\22"+
    "\13\0\10\22\2\0\2\22\2\0\26\22\1\0\7\22"+
    "\1\0\2\22\1\0\5\22\3\0\1\22\36\0\2\22"+
    "\1\0\3\22\17\0\1\22\21\0\1\22\1\0\6\22"+
    "\3\0\3\22\1\0\4\22\3\0\2\22\1\0\1\22"+
    "\1\0\2\22\3\0\2\22\3\0\3\22\3\0\14\22"+
    "\26\0\1\22\64\0\10\22\1\0\3\22\1\0\27\22"+
    "\1\0\20\22\3\0\1\22\32\0\3\22\5\0\2\22"+
    "\36\0\1\22\4\0\10\22\1\0\3\22\1\0\27\22"+
    "\1\0\12\22\1\0\5\22\3\0\1\22\40\0\1\22"+
    "\1\0\2\22\17\0\2\22\22\0\10\22\1\0\3\22"+
    "\1\0\51\22\2\0\1\22\20\0\1\22\5\0\3\22"+
    "\10\0\3\22\30\0\6\22\5\0\22\22\3\0\30\22"+
    "\1\0\11\22\1\0\1\22\2\0\7\22\72\0\60\22"+
    "\1\0\2\22\14\0\7\22\72\0\2\22\1\0\1\22"+
    "\1\0\5\22\1\0\30\22\1\0\1\22\1\0\12\22"+
    "\1\0\2\22\11\0\1\22\2\0\5\22\1\0\1\22"+
    "\25\0\4\22\40\0\1\22\77\0\10\22\1\0\44\22"+
    "\33\0\5\22\163\0\53\22\24\0\1\22\20\0\6\22"+
    "\4\0\4\22\3\0\1\22\3\0\2\22\7\0\3\22"+
    "\4\0\15\22\14\0\1\22\21\0\46\22\1\0\1\22"+
    "\5\0\1\22\2\0\53\22\1\0\115\22\1\0\4\22"+
    "\2\0\7\22\1\0\1\22\1\0\4\22\2\0\51\22"+
    "\1\0\4\22\2\0\41\22\1\0\4\22\2\0\7\22"+
    "\1\0\1\22\1\0\4\22\2\0\17\22\1\0\71\22"+
    "\1\0\4\22\2\0\103\22\45\0\20\22\20\0\126\22"+
    "\2\0\6\22\3\0\u016c\22\2\0\21\22\1\0\32\22"+
    "\5\0\113\22\6\0\10\22\7\0\15\22\1\0\4\22"+
    "\16\0\22\22\16\0\22\22\16\0\15\22\1\0\3\22"+
    "\17\0\64\22\43\0\1\22\4\0\1\22\103\0\131\22"+
    "\7\0\5\22\2\0\42\22\1\0\1\22\5\0\106\22"+
    "\12\0\37\22\61\0\36\22\2\0\5\22\13\0\54\22"+
    "\4\0\32\22\66\0\27\22\11\0\65\22\122\0\1\22"+
    "\135\0\57\22\21\0\7\22\67\0\36\22\15\0\2\22"+
    "\12\0\54\22\32\0\44\22\51\0\3\22\12\0\44\22"+
    "\2\0\11\22\7\0\53\22\2\0\3\22\51\0\4\22"+
    "\1\0\6\22\1\0\2\22\3\0\1\22\5\0\300\22"+
    "\100\0\26\22\2\0\6\22\2\0\46\22\2\0\6\22"+
    "\2\0\10\22\1\0\1\22\1\0\1\22\1\0\1\22"+
    "\1\0\37\22\2\0\65\22\1\0\7\22\1\0\1\22"+
    "\3\0\3\22\1\0\7\22\3\0\4\22\2\0\6\22"+
    "\4\0\15\22\5\0\3\22\1\0\7\22\164\0\1\22"+
    "\15\0\1\22\20\0\15\22\145\0\1\22\4\0\1\22"+
    "\2\0\12\22\1\0\1\22\3\0\5\22\6\0\1\22"+
    "\1\0\1\22\1\0\1\22\1\0\4\22\1\0\13\22"+
    "\2\0\4\22\5\0\5\22\4\0\1\22\64\0\2\22"+
    "\u017b\0\57\22\1\0\57\22\1\0\205\22\6\0\4\22"+
    "\3\0\2\22\14\0\46\22\1\0\1\22\5\0\1\22"+
    "\2\0\70\22\7\0\1\22\20\0\27\22\11\0\7\22"+
    "\1\0\7\22\1\0\7\22\1\0\7\22\1\0\7\22"+
    "\1\0\7\22\1\0\7\22\1\0\7\22\120\0\1\22"+
    "\325\0\2\22\52\0\5\22\5\0\2\22\4\0\126\22"+
    "\6\0\3\22\1\0\132\22\1\0\4\22\5\0\53\22"+
    "\1\0\136\22\21\0\33\22\65\0\306\22\112\0\360\22"+
    "\20\0\215\22\103\0\56\22\2\0\15\22\3\0\20\22"+
    "\12\0\2\22\24\0\57\22\20\0\37\22\2\0\106\22"+
    "\61\0\11\22\2\0\147\22\2\0\65\22\2\0\5\22"+
    "\60\0\13\22\1\0\3\22\1\0\4\22\1\0\27\22"+
    "\35\0\64\22\16\0\62\22\76\0\6\22\3\0\1\22"+
    "\1\0\2\22\13\0\34\22\12\0\27\22\31\0\35\22"+
    "\7\0\57\22\34\0\1\22\20\0\5\22\1\0\12\22"+
    "\12\0\5\22\1\0\51\22\27\0\3\22\1\0\10\22"+
    "\24\0\27\22\3\0\1\22\3\0\62\22\1\0\1\22"+
    "\3\0\2\22\2\0\5\22\2\0\1\22\1\0\1\22"+
    "\30\0\3\22\2\0\13\22\7\0\3\22\14\0\6\22"+
    "\2\0\6\22\2\0\6\22\11\0\7\22\1\0\7\22"+
    "\1\0\53\22\1\0\14\22\10\0\163\22\35\0\244\22"+
    "\14\0\27\22\4\0\61\22\4\0\156\22\2\0\152\22"+
    "\46\0\7\22\14\0\5\22\5\0\1\22\1\0\12\22"+
    "\1\0\15\22\1\0\5\22\1\0\1\22\1\0\2\22"+
    "\1\0\2\22\1\0\154\22\41\0\153\22\22\0\100\22"+
    "\2\0\66\22\50\0\14\22\164\0\5\22\1\0\207\22"+
    "\44\0\32\22\6\0\32\22\13\0\131\22\3\0\6\22"+
    "\2\0\6\22\2\0\6\22\2\0\3\22\43\0\14\22"+
    "\1\0\32\22\1\0\23\22\1\0\2\22\1\0\17\22"+
    "\2\0\16\22\42\0\173\22\205\0\35\22\3\0\61\22"+
    "\57\0\40\22\15\0\24\22\1\0\10\22\6\0\46\22"+
    "\12\0\36\22\2\0\44\22\4\0\10\22\60\0\236\22"+
    "\22\0\44\22\4\0\44\22\4\0\50\22\10\0\64\22"+
    "\234\0\67\22\11\0\26\22\12\0\10\22\230\0\6\22"+
    "\2\0\1\22\1\0\54\22\1\0\2\22\3\0\1\22"+
    "\2\0\27\22\12\0\27\22\11\0\37\22\101\0\23\22"+
    "\1\0\2\22\12\0\26\22\12\0\32\22\106\0\70\22"+
    "\6\0\2\22\100\0\1\22\17\0\4\22\1\0\3\22"+
    "\1\0\35\22\52\0\35\22\3\0\35\22\43\0\10\22"+
    "\1\0\34\22\33\0\66\22\12\0\26\22\12\0\23\22"+
    "\15\0\22\22\156\0\111\22\67\0\63\22\15\0\63\22"+
    "\15\0\44\22\334\0\35\22\12\0\1\22\10\0\26\22"+
    "\232\0\27\22\14\0\65\22\113\0\55\22\40\0\31\22"+
    "\32\0\44\22\35\0\1\22\13\0\43\22\3\0\1\22"+
    "\14\0\60\22\16\0\4\22\25\0\1\22\1\0\1\22"+
    "\43\0\22\22\1\0\31\22\124\0\7\22\1\0\1\22"+
    "\1\0\4\22\1\0\17\22\1\0\12\22\7\0\57\22"+
    "\46\0\10\22\2\0\2\22\2\0\26\22\1\0\7\22"+
    "\1\0\2\22\1\0\5\22\3\0\1\22\22\0\1\22"+
    "\14\0\5\22\236\0\65\22\22\0\4\22\24\0\1\22"+
    "\40\0\60\22\24\0\2\22\1\0\1\22\270\0\57\22"+
    "\51\0\4\22\44\0\60\22\24\0\1\22\73\0\53\22"+
    "\15\0\1\22\107\0\33\22\345\0\54\22\164\0\100\22"+
    "\37\0\1\22\240\0\10\22\2\0\47\22\20\0\1\22"+
    "\1\0\1\22\34\0\1\22\12\0\50\22\7\0\1\22"+
    "\25\0\1\22\13\0\56\22\23\0\1\22\42\0\71\22"+
    "\7\0\11\22\1\0\45\22\21\0\1\22\61\0\36\22"+
    "\160\0\7\22\1\0\2\22\1\0\46\22\25\0\1\22"+
    "\31\0\6\22\1\0\2\22\1\0\40\22\16\0\1\22"+
    "\u0147\0\23\22\15\0\232\22\346\0\304\22\274\0\57\22"+
    "\321\0\107\22\271\0\71\22\7\0\37\22\161\0\36\22"+
    "\22\0\60\22\20\0\4\22\37\0\25\22\5\0\23\22"+
    "\260\0\100\22\200\0\113\22\5\0\1\22\102\0\15\22"+
    "\100\0\2\22\1\0\1\22\34\0\370\22\10\0\363\22"+
    "\15\0\37\22\61\0\3\22\21\0\4\22\10\0\u018c\22"+
    "\4\0\153\22\5\0\15\22\3\0\11\22\7\0\12\22"+
    "\146\0\125\22\1\0\107\22\1\0\2\22\2\0\1\22"+
    "\2\0\2\22\2\0\4\22\1\0\14\22\1\0\1\22"+
    "\1\0\7\22\1\0\101\22\1\0\4\22\2\0\10\22"+
    "\1\0\7\22\1\0\34\22\1\0\4\22\1\0\5\22"+
    "\1\0\1\22\3\0\7\22\1\0\u0154\22\2\0\31\22"+
    "\1\0\31\22\1\0\37\22\1\0\31\22\1\0\37\22"+
    "\1\0\31\22\1\0\37\22\1\0\31\22\1\0\37\22"+
    "\1\0\31\22\1\0\10\22\64\0\55\22\12\0\7\22"+
    "\20\0\1\22\u0171\0\54\22\24\0\305\22\73\0\104\22"+
    "\7\0\1\22\264\0\4\22\1\0\33\22\1\0\2\22"+
    "\1\0\1\22\2\0\1\22\1\0\12\22\1\0\4\22"+
    "\1\0\1\22\1\0\1\22\6\0\1\22\4\0\1\22"+
    "\1\0\1\22\1\0\1\22\1\0\3\22\1\0\2\22"+
    "\1\0\1\22\2\0\1\22\1\0\1\22\1\0\1\22"+
    "\1\0\1\22\1\0\1\22\1\0\2\22\1\0\1\22"+
    "\2\0\4\22\1\0\7\22\1\0\4\22\1\0\4\22"+
    "\1\0\1\22\1\0\12\22\1\0\21\22\5\0\3\22"+
    "\1\0\5\22\1\0\21\22\104\0\327\22\51\0\65\22"+
    "\13\0\336\22\2\0\u0182\22\16\0\u0131\22\37\0\36\22"+
    "\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27648];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\2\1\2\0\1\2\14\0\1\2\1\3\1\4"+
    "\1\3\1\5\1\6\1\3\2\5\1\7\1\5\1\10"+
    "\2\5\1\11\1\12\1\13\1\1\1\14\11\1\1\15"+
    "\1\6\1\5\1\16\1\17\1\20\3\2\1\5\2\2"+
    "\1\21\1\22\1\1\1\23\3\1\6\24\1\5\1\25"+
    "\2\16\1\26\2\5\1\27\1\5\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\16\1\40\1\5"+
    "\1\41\1\42\4\16\1\43\1\44\1\45\3\3\2\5"+
    "\3\0\1\46\1\47\2\0\1\50\10\1\1\51\1\0"+
    "\2\2\1\0\2\2\1\52\1\53\2\16\6\0\1\16"+
    "\1\0\4\16\4\0\1\54\1\55\7\0\1\56\1\0"+
    "\1\57\1\55\2\1\1\56\1\57\1\55\2\1\1\56"+
    "\1\57\1\0\1\55\2\2\1\60\1\0\1\56\1\57"+
    "\2\16\5\0\1\16\1\61\3\16\1\0\1\62\2\0"+
    "\1\63\1\0\1\64\7\0\1\63\2\1\1\63\2\1"+
    "\1\63\2\2\2\16\5\0\1\65\3\16\11\0\2\1"+
    "\1\2\2\16\4\0\1\65\1\66\2\16\10\0\1\67"+
    "\2\1\1\2\1\70\1\71\1\72\3\0\1\73\1\74"+
    "\1\75\7\0\2\1\1\2\1\0\1\76\1\0\1\77"+
    "\3\0\1\100\2\0\2\1\1\2\1\101\1\0\1\102"+
    "\1\103\1\104\1\0\4\105\1\106\1\107";

  private static int [] zzUnpackAction() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\377\0\u0132\0\u0165"+
    "\0\u0198\0\u01cb\0\u01fe\0\u0231\0\u0264\0\u0297\0\u02ca\0\u02fd"+
    "\0\u0330\0\u0363\0\u0396\0\u03c9\0\u03fc\0\u042f\0\u0462\0\u0495"+
    "\0\u04c8\0\u04fb\0\u052e\0\u042f\0\u0495\0\u0561\0\u0594\0\u042f"+
    "\0\u05c7\0\u052e\0\u042f\0\u042f\0\u042f\0\u05fa\0\u042f\0\u062d"+
    "\0\u0660\0\u0693\0\u06c6\0\u06f9\0\u072c\0\u075f\0\u0792\0\u07c5"+
    "\0\u07f8\0\u082b\0\u085e\0\u0891\0\u042f\0\u042f\0\u08c4\0\u08f7"+
    "\0\u092a\0\u095d\0\u0990\0\u09c3\0\u042f\0\u042f\0\u042f\0\u042f"+
    "\0\u0495\0\u04c8\0\u052e\0\u042f\0\u0495\0\u04c8\0\u0594\0\u09f6"+
    "\0\u052e\0\u0a29\0\u042f\0\u0a5c\0\u0a8f\0\u042f\0\u0ac2\0\u0af5"+
    "\0\u042f\0\u0b28\0\u0495\0\u04c8\0\u042f\0\u042f\0\u042f\0\u042f"+
    "\0\u042f\0\u042f\0\u0b5b\0\u042f\0\u0b8e\0\u042f\0\u042f\0\u0bc1"+
    "\0\u0bf4\0\u0c27\0\u0c5a\0\u052e\0\u042f\0\u042f\0\u04c8\0\u0c8d"+
    "\0\u0cc0\0\u0cf3\0\u0d26\0\u0d59\0\u0d8c\0\u0dbf\0\u042f\0\u0df2"+
    "\0\u0e25\0\u0e58\0\u042f\0\u0e8b\0\u0ebe\0\u0ef1\0\u0f24\0\u0f57"+
    "\0\u0f8a\0\u0fbd\0\u0ff0\0\u042f\0\u1023\0\u1056\0\u1089\0\u10bc"+
    "\0\u10ef\0\u1122\0\u042f\0\u042f\0\u1155\0\u1188\0\u0ac2\0\u0af5"+
    "\0\u11bb\0\u11ee\0\u1221\0\u1254\0\u1287\0\u12ba\0\u12ed\0\u1320"+
    "\0\u1353\0\u1386\0\u13b9\0\u13ec\0\u141f\0\u1452\0\u042f\0\u042f"+
    "\0\u1485\0\u14b8\0\u14eb\0\u151e\0\u1551\0\u1584\0\u15b7\0\u15ea"+
    "\0\u161d\0\u042f\0\u05fa\0\u1650\0\u1683\0\u16b6\0\u05fa\0\u06f9"+
    "\0\u16e9\0\u171c\0\u174f\0\u06f9\0\u1782\0\u08c4\0\u17b5\0\u17e8"+
    "\0\u042f\0\u181b\0\u184e\0\u08c4\0\u1881\0\u18b4\0\u18e7\0\u191a"+
    "\0\u194d\0\u1980\0\u19b3\0\u19e6\0\u0891\0\u1a19\0\u1a4c\0\u1a7f"+
    "\0\u1ab2\0\u042f\0\u1ae5\0\u1b18\0\u042f\0\u1b4b\0\u042f\0\u1b7e"+
    "\0\u1bb1\0\u1be4\0\u1c17\0\u1c4a\0\u1c7d\0\u1cb0\0\u05fa\0\u1ce3"+
    "\0\u1d16\0\u06f9\0\u1d49\0\u1d7c\0\u08c4\0\u1daf\0\u1de2\0\u1e15"+
    "\0\u1e48\0\u1e7b\0\u1eae\0\u1ee1\0\u1f14\0\u1f47\0\u0891\0\u1f7a"+
    "\0\u1fad\0\u1fe0\0\u2013\0\u2046\0\u2079\0\u20ac\0\u20df\0\u2112"+
    "\0\u2145\0\u2178\0\u21ab\0\u21de\0\u2211\0\u2244\0\u2277\0\u22aa"+
    "\0\u22dd\0\u2310\0\u2343\0\u2376\0\u042f\0\u0891\0\u23a9\0\u23dc"+
    "\0\u240f\0\u2442\0\u2475\0\u24a8\0\u24db\0\u250e\0\u2541\0\u2574"+
    "\0\u042f\0\u25a7\0\u25da\0\u260d\0\u0891\0\u0891\0\u042f\0\u2640"+
    "\0\u2673\0\u26a6\0\u0891\0\u0891\0\u042f\0\u26d9\0\u270c\0\u273f"+
    "\0\u2772\0\u27a5\0\u27d8\0\u280b\0\u283e\0\u2871\0\u28a4\0\u28d7"+
    "\0\u042f\0\u290a\0\u042f\0\u293d\0\u2970\0\u29a3\0\u042f\0\u29d6"+
    "\0\u2a09\0\u2a3c\0\u2a6f\0\u2aa2\0\u042f\0\u2ad5\0\u042f\0\u042f"+
    "\0\u042f\0\u2b08\0\u042f\0\u05fa\0\u06f9\0\u08c4\0\u042f\0\u042f";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\26\2\27\3\26\1\30\1\31\14\26\1\32\30\26"+
    "\1\33\5\26\1\34\2\27\3\34\1\35\1\31\12\34"+
    "\1\36\1\34\1\37\1\34\1\40\1\41\24\36\1\34"+
    "\1\42\4\36\2\34\2\27\1\34\1\43\1\34\1\35"+
    "\1\31\1\44\13\34\1\37\1\45\27\34\1\42\5\34"+
    "\4\46\1\47\1\46\1\50\1\51\14\46\1\52\30\46"+
    "\1\53\5\46\6\54\1\55\1\56\1\47\13\54\1\57"+
    "\30\54\1\60\5\54\1\34\2\27\3\34\1\35\1\31"+
    "\12\34\1\61\1\34\1\62\3\34\24\61\1\34\1\42"+
    "\4\61\2\34\2\27\3\34\1\35\1\31\10\34\1\63"+
    "\1\34\1\64\1\34\1\62\1\65\1\66\1\34\24\64"+
    "\1\34\1\42\4\64\1\34\6\67\1\70\1\71\6\67"+
    "\1\72\5\67\1\73\30\67\1\74\5\67\1\34\2\27"+
    "\1\34\1\75\1\34\1\35\1\31\1\76\7\34\1\63"+
    "\3\34\1\62\1\34\1\66\26\34\1\42\5\34\4\77"+
    "\1\100\1\77\1\101\1\102\14\77\1\62\30\77\1\103"+
    "\13\77\1\101\1\102\1\100\13\77\1\62\30\77\1\103"+
    "\5\77\6\104\1\105\1\106\14\104\1\107\2\104\1\110"+
    "\25\104\1\111\5\104\6\34\1\35\1\31\6\34\1\112"+
    "\5\34\1\37\30\34\1\42\6\34\2\27\3\34\1\35"+
    "\1\31\12\34\1\64\1\34\1\37\1\34\1\113\1\34"+
    "\14\64\1\114\2\64\1\115\4\64\1\116\1\42\4\64"+
    "\2\34\2\27\1\34\1\117\1\34\1\35\1\31\1\120"+
    "\13\34\1\37\1\34\1\113\25\34\1\116\1\42\6\34"+
    "\2\27\1\34\1\121\1\122\1\123\1\124\1\125\1\126"+
    "\1\127\1\130\1\131\1\132\1\133\1\64\1\34\2\64"+
    "\1\134\1\135\1\34\1\136\1\137\1\140\3\64\1\141"+
    "\7\64\1\142\2\64\1\143\4\64\1\34\1\144\4\64"+
    "\1\145\4\46\1\146\1\46\1\50\1\51\14\46\1\52"+
    "\30\46\1\53\5\46\6\54\1\55\1\56\1\146\13\54"+
    "\1\57\30\54\1\60\5\54\6\26\1\30\1\147\14\26"+
    "\1\150\30\26\1\151\5\26\1\34\2\27\3\34\1\35"+
    "\1\31\14\34\1\37\12\34\1\152\14\34\1\116\1\42"+
    "\5\34\6\67\1\70\1\71\6\67\1\153\5\67\1\73"+
    "\30\67\1\74\5\67\64\0\2\27\102\0\1\154\5\0"+
    "\24\154\2\0\4\154\6\0\1\155\14\0\1\154\5\0"+
    "\24\154\2\0\4\154\4\0\1\156\14\0\1\157\6\0"+
    "\1\160\110\0\1\161\23\0\2\36\1\0\2\36\5\0"+
    "\24\36\2\0\4\36\4\0\1\162\105\0\1\163\34\0"+
    "\4\46\1\0\62\46\1\0\15\46\1\164\5\46\24\164"+
    "\2\46\4\164\5\46\1\0\1\165\14\46\1\164\5\46"+
    "\24\164\2\46\4\164\4\46\1\166\1\0\62\46\1\0"+
    "\50\46\1\167\5\46\10\54\1\0\62\54\1\0\11\54"+
    "\1\170\5\54\24\170\2\54\4\170\6\54\1\171\2\54"+
    "\1\0\11\54\1\170\5\54\24\170\2\54\4\170\4\54"+
    "\1\172\4\54\1\0\62\54\1\0\44\54\1\173\5\54"+
    "\16\0\2\61\1\0\2\61\5\0\24\61\2\0\4\61"+
    "\4\0\1\162\14\0\1\157\70\0\1\174\52\0\2\64"+
    "\1\0\2\64\5\0\24\64\2\0\4\64\1\0\16\67"+
    "\1\175\62\67\1\175\3\67\1\176\5\67\24\176\2\67"+
    "\4\176\6\67\1\177\10\67\1\175\3\67\1\176\5\67"+
    "\24\176\2\67\4\176\17\67\1\200\47\67\1\201\12\67"+
    "\1\175\62\67\1\175\36\67\1\202\5\67\26\0\1\203"+
    "\52\0\1\204\62\0\2\64\1\0\2\64\5\0\21\64"+
    "\1\205\2\64\2\0\4\64\17\0\2\64\1\0\2\64"+
    "\5\0\23\64\1\206\2\0\4\64\1\0\4\207\1\77"+
    "\56\207\10\210\1\77\52\210\35\0\1\211\1\0\1\212"+
    "\4\0\1\213\1\0\1\214\32\0\1\215\1\64\1\0"+
    "\2\64\5\0\24\64\2\0\4\64\4\0\1\216\75\0"+
    "\2\64\1\0\2\64\5\0\12\64\1\217\11\64\2\0"+
    "\4\64\17\0\2\64\1\0\2\64\5\0\11\64\1\220"+
    "\12\64\2\0\4\64\17\0\2\64\1\0\2\64\5\0"+
    "\21\64\1\221\2\64\2\0\4\64\17\0\2\64\1\0"+
    "\2\64\5\0\23\64\1\222\2\0\4\64\4\0\1\223"+
    "\134\0\1\224\43\0\1\225\3\0\1\226\20\0\16\67"+
    "\1\227\44\67\16\0\2\154\1\0\2\154\1\230\4\0"+
    "\24\154\2\0\4\154\22\0\1\231\37\0\1\232\17\0"+
    "\1\233\11\0\1\234\2\0\1\235\1\236\5\0\1\237"+
    "\11\0\1\240\67\0\1\241\27\0\1\242\52\0\1\233"+
    "\35\0\1\240\6\0\4\46\1\0\11\46\2\164\1\46"+
    "\2\164\1\243\4\46\24\164\2\46\4\164\5\46\1\0"+
    "\14\46\1\244\37\46\1\245\5\46\1\0\47\46\1\246"+
    "\12\46\1\0\21\46\1\247\34\46\10\54\1\0\5\54"+
    "\2\170\1\54\2\170\1\250\4\54\24\170\2\54\4\170"+
    "\11\54\1\0\10\54\1\251\37\54\1\252\11\54\1\0"+
    "\43\54\1\253\16\54\1\0\15\54\1\254\34\54\16\67"+
    "\1\0\62\67\1\255\1\176\1\67\2\176\1\256\4\67"+
    "\24\176\2\67\4\176\17\67\1\175\2\67\1\257\37\67"+
    "\1\260\1\67\26\0\1\261\34\0\16\67\1\262\35\67"+
    "\1\263\24\67\1\175\7\67\1\264\34\67\16\0\2\64"+
    "\1\0\2\64\5\0\1\64\1\265\22\64\2\0\4\64"+
    "\17\0\2\64\1\0\2\64\5\0\17\64\1\266\4\64"+
    "\2\0\4\64\40\0\1\267\64\0\1\270\53\0\1\271"+
    "\64\0\1\272\26\0\16\273\1\274\1\215\1\273\2\215"+
    "\5\273\24\215\2\273\4\215\1\273\16\0\1\233\11\0"+
    "\1\234\3\0\1\236\5\0\1\237\11\0\1\240\24\0"+
    "\2\64\1\0\2\64\5\0\23\64\1\275\2\0\4\64"+
    "\17\0\2\64\1\0\2\64\5\0\14\64\1\276\7\64"+
    "\2\0\4\64\17\0\2\64\1\0\2\64\5\0\1\64"+
    "\1\277\22\64\2\0\4\64\17\0\2\64\1\0\2\64"+
    "\5\0\17\64\1\300\4\64\2\0\4\64\17\0\1\301"+
    "\35\0\1\240\34\0\1\302\76\0\1\303\52\0\1\304"+
    "\51\0\1\231\1\0\1\305\60\0\1\306\6\0\6\306"+
    "\20\0\1\306\22\0\1\307\114\0\1\310\55\0\1\311"+
    "\57\0\1\312\1\0\1\313\63\0\1\314\51\0\1\315"+
    "\110\0\1\316\2\0\4\46\1\0\14\46\1\244\1\46"+
    "\1\317\43\46\1\0\14\46\1\320\6\46\6\320\20\46"+
    "\1\320\10\46\1\0\25\46\1\321\30\46\10\54\1\0"+
    "\10\54\1\251\1\54\1\322\47\54\1\0\10\54\1\323"+
    "\6\54\6\323\20\54\1\323\14\54\1\0\21\54\1\324"+
    "\30\54\16\67\1\154\1\176\1\67\2\176\1\256\4\67"+
    "\24\176\2\67\4\176\17\67\1\175\2\67\1\257\1\67"+
    "\1\325\55\67\1\175\2\67\1\326\6\67\6\326\20\67"+
    "\1\326\22\67\1\307\62\67\1\175\13\67\1\327\30\67"+
    "\16\0\2\64\1\0\2\64\5\0\10\64\1\330\13\64"+
    "\2\0\4\64\17\0\2\64\1\0\2\64\5\0\20\64"+
    "\1\331\3\64\2\0\4\64\53\0\1\332\54\0\1\333"+
    "\51\0\1\334\74\0\1\335\15\0\16\273\1\336\62\273"+
    "\1\337\1\215\1\273\2\215\5\273\24\215\2\273\4\215"+
    "\1\273\16\0\2\64\1\0\2\64\5\0\20\64\1\340"+
    "\3\64\2\0\4\64\17\0\2\64\1\0\2\64\5\0"+
    "\10\64\1\341\13\64\2\0\4\64\17\0\2\64\1\0"+
    "\2\64\5\0\20\64\1\342\3\64\2\0\4\64\17\0"+
    "\1\26\107\0\1\343\57\0\1\344\43\0\1\306\1\0"+
    "\1\305\4\0\6\306\20\0\1\306\54\0\1\345\44\0"+
    "\1\346\64\0\1\347\76\0\1\350\62\0\1\351\45\0"+
    "\1\352\106\0\1\353\3\0\4\46\1\0\14\46\1\320"+
    "\1\46\1\317\4\46\6\320\20\46\1\320\10\46\1\0"+
    "\26\46\1\354\27\46\10\54\1\0\10\54\1\323\1\54"+
    "\1\322\4\54\6\323\20\54\1\323\14\54\1\0\22\54"+
    "\1\355\27\54\16\67\1\175\2\67\1\326\1\67\1\325"+
    "\4\67\6\326\20\67\1\326\22\67\1\175\14\67\1\356"+
    "\27\67\16\0\2\64\1\0\2\64\5\0\7\64\1\357"+
    "\14\64\2\0\4\64\17\0\2\64\1\0\2\64\5\0"+
    "\4\64\1\360\17\64\2\0\4\64\35\0\1\361\66\0"+
    "\1\362\52\0\1\363\103\0\1\364\11\0\16\273\1\365"+
    "\44\273\16\0\2\64\1\0\2\64\5\0\23\64\1\366"+
    "\2\0\4\64\17\0\2\64\1\0\2\64\5\0\7\64"+
    "\1\367\14\64\2\0\4\64\17\0\2\64\1\0\2\64"+
    "\5\0\4\64\1\370\17\64\2\0\4\64\47\0\1\371"+
    "\65\0\1\372\51\0\1\373\72\0\1\374\53\0\1\375"+
    "\60\0\1\376\53\0\1\377\62\0\1\u0100\34\0\1\u0101"+
    "\60\0\4\46\1\0\23\46\1\u0102\32\46\10\54\1\0"+
    "\17\54\1\u0103\32\54\16\67\1\175\11\67\1\u0104\32\67"+
    "\16\0\2\64\1\0\2\64\5\0\2\64\1\u0105\21\64"+
    "\2\0\4\64\17\0\2\64\1\0\2\64\5\0\11\64"+
    "\1\u0106\12\64\2\0\4\64\34\0\1\u0107\66\0\1\u0108"+
    "\73\0\1\u0109\51\0\1\u010a\41\0\2\64\1\0\2\64"+
    "\5\0\2\64\1\u010b\21\64\2\0\4\64\17\0\2\64"+
    "\1\0\2\64\5\0\11\64\1\u010c\12\64\2\0\4\64"+
    "\35\0\1\u010d\61\0\1\u010e\66\0\1\u010f\76\0\1\u0110"+
    "\43\0\1\u0111\76\0\1\u0112\62\0\1\u0113\62\0\1\u0114"+
    "\12\0\4\46\1\0\43\46\1\u0115\12\46\10\54\1\0"+
    "\37\54\1\u0116\12\54\16\67\1\175\31\67\1\u0117\12\67"+
    "\34\0\1\u0118\56\0\1\u0119\100\0\1\u011a\50\0\1\u011b"+
    "\75\0\1\u011c\57\0\1\u011d\60\0\1\u011e\73\0\1\u011f"+
    "\46\0\1\u0120\53\0\1\u0121\32\0\4\46\1\0\23\46"+
    "\1\u0122\32\46\10\54\1\0\17\54\1\u0123\32\54\16\67"+
    "\1\175\11\67\1\u0124\32\67\33\0\1\u0125\63\0\1\u0126"+
    "\76\0\1\u0127\46\0\1\u0128\76\0\1\u0129\55\0\1\u012a"+
    "\73\0\1\u012b\6\0\4\46\1\0\47\46\1\u012c\6\46"+
    "\10\54\1\0\43\54\1\u012d\6\54\16\67\1\175\35\67"+
    "\1\u012e\6\67\33\0\1\u012f\71\0\1\u0130\20\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[11067];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\2\1\2\0\1\1\14\0\1\1\1\11\5\1"+
    "\1\11\3\1\1\11\2\1\3\11\1\1\1\11\15\1"+
    "\2\11\6\1\4\11\3\1\1\11\6\1\1\11\2\1"+
    "\1\11\2\1\1\11\3\1\6\11\1\1\1\11\1\1"+
    "\2\11\5\1\2\11\5\1\3\0\1\11\1\1\2\0"+
    "\1\11\10\1\1\11\1\0\2\1\1\0\2\1\2\11"+
    "\2\1\6\0\1\1\1\0\4\1\4\0\2\11\7\0"+
    "\1\1\1\0\1\11\12\1\1\0\3\1\1\11\1\0"+
    "\4\1\5\0\5\1\1\0\1\11\2\0\1\11\1\0"+
    "\1\11\7\0\13\1\5\0\4\1\11\0\5\1\4\0"+
    "\1\11\3\1\10\0\1\11\5\1\1\11\3\0\2\1"+
    "\1\11\7\0\3\1\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\3\1\1\11\1\0\3\11\1\0\1\11"+
    "\3\1\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
   private boolean isHighlightModeOn = false;

   public _DtdLexer(boolean highlightModeOn) {
     this((java.io.Reader)null);
     isHighlightModeOn = highlightModeOn;
   }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _DtdLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            }
          // fall through
          case 72: break;
          case 2:
            { return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          // fall through
          case 73: break;
          case 3:
            { return XmlTokenType.XML_DATA_CHARACTERS;
            }
          // fall through
          case 74: break;
          case 4:
            { return XmlTokenType.XML_WHITE_SPACE;
            }
          // fall through
          case 75: break;
          case 5:
            { return XmlTokenType.XML_BAD_CHARACTER;
            }
          // fall through
          case 76: break;
          case 6:
            { yybegin(TAG_NAME); return XmlTokenType.XML_START_TAG_START;
            }
          // fall through
          case 77: break;
          case 7:
            { yybegin(DECL_ATTR); return XmlTokenType.XML_NAME;
            }
          // fall through
          case 78: break;
          case 8:
            { yybegin(YYINITIAL); return XmlTokenType.XML_BAD_CHARACTER;
            }
          // fall through
          case 79: break;
          case 9:
            { yybegin(DECL_ATTR_VALUE_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 80: break;
          case 10:
            { yybegin(DECL_ATTR_VALUE_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 81: break;
          case 11:
            { return XmlTokenType.XML_EQ;
            }
          // fall through
          case 82: break;
          case 12:
            { yybegin(DECL); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            }
          // fall through
          case 83: break;
          case 13:
            { yybegin(TAG_ATTRIBUTES); return isHighlightModeOn ? XmlTokenType.XML_TAG_NAME:XmlTokenType.XML_NAME;
            }
          // fall through
          case 84: break;
          case 14:
            { return XmlTokenType.XML_NAME;
            }
          // fall through
          case 85: break;
          case 15:
            { yybegin(ATTRIBUTE_VALUE_START); return XmlTokenType.XML_EQ;
            }
          // fall through
          case 86: break;
          case 16:
            { yybegin(YYINITIAL); return XmlTokenType.XML_TAG_END;
            }
          // fall through
          case 87: break;
          case 17:
            { yybegin(ATTRIBUTE_VALUE_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 88: break;
          case 18:
            { yybegin(ATTRIBUTE_VALUE_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 89: break;
          case 19:
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            }
          // fall through
          case 90: break;
          case 20:
            { return XmlTokenType.XML_PI_TARGET;
            }
          // fall through
          case 91: break;
          case 21:
            { yybegin(YYINITIAL); return XmlTokenType.XML_DOCTYPE_END;
            }
          // fall through
          case 92: break;
          case 22:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_MARKUP_START;
            }
          // fall through
          case 93: break;
          case 23:
            { yybegin(DOCTYPE_MARKUP_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 94: break;
          case 24:
            { return XmlTokenType.XML_PERCENT;
            }
          // fall through
          case 95: break;
          case 25:
            { return XmlTokenType.XML_AMP;
            }
          // fall through
          case 96: break;
          case 26:
            { yybegin(DOCTYPE_MARKUP_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          // fall through
          case 97: break;
          case 27:
            { return XmlTokenType.XML_LEFT_PAREN;
            }
          // fall through
          case 98: break;
          case 28:
            { return XmlTokenType.XML_RIGHT_PAREN;
            }
          // fall through
          case 99: break;
          case 29:
            { return XmlTokenType.XML_STAR;
            }
          // fall through
          case 100: break;
          case 30:
            { return XmlTokenType.XML_PLUS;
            }
          // fall through
          case 101: break;
          case 31:
            { return XmlTokenType.XML_COMMA;
            }
          // fall through
          case 102: break;
          case 32:
            { return XmlTokenType.XML_SEMI;
            }
          // fall through
          case 103: break;
          case 33:
            { return XmlTokenType.XML_TAG_END;
            }
          // fall through
          case 104: break;
          case 34:
            { return XmlTokenType.XML_QUESTION;
            }
          // fall through
          case 105: break;
          case 35:
            { yybegin(DOCTYPE); return XmlTokenType.XML_MARKUP_END;
            }
          // fall through
          case 106: break;
          case 36:
            { return XmlTokenType.XML_BAR;
            }
          // fall through
          case 107: break;
          case 37:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            }
          // fall through
          case 108: break;
          case 38:
            { yybegin(TAG_NAME); return XmlTokenType.XML_END_TAG_START;
            }
          // fall through
          case 109: break;
          case 39:
            { yybegin(PROCESSING_INSTRUCTION); return XmlTokenType.XML_PI_START;
            }
          // fall through
          case 110: break;
          case 40:
            { yybegin(YYINITIAL); return XmlTokenType.XML_DECL_END;
            }
          // fall through
          case 111: break;
          case 41:
            { yybegin(YYINITIAL); return XmlTokenType.XML_EMPTY_ELEMENT_END;
            }
          // fall through
          case 112: break;
          case 42:
            { yybegin(YYINITIAL); return XmlTokenType.XML_PI_END;
            }
          // fall through
          case 113: break;
          case 43:
            { yybegin(DOCTYPE_COMMENT); return XmlTokenType.XML_COMMENT_START;
            }
          // fall through
          case 114: break;
          case 44:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_COMMENT_END;
            }
          // fall through
          case 115: break;
          case 45:
            { return XmlTokenType.XML_ENTITY_REF_TOKEN;
            }
          // fall through
          case 116: break;
          case 46:
            { yybegin(CONDITIONAL); return XmlTokenType.XML_CONDITIONAL_SECTION_START;
            }
          // fall through
          case 117: break;
          case 47:
            { yybegin(YYINITIAL); return XmlTokenType.XML_CONDITIONAL_SECTION_END;
            }
          // fall through
          case 118: break;
          case 48:
            { yybegin(YYINITIAL); return XmlTokenType.XML_COMMENT_END;
            }
          // fall through
          case 119: break;
          case 49:
            { return XmlTokenType.XML_CONTENT_ANY;
            }
          // fall through
          case 120: break;
          case 50:
            { yybegin(YYINITIAL); return XmlTokenType.XML_CDATA_END;
            }
          // fall through
          case 121: break;
          case 51:
            { return XmlTokenType.XML_CHAR_ENTITY_REF;
            }
          // fall through
          case 122: break;
          case 52:
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_START;
            }
          // fall through
          case 123: break;
          case 53:
            { yybegin(DOCTYPE_MARKUP_STARTED); yypushback(yylength());
            }
          // fall through
          case 124: break;
          case 54:
            { return XmlTokenType.XML_CONTENT_EMPTY;
            }
          // fall through
          case 125: break;
          case 55:
            { yybegin(DECL); return XmlTokenType.XML_DECL_START;
            }
          // fall through
          case 126: break;
          case 56:
            { yybegin(DOCTYPE_EXTERNAL_ID); return XmlTokenType.XML_DOCTYPE_PUBLIC;
            }
          // fall through
          case 127: break;
          case 57:
            { yybegin(DOCTYPE_EXTERNAL_ID); return XmlTokenType.XML_DOCTYPE_SYSTEM;
            }
          // fall through
          case 128: break;
          case 58:
            { return XmlTokenType.XML_ATT_FIXED;
            }
          // fall through
          case 129: break;
          case 59:
            { return XmlTokenType.XML_DOCTYPE_PUBLIC;
            }
          // fall through
          case 130: break;
          case 60:
            { return XmlTokenType.XML_DOCTYPE_SYSTEM;
            }
          // fall through
          case 131: break;
          case 61:
            { return XmlTokenType.XML_CONDITIONAL_IGNORE;
            }
          // fall through
          case 132: break;
          case 62:
            { return XmlTokenType.XML_PCDATA;
            }
          // fall through
          case 133: break;
          case 63:
            { return XmlTokenType.XML_CONDITIONAL_INCLUDE;
            }
          // fall through
          case 134: break;
          case 64:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_ENTITY_DECL_START;
            }
          // fall through
          case 135: break;
          case 65:
            { return XmlTokenType.XML_ATT_IMPLIED;
            }
          // fall through
          case 136: break;
          case 66:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_ATTLIST_DECL_START;
            }
          // fall through
          case 137: break;
          case 67:
            { yybegin(DOCTYPE); return XmlTokenType.XML_DOCTYPE_START;
            }
          // fall through
          case 138: break;
          case 68:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_ELEMENT_DECL_START;
            }
          // fall through
          case 139: break;
          case 69:
            { yybegin(CDATA); return XmlTokenType.XML_CDATA_START;
            }
          // fall through
          case 140: break;
          case 70:
            { return XmlTokenType.XML_ATT_REQUIRED;
            }
          // fall through
          case 141: break;
          case 71:
            { yybegin(DOCTYPE_MARKUP); return XmlTokenType.XML_NOTATION_DECL_START;
            }
          // fall through
          case 142: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
