/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0004H\u0002\"2\u0010\u0000\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"REPARSE_XML_TAG_BY_NAME", "Lcom/intellij/util/TripleFunction;", "Lcom/intellij/lang/ASTNode;", "Lcom/intellij/lang/LighterASTNode;", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/util/ThreeState;", "getREPARSE_XML_TAG_BY_NAME", "()Lcom/intellij/util/TripleFunction;", "reparseXmlTagByName", "oldNode", "newNode", "structure", "intellij.xml.parser"})
public final class XmlParserKt {
    @NotNull
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> REPARSE_XML_TAG_BY_NAME = XmlParserKt::reparseXmlTagByName;

    @NotNull
    public static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> getREPARSE_XML_TAG_BY_NAME() {
        return REPARSE_XML_TAG_BY_NAME;
    }

    private static final ThreeState reparseXmlTagByName(ASTNode oldNode, LighterASTNode newNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        if (!(oldNode instanceof PsiNamedElement) || oldNode.getElementType() != XmlElementType.XML_TAG || newNode.getTokenType() != XmlElementType.XML_TAG) {
            return ThreeState.UNSURE;
        }
        String oldName = ((PsiNamedElement)oldNode).getName();
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref childrenRef = ref;
        int count = structure.getChildren((Object)newNode, childrenRef);
        if (count < 3) {
            return ThreeState.UNSURE;
        }
        Object object = childrenRef.get();
        Intrinsics.checkNotNull((Object)object);
        LighterASTNode[] children = (LighterASTNode[])object;
        if (children[0].getTokenType() != XmlTokenType.XML_START_TAG_START) {
            return ThreeState.UNSURE;
        }
        if (children[1].getTokenType() != XmlTokenType.XML_NAME) {
            return ThreeState.UNSURE;
        }
        if (children[2].getTokenType() != XmlTokenType.XML_TAG_END) {
            return ThreeState.UNSURE;
        }
        LighterASTNode lighterASTNode = children[1];
        Intrinsics.checkNotNull((Object)lighterASTNode, (String)"null cannot be cast to non-null type com.intellij.lang.LighterASTTokenNode");
        LighterASTTokenNode name = (LighterASTTokenNode)lighterASTNode;
        CharSequence newName = name.getText();
        if (Comparing.equal((CharSequence)oldName, (CharSequence)newName)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }
}

